/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.Stopwatch;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.DefaultContainerResourceSetFinder;
import org.teiid.designer.core.container.ResourceSetFinder;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.EmfResourceSet;
import org.teiid.designer.core.util.OverflowingLRUCache;
import org.teiid.designer.core.workspace.ModelBuffer;
import org.teiid.designer.core.workspace.ModelBufferCache;
import org.teiid.designer.core.workspace.ModelBufferFactory;
import org.teiid.designer.core.workspace.ModelBufferImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.Openable;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class ModelBufferManager
implements ModelBufferFactory {
    protected static final int DEFAULT_MODEL_BUFFER_CACHE_LIMIT = 300;
    private static ModelBufferManager DEFAULT_MODEL_BUFFER_MANAGER;
    private final OverflowingLRUCache openBuffers;
    private ResourceSetFinder resourceSetFinder;
    private final Map emfResourceToModelResource;

    public static synchronized ModelBufferManager getDefaultBufferManager() {
        if (DEFAULT_MODEL_BUFFER_MANAGER == null) {
            DEFAULT_MODEL_BUFFER_MANAGER = new ModelBufferManager();
        }
        return DEFAULT_MODEL_BUFFER_MANAGER;
    }

    public ModelBufferManager() {
        this(300);
    }

    protected ModelBufferManager(int cacheSize) {
        Stopwatch stopwatch = null;
        if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
            stopwatch = new Stopwatch();
            stopwatch.start();
        }
        this.openBuffers = new ModelBufferCache(cacheSize);
        this.resourceSetFinder = new DefaultContainerResourceSetFinder();
        if (ModelerCore.DEBUG_MODEL_WORKSPACE) {
            stopwatch.stop();
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ModelBufferManager.Time_to_create_ModelBufferManager", (Object)stopwatch));
        }
        this.emfResourceToModelResource = new HashMap();
    }

    protected void registerEmfResource(Resource resource, Openable openable) {
        this.emfResourceToModelResource.put(resource, openable);
    }

    protected void unregisterEmfResource(Resource resource) {
        this.emfResourceToModelResource.remove(resource);
    }

    protected ModelResource getModelResource(Resource resource) {
        ModelResource result = (ModelResource)this.emfResourceToModelResource.get(resource);
        if (result == null) {
            ModelResource mResource;
            block26: {
                IFile resourceFile;
                block25: {
                    Path path;
                    block24: {
                        URI normalizedUri;
                        Container container;
                        ResourceSet resourceSet;
                        block23: {
                            resourceSet = resource.getResourceSet();
                            container = null;
                            if (resourceSet instanceof EmfResourceSet) {
                                container = ((EmfResourceSet)resourceSet).getContainer();
                            } else if (resource instanceof EmfResource) {
                                container = ((EmfResource)resource).getContainer();
                            }
                            if (container != null && container == ModelerCore.getModelContainer()) break block23;
                            return null;
                        }
                        try {
                            resourceSet = container;
                        }
                        catch (CoreException e2) {
                            ModelerCore.Util.log((Throwable)e2);
                        }
                        URI resourceURI = resource.getURI();
                        String fileString = null;
                        if (resourceURI.isFile()) {
                            fileString = resourceURI.toFileString();
                        } else {
                            IResource iResource = WorkspaceResourceFinderUtil.findIResource(resourceURI);
                            if (iResource != null) {
                                fileString = iResource.getLocation().toOSString();
                            }
                        }
                        if (fileString == null) {
                            try {
                                URL fileUrl = new URL(resourceURI.toString());
                                URL resolvedFileUrl = FileLocator.resolve((URL)fileUrl);
                                if (resolvedFileUrl != null) {
                                    fileString = resolvedFileUrl.getFile();
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                            }
                            catch (IOException e1) {
                                ModelerCore.Util.log((Throwable)e1);
                            }
                        }
                        if (fileString == null && "file".equals((normalizedUri = resourceSet.getURIConverter().normalize(resourceURI)).scheme())) {
                            fileString = normalizedUri.toFileString();
                        }
                        if (fileString == null) {
                            return null;
                        }
                        path = new Path(fileString);
                        if (ResourcesPlugin.getPlugin() != null) break block24;
                        return null;
                    }
                    IWorkspaceRoot wsRoot = ModelerCore.getWorkspace().getRoot();
                    resourceFile = wsRoot.getFileForLocation((IPath)path);
                    if (resourceFile == null) {
                        resourceFile = wsRoot.getFile((IPath)path);
                    }
                    if (resourceFile != null) break block25;
                    return null;
                }
                ModelWorkspaceManager mgr = ModelWorkspaceManager.getModelWorkspaceManager();
                mResource = (ModelResource)mgr.findModelWorkspaceItem((IResource)resourceFile);
                if (mResource != null) break block26;
                return null;
            }
            try {
                mResource.open(null);
                result = mResource;
            }
            catch (Throwable e) {
                ModelerCore.Util.log(e);
            }
        }
        return result;
    }

    OverflowingLRUCache getOpenBufferCache() {
        return this.openBuffers;
    }

    @Override
    public ModelBuffer createBuffer(Openable owner) throws ModelWorkspaceException {
        CoreArgCheck.isInstanceOf(ModelWorkspaceItem.class, (Object)owner);
        ModelWorkspaceItem item = (ModelWorkspaceItem)((Object)owner);
        IResource resource = item.getResource();
        ResourceSet emfResourceSet = this.resourceSetFinder.getResourceSet(resource);
        ModelBufferImpl buffer = new ModelBufferImpl(resource instanceof IFile ? (IFile)resource : null, owner, emfResourceSet, item.isReadOnly());
        return buffer;
    }

    protected void addBuffer(ModelBuffer buffer) {
        this.openBuffers.put(buffer.getOwner(), buffer);
    }

    public ModelBuffer getOpenBuffer(Openable owner) {
        CoreArgCheck.isNotNull((Object)owner);
        return (ModelBuffer)this.openBuffers.get(owner);
    }

    public ModelBufferFactory getDefaultBufferFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            return new LinkedList(this.openBuffers.values()).iterator();
        }
    }

    protected void removeBuffer(ModelBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }

    public ResourceSetFinder getResourceSetFinder() {
        return this.resourceSetFinder;
    }
}

