/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;

public class StringLengthRule
implements StructuralFeatureValidationRule {
    private int maxStringLength = 255;
    private final int featureID;

    public StringLengthRule(int maxStringLength, int featureID) {
        this.maxStringLength = maxStringLength;
        this.featureID = featureID;
    }

    public StringLengthRule(int featureID) {
        this.featureID = featureID;
    }

    @Override
    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (value == null) {
            return;
        }
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String name = (String)value;
        ValidationResultImpl result = new ValidationResultImpl(eObject);
        CoreValidationRulesUtil.validateStringLength(result, this.maxStringLength, name);
        context.addResult(result);
    }
}

