/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class ResourceInScopeValidationRule
implements StructuralFeatureValidationRule {
    @Override
    public void validate(EStructuralFeature theStructuralFeature, EObject theObject, Object theValue, ValidationContext theContext) {
        if (theStructuralFeature instanceof EReference && theValue != null) {
            if (theValue instanceof EObject) {
                this.validateReferenceValue(theStructuralFeature, theObject, (EObject)theValue, theContext);
            } else if (theValue instanceof Collection) {
                Collection theValues = (Collection)theValue;
                for (EObject value : theValues) {
                    this.validateReferenceValue(theStructuralFeature, theObject, value, theContext);
                }
            }
        }
    }

    private void validateReferenceValue(EStructuralFeature theStructuralFeature, EObject theObject, EObject theValue, ValidationContext theContext) {
        if (theValue != null) {
            Resource resource = theValue.eResource();
            if (resource != null && theObject.eResource().equals(resource)) {
                return;
            }
            if (resource == null && theValue.eIsProxy()) {
                Container container = ModelerCore.getContainer(theObject);
                URI valueURI = ((InternalEObject)theValue).eProxyURI().trimFragment();
                if (valueURI.isRelative() && valueURI.hasRelativePath()) {
                    URI objectURI = theObject.eResource().getURI();
                    URI resolvedURI = valueURI.resolve(objectURI);
                    resource = container.getResource(resolvedURI, false);
                }
                if (resource == null) {
                    resource = ModelerCore.getModelEditor().findResource(container, theValue);
                }
            }
            if (EcorePackage.eINSTANCE.getEPackage_EFactoryInstance() == theStructuralFeature) {
                return;
            }
            if (resource == null) {
                String uri = theValue.eIsProxy() ? ((InternalEObject)theValue).eProxyURI().trimFragment().toString() : theValue.toString();
                String msg = ModelerCore.Util.getString(String.valueOf(I18nUtil.getPropertyPrefix((Object)this)) + "unresolvedReference", (Object)uri);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                ValidationResultImpl result = new ValidationResultImpl(theObject);
                result.addProblem(problem);
                theContext.addResult(result);
            } else {
                if (WorkspaceResourceFinderUtil.isGlobalResource(resource.getURI().toString())) {
                    return;
                }
                Resource[] validResources = theContext.getResourcesInScope();
                if (validResources.length > 0) {
                    boolean valid = false;
                    int i = 0;
                    while (i < validResources.length) {
                        if (validResources[i].equals(resource)) {
                            valid = true;
                            break;
                        }
                        ++i;
                    }
                    if (!valid) {
                        String wsUri = WorkspaceResourceFinderUtil.getWorkspaceUri(resource);
                        String uri = wsUri != null ? wsUri : resource.getURI().toString();
                        String msg = ModelerCore.Util.getString(String.valueOf(I18nUtil.getPropertyPrefix((Object)this)) + "resourceOutOfScope", (Object)uri);
                        ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                        ValidationResultImpl result = new ValidationResultImpl(theObject);
                        result.addProblem(problem);
                        theContext.addResult(result);
                    }
                }
            }
        }
    }
}

