/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation.rules;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class EmfResourceValidationRule
implements ResourceValidationRule {
    @Override
    public void validate(Resource resource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)context);
        if (resource instanceof XSDResourceImpl) {
            return;
        }
        ModelContents contents = new ModelContents(resource);
        ModelAnnotation annotation = contents.getModelAnnotation();
        if (annotation != null) {
            ValidationResultImpl result = new ValidationResultImpl(annotation);
            EList errors = resource.getErrors();
            HashSet<String> messages = new HashSet<String>();
            if (!errors.isEmpty()) {
                for (Resource.Diagnostic errDiagnostic : errors) {
                    String diagMessage = errDiagnostic.getMessage();
                    if (messages.contains(diagMessage)) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, errDiagnostic.getMessage());
                    result.addProblem(problem);
                    messages.add(diagMessage);
                }
            } else {
                EList warnings = resource.getWarnings();
                for (Resource.Diagnostic warnDiagnostic : warnings) {
                    String diagMessage = warnDiagnostic.getMessage();
                    if (messages.contains(diagMessage)) continue;
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, warnDiagnostic.getMessage());
                    result.addProblem(problem);
                    messages.add(diagMessage);
                }
            }
            if (result.hasProblems()) {
                context.addResult(result);
            }
        }
    }
}

