/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.LRUCache;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.ValidationAspect;
import org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules.DeletedXmlRelationalExtensionRule;
import org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules.DeletedXmlRelationalImportRule;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationRule;
import org.teiid.designer.core.validation.ValidationRuleSet;
import org.teiid.designer.core.validation.ValidationRuleSetImpl;
import org.teiid.designer.core.validation.rules.EObjectUuidRule;
import org.teiid.designer.core.validation.rules.EmfResourceValidationRule;
import org.teiid.designer.core.validation.rules.ModelFileExtensionRule;
import org.teiid.designer.core.validation.rules.MultiplicityRule;
import org.teiid.designer.core.validation.rules.ResourceInScopeValidationRule;
import org.teiid.designer.core.validation.rules.TargetTransformationRule;

public class ValidationRuleManager {
    private static final ValidationRule MULTIPLICITY_RULE = new MultiplicityRule();
    private static final ValidationRule FILE_EXTENSION_RULE = new ModelFileExtensionRule();
    private static final ValidationRule TABLE_TRANFORMATION_RULE = new TargetTransformationRule();
    private static final ValidationRule EOBJECT_UUID_RULE = new EObjectUuidRule();
    private static final ValidationRule EMF_RESOURCE_RULE = new EmfResourceValidationRule();
    private static final ValidationRule RESOURCE_IN_SCOPE_RULE = new ResourceInScopeValidationRule();
    private static final ValidationRule DELETED_XML_RELATIONAL_IMPORT_RULE = new DeletedXmlRelationalImportRule();
    private static final ValidationRule DELETED_XML_RELATIONAL_EXTENSION_RULE = new DeletedXmlRelationalExtensionRule();
    private LRUCache cache = new LRUCache();

    public void addRuleSet(EClass eClass, ValidationRuleSet ruleSet) {
        CoreArgCheck.isNotNull((Object)eClass);
        CoreArgCheck.isNotNull((Object)ruleSet);
        this.cache.put((Object)eClass, (Object)ruleSet);
    }

    public void addRuleSet(Resource eResource, ValidationRuleSet ruleSet) {
        CoreArgCheck.isNotNull((Object)eResource);
        CoreArgCheck.isNotNull((Object)ruleSet);
        this.cache.put(eResource.getClass(), (Object)ruleSet);
    }

    public ValidationRuleSet getRuleSet(Object object, ValidationContext context) {
        Class<?> key;
        ValidationRuleSet ruleSet = null;
        if (object instanceof EObject) {
            ValidationAspect validationAspect = AspectManager.getValidationAspect((EObject)object);
            if (validationAspect != null) {
                validationAspect.updateContext((EObject)object, context);
            }
            if (validationAspect == null || validationAspect.shouldValidate((EObject)object, context)) {
                EClass key2 = ((EObject)object).eClass();
                ruleSet = (ValidationRuleSet)this.cache.get((Object)key2);
                if (ruleSet == null) {
                    if (validationAspect != null) {
                        ruleSet = validationAspect.getValidationRules();
                    }
                    if (ruleSet == null) {
                        ruleSet = new ValidationRuleSetImpl();
                    }
                    this.addCoreRules(ruleSet);
                    this.addRuleSet(key2, ruleSet);
                }
            } else if (ModelerCore.DEBUG_VALIDATION) {
                ModelerCore.Util.log(1, "Excluding from validation:" + object);
            }
        } else if (object instanceof Resource && (ruleSet = (ValidationRuleSet)this.cache.get(key = object.getClass())) == null) {
            ruleSet = new ValidationRuleSetImpl();
            this.addResourceRules((Resource)object, ruleSet);
            this.addRuleSet((Resource)object, ruleSet);
        }
        return ruleSet;
    }

    private void addCoreRules(ValidationRuleSet ruleSet) {
        ruleSet.addRule(RESOURCE_IN_SCOPE_RULE);
        ruleSet.addRule(MULTIPLICITY_RULE);
        ruleSet.addRule(EOBJECT_UUID_RULE);
    }

    private void addResourceRules(Resource eResource, ValidationRuleSet ruleSet) {
        if (eResource instanceof EmfResource) {
            ruleSet.addRule(FILE_EXTENSION_RULE);
            ruleSet.addRule(TABLE_TRANFORMATION_RULE);
            ruleSet.addRule(EMF_RESOURCE_RULE);
            ruleSet.addRule(DELETED_XML_RELATIONAL_IMPORT_RULE);
            ruleSet.addRule(DELETED_XML_RELATIONAL_EXTENSION_RULE);
        } else {
            boolean cfr_ignored_0 = eResource instanceof XSDResourceImpl;
        }
    }
}

