/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.teiid.core.designer.util.Base64;
import org.teiid.designer.core.util.FileUrl;

public class URLHelper {
    public static URL buildURL(String url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException();
        }
        String filename = URLHelper.extractFileName(url = URLHelper.convertBackSlashes(url));
        if (filename != null) {
            return new File(url).toURI().toURL();
        }
        return new URL(url);
    }

    public static URL buildURL(URL url) {
        try {
            return URLHelper.buildURL(url.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static String convertBackSlashes(String str) {
        return str.replaceAll("\\\\", "/");
    }

    public static void setCredentials(URLConnection urlConn, String userName, String password) {
        if (userName == null || password == null) {
            return;
        }
        if (!(urlConn instanceof HttpURLConnection)) {
            return;
        }
        urlConn.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])(String.valueOf(userName) + ':' + password).getBytes()));
    }

    public static File createFileFromUrl(URL url, String fileNamePrefix, String fileNameSuffix) throws MalformedURLException, IOException {
        return URLHelper.createFileFromUrlInternal(url, FileUrl.createTempFile(fileNamePrefix, fileNameSuffix), null, null, true);
    }

    public static File createFileFromUrl(URL url, String fileNamePrefix, String fileNameSuffix, String userName, String password) throws MalformedURLException, IOException {
        return URLHelper.createFileFromUrl(url, FileUrl.createTempFile(fileNamePrefix, fileNameSuffix).getAbsolutePath(), userName, password, true);
    }

    public static File createFileFromUrl(URL url, String filePath, String userName, String password, boolean verifyHostname) throws MalformedURLException, IOException {
        File file = null;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (filePath.indexOf("/") != -1 || filePath.indexOf("\\") != -1) {
            String relativeDir;
            File dir;
            int lastPart = filePath.lastIndexOf("/");
            if (lastPart == -1) {
                lastPart = filePath.lastIndexOf("\\");
            }
            if (!(dir = new File(new File(tempDir), relativeDir = filePath.substring(0, lastPart))).exists()) {
                dir.mkdirs();
            }
            file = new File(dir, filePath.substring(lastPart + 1));
        } else {
            file = new File(new File(tempDir), filePath);
        }
        return URLHelper.createFileFromUrlInternal(url, new FileUrl(file.toURI()), userName, password, verifyHostname);
    }

    private static File createFileFromUrlInternal(URL url, File file, String userName, String password, boolean verifyHostname) throws MalformedURLException, IOException {
        URLConnection urlConn = null;
        InputStreamReader inStream = null;
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            int c;
            file.deleteOnExit();
            ((FileUrl)file).setOriginalUrlString(url.toString());
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            urlConn = url.openConnection();
            URLHelper.setCredentials(urlConn, userName, password);
            if (!verifyHostname && urlConn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg, SSLSession session) {
                        return true;
                    }
                });
            }
            inStream = new InputStreamReader(urlConn.getInputStream());
            while ((c = inStream.read()) != -1) {
                bw.write(c);
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        return file;
    }

    static String extractFileName(String file) {
        if (file.matches("^(\\w){2,}:.*")) {
            return null;
        }
        if (file.matches("^\\/.*")) {
            return file;
        }
        if (file.matches("^\\w:[\\\\,\\/].*")) {
            file = file.replaceAll("\\\\", "\\/");
            return "/" + file;
        }
        if (file.matches("^(\\.)+\\/.*|^\\w+\\/.*|^\\w+.*")) {
            return file;
        }
        return null;
    }

    public static boolean resolveUrl(URL url) throws MalformedURLException, IOException {
        return URLHelper.resolveUrl(url, true);
    }

    public static boolean resolveUrl(URL url, boolean verifyHostname) throws MalformedURLException, IOException {
        return URLHelper.resolveUrl(url, null, null, null, verifyHostname);
    }

    public static boolean resolveUrl(URL url, String userName, String password, Map<String, String> connRequestPropMap, boolean verifyHostname) throws MalformedURLException, IOException {
        boolean resolved = true;
        if (url == null) {
            return resolved;
        }
        URLConnection urlConn = null;
        InputStreamReader inStream = null;
        BufferedReader buff = null;
        long startTime = System.currentTimeMillis();
        long deltaTime = 0L;
        try {
            urlConn = url.openConnection();
            URLHelper.setCredentials(urlConn, userName, password);
            if (!verifyHostname && urlConn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg, SSLSession session) {
                        return true;
                    }
                });
            }
            urlConn.setDoInput(true);
            if (connRequestPropMap != null) {
                for (String propName : connRequestPropMap.keySet()) {
                    urlConn.setRequestProperty(propName, connRequestPropMap.get(propName));
                }
            }
            inStream = new InputStreamReader(urlConn.getInputStream());
            buff = new BufferedReader(inStream);
            boolean keepReading = true;
            while (keepReading) {
                String nextLine = buff.readLine();
                if (nextLine == null) {
                    break;
                }
                deltaTime = System.currentTimeMillis() - startTime;
                if (deltaTime <= 30000L) continue;
                keepReading = false;
                resolved = false;
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return resolved;
    }
}

