/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.INewModelObjectHelper;

public abstract class NewModelObjectHelperManager {
    private static final String ID = "newModelObjectHelper";
    private static final String CLASS = "class";
    private static final String CLASSNAME = "name";
    private static List helpersCache;
    private static boolean helpersLoaded;

    static {
        helpersLoaded = false;
    }

    public static INewModelObjectHelper[] getHelpers(Object newObject) {
        CoreArgCheck.isNotNull((Object)newObject);
        HashSet<INewModelObjectHelper> helpers = new HashSet<INewModelObjectHelper>();
        if (!helpersLoaded) {
            NewModelObjectHelperManager.loadHelperExtensions();
        }
        if (helpersCache != null) {
            INewModelObjectHelper nextHelper2 = null;
            for (INewModelObjectHelper nextHelper2 : helpersCache) {
                if (!nextHelper2.canHelpCreate(newObject)) continue;
                helpers.add(nextHelper2);
            }
        }
        return helpers.toArray(new INewModelObjectHelper[helpers.size()]);
    }

    private static void loadHelperExtensions() {
        helpersCache = new ArrayList();
        helpersLoaded = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.core", ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object helper;
                    if (elements[j].getName().equals(CLASS) && (helper = elements[j].createExecutableExtension(CLASSNAME)) instanceof INewModelObjectHelper) {
                        helpersCache.add(helper);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = ModelerCore.Util.getString("NewModelObjectHelperManager.loadHelperExtensionsErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                ModelerCore.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }

    public static boolean helpCreate(Object newObject, Map properties) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)newObject);
        boolean canUndo = true;
        INewModelObjectHelper[] helpers = NewModelObjectHelperManager.getHelpers(newObject);
        boolean undoHelp = true;
        int i = 0;
        while (i < helpers.length) {
            undoHelp = helpers[i].helpCreate(newObject, properties);
            if (!undoHelp && canUndo) {
                canUndo = false;
            }
            ++i;
        }
        return canUndo;
    }
}

