/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ImportUtilities;
import org.teiid.designer.core.util.ProcessedNotificationResult;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;

public class ExternalResourceImportsHelper {
    public static ProcessedNotificationResult processNotification(Notification theNotification) {
        int i;
        Resource resource = null;
        Object notifier = theNotification.getNotifier();
        if (notifier instanceof Resource) {
            resource = (Resource)notifier;
            int featureId = theNotification.getFeatureID(resource.getClass());
            if (theNotification.getEventType() == 8 || featureId == 4 || featureId == 3 || featureId == 0 || ExternalResourceImportsHelper.isExternalResourceSetMember(resource)) {
                return null;
            }
        } else if (notifier instanceof EObject) {
            resource = ((EObject)notifier).eResource();
        }
        if (resource == null) {
            return null;
        }
        ProcessedNotificationResult result = new ProcessedNotificationResult(resource);
        boolean wasProcessed = false;
        if (NotificationUtilities.isAdded(theNotification)) {
            EObject[] newChildren = NotificationUtilities.getAddedChildren(theNotification);
            boolean importsWereAdded = false;
            i = 0;
            while (i < newChildren.length) {
                importsWereAdded = ImportUtilities.addMissingImports(resource, newChildren[i]);
                if (importsWereAdded) {
                    result.setImportsWereAdded(true);
                }
                ++i;
            }
            wasProcessed = true;
        } else if (NotificationUtilities.isRemoved(theNotification)) {
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren(theNotification);
            HashSet externalResources = new HashSet();
            i = 0;
            while (i < removedChildren.length) {
                externalResources.addAll(ExternalResourceImportsHelper.findExternalResourceReferences(resource, removedChildren[i]));
                ++i;
            }
            wasProcessed = true;
            if (!externalResources.isEmpty()) {
                result.addDereferencedResources(externalResources);
            }
        }
        if (!wasProcessed) {
            switch (theNotification.getEventType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 1: {
                    Resource refResource;
                    if (!(theNotification.getFeature() instanceof EReference)) break;
                    Object newValue = theNotification.getNewValue();
                    Object oldValue = theNotification.getOldValue();
                    if (newValue != null && oldValue == null) {
                        if (!(newValue instanceof EObject) || ((EObject)newValue).eResource() == null) break;
                        Resource refResource2 = ((EObject)newValue).eResource();
                        boolean importsWereAdded = false;
                        if (resource == refResource2 || !(resource instanceof EmfResource) || !(importsWereAdded = ImportUtilities.addMissingImport(resource, refResource2))) break;
                        result.setImportsWereAdded(true);
                        break;
                    }
                    if (newValue == oldValue) break;
                    if (newValue == null && oldValue != null) {
                        Resource refResource3;
                        if (!(oldValue instanceof EObject) || ((EObject)oldValue).eResource() == null || (refResource3 = ((EObject)oldValue).eResource()) == null || !(resource instanceof EmfResource)) break;
                        result.addDereferencedResource(refResource3);
                        break;
                    }
                    if (newValue == null || oldValue == null) break;
                    if (newValue instanceof EObject && ((EObject)newValue).eResource() != null) {
                        Resource refResource4 = ((EObject)newValue).eResource();
                        boolean importsWereAdded = false;
                        if (resource != refResource4 && resource instanceof EmfResource && (importsWereAdded = ImportUtilities.addMissingImport(resource, refResource4))) {
                            result.setImportsWereAdded(true);
                        }
                    }
                    if (!(oldValue instanceof EObject) || ((EObject)oldValue).eResource() == null || (refResource = ((EObject)oldValue).eResource()) == null || !(resource instanceof EmfResource)) break;
                    result.addDereferencedResource(refResource);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        return result;
    }

    public static void processNotificationResults(Collection notificationResultsList) {
        ProcessedNotificationResult nextResult2 = null;
        for (ProcessedNotificationResult nextResult2 : notificationResultsList) {
            ProcessedNotificationResult tempResult = new ProcessedNotificationResult(nextResult2);
            ExternalResourceImportsHelper.checkRemainingExternalReferences(tempResult);
            for (Resource nextRes : tempResult.getDereferencedResources()) {
                ImportUtilities.removeExistingImport(tempResult.getTargetResource(), nextRes);
            }
        }
    }

    private static boolean isExternalResourceSetMember(Resource theResource) {
        return ModelerCore.isResourceInExternalResourceSet(theResource);
    }

    public static Collection findExternalResourceReferences(Resource notifyingResource, Object target) {
        Collection externalResources = new HashSet();
        if (target instanceof EObject) {
            externalResources = ExternalResourceImportsHelper.findExternalResourceReferences(notifyingResource, (EObject)target);
        } else if (target instanceof Resource) {
            externalResources = ExternalResourceImportsHelper.findExternalResourceReferences((Resource)target);
        } else if (target instanceof ModelResource) {
            externalResources = ExternalResourceImportsHelper.findExternalResourceReferences((ModelResource)target);
        }
        return externalResources;
    }

    private static Collection findExternalResourceReferences(Resource notifyingResource, EObject target) {
        EObject eObject;
        Resource targetResource = target.eResource();
        if (targetResource == null) {
            targetResource = notifyingResource;
        }
        HashSet<Resource> externalResources = new HashSet<Resource>();
        TreeIterator iter = target.eAllContents();
        while (iter.hasNext()) {
            eObject = (EObject)iter.next();
            for (EReference eReference : eObject.eClass().getEAllReferences()) {
                Resource valueResource;
                if (eReference.isContainment() || eReference.isContainer()) continue;
                Object value = eObject.eGet((EStructuralFeature)eReference, false);
                if (eReference.isMany()) {
                    for (Object valueInList : (List)value) {
                        Resource valueResource2;
                        if (valueInList == null || !(valueInList instanceof EObject) || targetResource == (valueResource2 = ((EObject)valueInList).eResource()) || externalResources.contains(valueResource2)) continue;
                        externalResources.add(valueResource2);
                    }
                    continue;
                }
                if (value == null || !(value instanceof EObject)) continue;
                EObject eObj = (EObject)value;
                if (eObj.eIsProxy()) {
                    eObj = EcoreUtil.resolve((EObject)eObj, (ResourceSet)targetResource.getResourceSet());
                }
                if ((valueResource = eObj.eResource()) == null || targetResource == valueResource || externalResources.contains(valueResource)) continue;
                externalResources.add(valueResource);
            }
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)target.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            Resource refResource = eObject.eResource();
            externalResources.add(refResource);
        }
        return externalResources;
    }

    private static void checkRemainingExternalReferences(Resource notifyingResource, EObject target, ProcessedNotificationResult tempResult) {
        EObject eObject;
        Resource targetResource = target.eResource();
        if (targetResource == null) {
            targetResource = notifyingResource;
        }
        TreeIterator iter = target.eAllContents();
        while (iter.hasNext()) {
            eObject = (EObject)iter.next();
            for (EReference eReference : eObject.eClass().getEAllReferences()) {
                if (!eReference.isContainment() && !eReference.isContainer()) {
                    Object value = eObject.eGet((EStructuralFeature)eReference, false);
                    if (eReference.isMany()) {
                        for (Object valueInList : (List)value) {
                            if (valueInList != null && valueInList instanceof EObject) {
                                Resource valueResource = ((EObject)valueInList).eResource();
                                if (tempResult.getDereferencedResources().contains(valueResource)) {
                                    tempResult.removeDereferencedResource(valueResource);
                                }
                            }
                            if (!tempResult.getDereferencedResources().isEmpty()) continue;
                            return;
                        }
                    } else if (value != null && value instanceof EObject) {
                        EObject eObj = (EObject)value;
                        if (eObj.eIsProxy()) {
                            eObj = EcoreUtil.resolve((EObject)eObj, (ResourceSet)targetResource.getResourceSet());
                        }
                        Resource valueResource = eObj.eResource();
                        if (tempResult.getDereferencedResources().contains(valueResource)) {
                            tempResult.removeDereferencedResource(valueResource);
                        }
                    }
                }
                if (!tempResult.getDereferencedResources().isEmpty()) continue;
                return;
            }
            if (!tempResult.getDereferencedResources().isEmpty()) continue;
            return;
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)target.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            Resource refResource = eObject.eResource();
            if (tempResult.getDereferencedResources().contains(refResource)) {
                tempResult.removeDereferencedResource(refResource);
            }
            if (!tempResult.getDereferencedResources().isEmpty()) continue;
            return;
        }
    }

    private static Collection findExternalResourceReferences(ModelResource modelResource) {
        Resource eResource = null;
        try {
            eResource = modelResource.getEmfResource();
        }
        catch (ModelWorkspaceException theException) {
            ModelerCore.Util.log(4, (Throwable)((Object)theException), theException.getLocalizedMessage());
        }
        if (eResource != null) {
            return ExternalResourceImportsHelper.findExternalResourceReferences(eResource);
        }
        return Collections.EMPTY_LIST;
    }

    private static Collection findExternalResourceReferences(Resource resource) {
        HashSet externalResources = new HashSet();
        EList modelContents = resource.getContents();
        Iterator iter = modelContents.iterator();
        while (iter.hasNext()) {
            externalResources.addAll(ExternalResourceImportsHelper.findExternalResourceReferences(resource, (EObject)iter.next()));
        }
        return externalResources;
    }

    private static void checkRemainingExternalReferences(ProcessedNotificationResult tempResult) {
        Resource resource = tempResult.getTargetResource();
        EList modelContents = resource.getContents();
        Iterator iter = modelContents.iterator();
        while (iter.hasNext()) {
            ExternalResourceImportsHelper.checkRemainingExternalReferences(resource, (EObject)iter.next(), tempResult);
            if (!tempResult.getDereferencedResources().isEmpty()) continue;
            return;
        }
    }
}

