/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.transaction;

import java.util.Collection;
import org.eclipse.emf.common.command.CompoundCommand;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.transaction.Undoable;
import org.teiid.designer.core.transaction.UnitOfWork;

public class UndoableImpl
implements Undoable {
    private static final long serialVersionUID = 1L;
    private final CompoundCommand command;
    private final Collection resources;
    private final Object id;
    private final Container container;
    private final Object source;
    private static final int MAX_LABEL_LENGTH = 40;
    private static final int END_LABEL_LENGTH = 25;
    private static final String ELIPSIS = "...";
    private String description;
    private boolean significant;

    public UndoableImpl(Container container, CompoundCommand command, Collection resources, Object id, Object source) {
        CoreArgCheck.isNotNull((Object)container);
        CoreArgCheck.isNotNull((Object)command);
        CoreArgCheck.isNotNull((Object)resources);
        CoreArgCheck.isNotNull((Object)id);
        this.container = container;
        this.command = command;
        this.resources = resources;
        this.id = id;
        this.source = source;
        this.significant = true;
    }

    public UndoableImpl(Container container, CompoundCommand command, Collection resources, Object id) {
        this(container, command, resources, id, null);
    }

    @Override
    public void undo() throws ModelerCoreException {
        if (this.command.canUndo()) {
            boolean requiredStart = false;
            UnitOfWork uow = this.container.getEmfTransactionProvider().getCurrent();
            if (uow.requiresStart()) {
                uow.begin();
                uow.setUndoable(false);
                requiredStart = true;
            }
            this.command.undo();
            if (requiredStart) {
                try {
                    uow.commit();
                }
                catch (ModelerCoreException e) {
                    uow.rollback();
                    throw e;
                }
            }
            return;
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("UndoableImpl.Can_not_perform_undo_for_{0}_1", (Object)this.command.getLabel()));
    }

    @Override
    public boolean canUndo() {
        return this.command.canUndo();
    }

    @Override
    public void redo() throws ModelerCoreException {
        if (this.command.canExecute()) {
            boolean requiredStart = false;
            UnitOfWork uow = this.container.getEmfTransactionProvider().getCurrent();
            if (!uow.isStarted()) {
                uow.begin();
                uow.setUndoable(false);
                requiredStart = true;
            }
            this.command.execute();
            if (requiredStart) {
                try {
                    uow.commit();
                }
                catch (ModelerCoreException e) {
                    uow.rollback();
                    throw e;
                }
            }
            return;
        }
        throw new ModelerCoreException(ModelerCore.Util.getString("UndoableImpl.Can_not_perform_redo_for_{0}_2", (Object)this.command.getLabel()));
    }

    @Override
    public boolean canRedo() {
        return this.command.canExecute();
    }

    @Override
    public void die() {
        this.resources.clear();
        this.significant = true;
    }

    @Override
    public String getPresentationName() {
        if (this.description == null) {
            return this.command.getLabel();
        }
        return this.description;
    }

    @Override
    public String getUndoPresentationName() {
        String undoPresentationName = "";
        undoPresentationName = this.description == null ? StringUtilities.condenseToLength((String)this.command.getLabel(), (int)40, (int)25, (String)ELIPSIS) : StringUtilities.condenseToLength((String)this.description, (int)40, (int)25, (String)ELIPSIS);
        return String.valueOf(ModelerCore.Util.getString("UndoableImpl.Undo__3", new Object[0])) + undoPresentationName;
    }

    @Override
    public String getRedoPresentationName() {
        String undoPresentationName = "";
        undoPresentationName = this.description == null ? StringUtilities.condenseToLength((String)this.command.getLabel(), (int)40, (int)25, (String)ELIPSIS) : StringUtilities.condenseToLength((String)this.description, (int)40, (int)25, (String)ELIPSIS);
        return String.valueOf(ModelerCore.Util.getString("UndoableImpl.Redo__4", new Object[0])) + undoPresentationName;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public Collection getResources() {
        return this.resources;
    }

    public CompoundCommand getCommand() {
        return this.command;
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        return this.command.toString();
    }

    @Override
    public boolean isSignificant() {
        return this.significant;
    }

    @Override
    public void setSignificant(boolean isSignificant) {
        this.significant = isSignificant;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Object getSource() {
        return this.source;
    }
}

