/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IndexConstants;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.search.commands.FindTypedObjectCommand;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;

public class FindTypedObjectCommandImpl
implements FindTypedObjectCommand {
    private static final EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    private EClass metaClass = null;
    private EObject datatype = null;
    private EObject[] subtypes;
    private String runtimeType = null;
    private Collection recordInfos = Collections.EMPTY_LIST;
    private IndexSelector selector = null;

    public FindTypedObjectCommandImpl() {
        this.subtypes = EMPTY_EOBJECT_ARRAY;
    }

    @Override
    public Collection getRecordInfo() {
        return this.recordInfos;
    }

    @Override
    public void setMetaClass(EClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public void setDatatype(EObject datatype) {
        this.datatype = datatype;
    }

    @Override
    public void setRuntimeType(String runtimeType) {
        this.runtimeType = runtimeType;
    }

    @Override
    public void setSubTypes(EObject[] subTypes) {
        this.subtypes = subTypes;
    }

    @Override
    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    @Override
    public boolean canExecute() {
        return this.datatype != null || this.runtimeType != null;
    }

    @Override
    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        try {
            String typeName = FindTypedObjectCommandImpl.getDatatypeName(this.datatype);
            String runtimeTypeName = this.runtimeType;
            String metaclassUri = FindTypedObjectCommandImpl.getMetaclassUri(this.metaClass);
            String matchPattern = this.getMatchPattern(typeName, runtimeTypeName, metaclassUri);
            IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
            this.recordInfos = new ArrayList(results.length);
            int i = 0;
            while (i < results.length) {
                IEntryResult result = results[i];
                this.recordInfos.add(SearchRuntimeAdapter.getSearchRecord(result.getWord()));
                ++i;
            }
            if (this.subtypes != null && this.subtypes.length > 0) {
                int j = 0;
                while (j != this.subtypes.length) {
                    typeName = FindTypedObjectCommandImpl.getDatatypeName(this.subtypes[j]);
                    matchPattern = this.getMatchPattern(typeName, runtimeTypeName, metaclassUri);
                    results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
                    int i2 = 0;
                    while (i2 < results.length) {
                        IEntryResult result = results[i2];
                        this.recordInfos.add(SearchRuntimeAdapter.getSearchRecord(result.getWord()));
                        ++i2;
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
            String msg = ModelerCore.Util.getString("FindTypedObjectCommandImpl.Error_trying_to_execute_command", new Object[0]);
            return new Status(4, "org.teiid.designer.core", 0, msg, (Throwable)e);
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    private String getMatchPattern(String typeName, String runtimeTypeName, String metaClassUri) {
        String pattern = null;
        String datatypeCriteria = typeName != null && typeName.length() != 0 ? typeName : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        String runtimeTypeCriteria = runtimeTypeName != null && runtimeTypeName.length() != 0 ? runtimeTypeName : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        String metaclassCriteria = metaClassUri != null && metaClassUri.length() != 0 ? metaClassUri : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        pattern = "I\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + datatypeCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + runtimeTypeCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + metaclassCriteria + '\u00a0';
        return pattern;
    }

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    private static String getDatatypeName(EObject type) {
        SqlDatatypeAspect sqlAspect = FindTypedObjectCommandImpl.getSqlAspect(type);
        if (sqlAspect != null) {
            return sqlAspect.getName(type);
        }
        return null;
    }

    private static String getMetaclassUri(EClass eClass) {
        if (eClass != null) {
            return ModelerCore.getModelEditor().getUri((EObject)eClass).toString();
        }
        return null;
    }

    private static SqlDatatypeAspect getSqlAspect(EObject obj) {
        if (obj != null && obj instanceof XSDSimpleTypeDefinition) {
            return (SqlDatatypeAspect)ModelerCore.getMetamodelRegistry().getMetamodelAspect(obj, SqlAspect.class);
        }
        return null;
    }
}

