/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IndexConstants;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.search.commands.FindRelatedObjectsCommandImpl;
import org.teiid.designer.core.search.commands.FindRelationshipTypesCommandImpl;
import org.teiid.designer.core.search.commands.FindRelationshipsCommand;
import org.teiid.designer.core.search.commands.SearchCommand;
import org.teiid.designer.core.search.runtime.RelatedObjectRecord;
import org.teiid.designer.core.search.runtime.RelationshipRecord;
import org.teiid.designer.core.search.runtime.RelationshipTypeRecord;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;

public class FindRelationshipsCommandImpl
implements FindRelationshipsCommand {
    private String relationshipTypeName = null;
    private String namePattern = null;
    private String relationshipUUID = null;
    private List participantList = null;
    private List relationshipScope = null;
    private boolean caseSensitive = false;
    private boolean includeSubtypes = false;
    private Collection relationsInfo = Collections.EMPTY_LIST;
    private IndexSelector selector;

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    @Override
    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    @Override
    public boolean canExecute() {
        return this.participantList == null || !this.participantList.isEmpty();
    }

    @Override
    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        try {
            if (!CoreStringUtil.isEmpty((String)this.relationshipUUID)) {
                String prefix = IndexUtil.getPrefixPattern('E', this.relationshipUUID);
                IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), prefix.toCharArray(), true, true);
                this.relationsInfo = new HashSet(results.length);
                int i = 0;
                while (i < results.length) {
                    IEntryResult result = results[i];
                    this.relationsInfo.add(SearchRuntimeAdapter.createRelationshipRecord(result.getWord()));
                    ++i;
                }
            } else {
                IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), this.getNameSearchPattern().toCharArray(), false, false);
                this.relationsInfo = new HashSet(results.length);
                int i = 0;
                while (i < results.length) {
                    IEntryResult result = results[i];
                    this.relationsInfo.add(SearchRuntimeAdapter.createRelationshipRecord(result.getWord()));
                    ++i;
                }
                this.postFilter();
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
            return new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("FindRelationshipsCommandImpl.Error_trying_to_execute_command,_problem_trying_to_query_relationship_search_indexes._1", new Object[0]), (Throwable)e);
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    private String getNameSearchPattern() {
        String pattern = null;
        if (this.namePattern == null) {
            this.namePattern = "";
        }
        pattern = this.caseSensitive ? "E\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + this.namePattern + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING : "E\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + this.namePattern.toUpperCase() + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0';
        return pattern;
    }

    public void postFilter() {
        HashSet<RelationshipRecord> filteredResults = new HashSet<RelationshipRecord>();
        block0: for (RelationshipRecord record : this.relationsInfo) {
            IStatus status;
            SearchCommand command;
            if (this.relationshipScope != null) {
                for (ModelWorkspaceItem item : this.relationshipScope) {
                    String resourcePath = item.getPath().toString();
                    if (record.getResourcePath().equals(resourcePath)) continue;
                }
            }
            if (!CoreStringUtil.isEmpty((String)this.relationshipTypeName)) {
                command = new FindRelationshipTypesCommandImpl();
                command.setIndexSelector(this.selector);
                command.setRelationshipTypeName(this.relationshipTypeName);
                command.setIncludeSubTypes(this.includeSubtypes);
                status = command.execute();
                Collection typeInfo = null;
                if (status != null && !status.isOK()) continue;
                typeInfo = command.getRelationShipTypeInfo();
                boolean foundMatch = false;
                for (RelationshipTypeRecord typeRecord : typeInfo) {
                    if (!record.getTypeName().equals(typeRecord.getName())) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
            }
            if (this.participantList != null) {
                command = new FindRelatedObjectsCommandImpl();
                command.setIndexSelector(this.selector);
                status = command.execute();
                Collection relInfo = null;
                if (status == null || status.isOK()) {
                    relInfo = command.getRelatedObjectInfo();
                }
                if (this.participantList != null) {
                    for (String participantPath : this.participantList) {
                        boolean foundMatch = false;
                        for (RelatedObjectRecord relRecord : relInfo) {
                            if (!record.getUUID().equals(relRecord.getRelationshipUUID()) || !relRecord.getResourcePath().equals(participantPath) && !relRecord.getRelatedResourcePath().equals(participantPath)) continue;
                            foundMatch = true;
                            break;
                        }
                        if (!foundMatch) continue block0;
                    }
                }
            }
            filteredResults.add(record);
        }
        this.relationsInfo.clear();
        this.relationsInfo.addAll(filteredResults);
    }

    @Override
    public Collection getRelationShipInfo() {
        return this.relationsInfo;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    @Override
    public void setParticipantList(List participantList) {
        this.participantList = participantList;
    }

    @Override
    public void setRelationshipResourceScopeList(List scopeResourceList) {
        this.relationshipScope = scopeResourceList;
    }

    @Override
    public void setIncludeSubtypes(boolean includeSubtypes) {
        this.includeSubtypes = includeSubtypes;
    }

    @Override
    public void setRelationshipTypeName(String relationshipTypeName) {
        this.relationshipTypeName = relationshipTypeName;
    }

    @Override
    public void setRelationshipUUID(String uuid) {
        this.relationshipUUID = uuid;
    }
}

