/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource.xmi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.container.ObjectManager;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.EmfResourceSet;
import org.teiid.designer.core.resource.XResource;
import org.teiid.designer.core.resource.XmlXResourceDelegate;
import org.teiid.designer.core.resource.xmi.MtkXmiHelper;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceLoader;
import org.teiid.designer.core.resource.xmi.MtkXmiSaveImpl;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.Identifiable;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;

public class MtkXmiResourceImpl
extends XMIResourceImpl
implements EmfResource,
XResource {
    public static final char UUID_PROTOCOL_DELIMITER = '/';
    public static final Map<EObject, String> DETACHED_EOBJECT_TO_UUID_MAP = XMLResourceImpl.DETACHED_EOBJECT_TO_ID_MAP;
    public static final Map<String, EObject> DETACHED_UUID_TO_EOBJECT_MAP = Collections.synchronizedMap(new WeakHashMap());
    private Container container;
    private MetamodelRegistry registry;
    private ObjectManager objectManager;
    private List prefixesToURIs;
    private ModelContents modelContents;
    private XmlXResourceDelegate delegate = new XmlXResourceDelegate();

    public MtkXmiResourceImpl(URI uri) {
        super(uri);
        if (uri == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_URI_reference_may_not_be_null_1", new Object[0]));
        }
        this.modelContents = new ModelContents((Resource)this);
        this.prefixesToURIs = new ArrayList();
        this.delegate.initialize((XMLResource)this);
    }

    protected void attachedHelper(EObject eObject) {
        if (this.isTrackingModification()) {
            eObject.eAdapters().add((Object)this.modificationTrackingAdapter);
        }
        this.delegate.attachedHelper((XMLResource)this, eObject);
    }

    protected void detachedHelper(EObject eObject) {
        this.delegate.detachedHelper((XMLResource)this, eObject);
        if (this.isTrackingModification()) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return true;
    }

    @Override
    public boolean isLoading() {
        return this.delegate.isLoading();
    }

    @Override
    public boolean isUnloading() {
        return this.delegate.isUnloading();
    }

    public void load(Map options) throws IOException {
        XMIHeader header;
        File f;
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.MtkXMIResourceImpl.load(Map)_1", new Object[0]));
        }
        this.modelContents = new ModelContents((Resource)this);
        if (this.uri != null && this.uri.isFile() && (f = new File(this.uri.toFileString())).exists() && (header = ModelFileUtil.getXmiHeader((File)f)) != null && header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
            Object[] params = new Object[]{this.uri};
            String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.The_file,_0,_is_an_older_model_format_that_must_be_converted._1", params);
            ModelerCore.Util.log(4, msg);
            return;
        }
        UnitOfWork txn = null;
        boolean selfStarted = false;
        if (this.container != null && !(txn = this.container.getEmfTransactionProvider().getCurrent()).isStarted()) {
            try {
                txn.begin();
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
            selfStarted = true;
        }
        URI uri = super.getURI();
        MetamodelRegistry registry = this.getMetamodelRegistry();
        if (registry != null && registry.containsURI(uri)) {
            Resource r = this.registry.getResource(uri);
            CoreArgCheck.isTrue((boolean)r.isLoaded(), (String)("Resource " + r.getURI() + " must be loaded"));
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Loading_model_using_URI_3", new Object[]{uri}));
        }
        super.load(options);
        if (selfStarted) {
            try {
                txn.commit();
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Returning_from_MtkXMIResourceImpl.load(Map)_1", new Object[0]));
        }
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_InputStream_reference_may_not_be_null_3", new Object[0]));
        }
        if (this.delegate.isLoading()) {
            return;
        }
        this.delegate.setLoading(true);
        try {
            if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.MtkXMIResourceImpl.doLoad(InputStream,Map)_4", new Object[0]));
            }
            this.modelContents = new ModelContents((Resource)this);
            UnitOfWork txn = null;
            boolean selfStarted = false;
            if (this.container != null && !(txn = this.container.getEmfTransactionProvider().getCurrent()).isStarted()) {
                try {
                    txn.begin();
                }
                catch (ModelerCoreException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
                selfStarted = true;
            }
            XMLHelper xmiHelper = this.createXMLHelper();
            MtkXmiResourceLoader loader = new MtkXmiResourceLoader(xmiHelper, this.getContainer());
            loader.load((XMLResource)this, inputStream, options == null ? Collections.EMPTY_MAP : options);
            TreeIterator iter = this.getAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (this.getUuid(eObject) != null) continue;
                String uuid = DETACHED_EOBJECT_TO_UUID_MAP.remove(eObject);
                if (uuid == null) {
                    uuid = IDGenerator.getInstance().create().toString();
                } else {
                    DETACHED_UUID_TO_EOBJECT_MAP.remove(uuid);
                }
                this.setID(eObject, uuid);
            }
            if (xmiHelper instanceof MtkXmiHelper) {
                this.prefixesToURIs = ((MtkXmiHelper)xmiHelper).getPrefixesToURIs();
            }
            if (selfStarted) {
                try {
                    txn.commit();
                }
                catch (ModelerCoreException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Returning_from_MtkXMIResourceImpl.doLoad(InputStream,Map)_2", new Object[0]));
            }
        }
        finally {
            this.delegate.setLoading(false);
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        Resource resource;
        ModelAnnotation modelAnnotation = null;
        if (this.modelContents != null && this.modelContents.getModelAnnotation() != null && (resource = (modelAnnotation = this.modelContents.getModelAnnotation()).eResource()) == null) {
            this.getContents().add(0, (Object)modelAnnotation);
        }
        if (modelAnnotation != null && !(this.getContents().get(0) instanceof ModelAnnotation)) {
            this.getContents().move(0, (Object)modelAnnotation);
        }
        if (modelAnnotation != null) {
            modelAnnotation.setProducerName(ModelerCore.ILicense.PRODUCER_NAME);
            modelAnnotation.setProducerVersion(ModelerCore.ILicense.VERSION);
        }
        HashMap<String, String> saveOptions = options == null ? new HashMap<String, String>() : new HashMap(options);
        saveOptions.put("PROCESS_DANGLING_HREF", "RECORD");
        super.doSave(outputStream, saveOptions);
    }

    protected XMLHelper createXMLHelper() {
        return new MtkXmiHelper();
    }

    protected void doUnload() {
        if (this.delegate.isUnloading()) {
            return;
        }
        this.delegate.setUnloading(true);
        try {
            super.doUnload();
            this.setModified(false);
            this.modelContents = null;
        }
        finally {
            this.delegate.setUnloading(false);
        }
    }

    void ensureUuid(EObject eObject, boolean recursive) {
        if (eObject == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_EObject_reference_may_not_be_null", new Object[0]));
        }
        String uuid = this.getID(eObject);
        if (uuid == null) {
            this.setID(eObject, IDGenerator.getInstance().create().toString());
            if (recursive) {
                for (Object next : eObject.eContents()) {
                    if (!(next instanceof EObject)) continue;
                    EObject nextEObj = (EObject)next;
                    this.ensureUuid(nextEObj, recursive);
                }
            }
        }
    }

    public void attached(EObject eObject) {
        this.ensureUuid(eObject, true);
        super.attached(eObject);
    }

    protected XMLSave createXMLSave() {
        return new MtkXmiSaveImpl(super.createXMLHelper(), this);
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new MtkContentsEList(this);
        }
        return this.contents;
    }

    @Override
    public String getDescription() {
        String description = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            description = this.getModelContents().getModelAnnotation().getDescription();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        }
        return description;
    }

    @Override
    public ModelType getModelType() {
        ModelType type = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            type = this.getModelContents().getModelAnnotation().getModelType();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                type = ModelType.get((String)header.getModelType());
            }
        }
        return type;
    }

    @Override
    public URI getPrimaryMetamodelUri() {
        String primaryMetamodelUri = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            primaryMetamodelUri = this.getModelContents().getModelAnnotation().getPrimaryMetamodelUri();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                primaryMetamodelUri = header.getPrimaryMetamodelURI();
            }
        }
        if (CoreStringUtil.isEmpty(primaryMetamodelUri)) {
            return null;
        }
        return URI.createURI((String)primaryMetamodelUri);
    }

    @Override
    public boolean isVisible() {
        boolean isVisible = true;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            isVisible = this.getModelContents().getModelAnnotation().isVisible();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                isVisible = header.isVisible();
            }
        }
        return isVisible;
    }

    @Override
    public ObjectID getUuid() {
        ObjectID uuid = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            uuid = this.getObjectIDFromString(this.getID((EObject)this.getModelAnnotation()));
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null && header.getUUID() != null) {
                uuid = this.getObjectIDFromString(header.getUUID());
            }
        }
        return uuid;
    }

    @Override
    public String getUuid(EObject object) {
        return this.getID(object);
    }

    protected XMIHeader doGetXmiHeader() {
        File f;
        XMIHeader header = null;
        if (this.getURI().isFile() && (f = new File(this.getURI().toFileString())).exists()) {
            header = ModelFileUtil.getXmiHeader((File)f);
        }
        return header;
    }

    @Override
    public ModelAnnotation getModelAnnotation() {
        if (this.modelContents != null) {
            return this.modelContents.getModelAnnotation();
        }
        return null;
    }

    @Override
    public ModelContents getModelContents() {
        if (this.modelContents == null) {
            this.modelContents = new ModelContents((Resource)this);
        }
        return this.modelContents;
    }

    @Override
    public List getNamespacePrefixToUris() {
        return this.prefixesToURIs;
    }

    public String getURIFragment(EObject eObject) {
        String uuid = this.getID(eObject);
        return uuid == null ? null : uuid.replace(':', '/');
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        EObject result;
        ObjectID id = this.getObjectIDFromString(uriFragmentRootSegment);
        if (id != null && (result = this.getEObject(id)) != null) {
            return result;
        }
        return super.getEObjectForURIFragmentRootSegment(uriFragmentRootSegment);
    }

    public EObject getEObject(String uriFragment) {
        if (uriFragment != null) {
            ObjectID id = this.getObjectIDFromString(uriFragment);
            if (id != null) {
                return this.getEObject(id);
            }
            return super.getEObject(uriFragment);
        }
        return null;
    }

    protected EObject getEObjectByID(String id) {
        return (EObject)this.idToEObjectMap.get(id);
    }

    @Override
    public Container getContainer() {
        if (this.container == null) {
            ResourceSet resourceSet = this.resourceSet;
            if (resourceSet == null) {
                String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.The_ResourceSet_reference_may_not_be_null_4", new Object[0]);
                throw new AssertionError((Object)msg);
            }
            if (resourceSet instanceof EmfResourceSet) {
                this.container = ((EmfResourceSet)resourceSet).getContainer();
                if (this.container == null) {
                    String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.MtkXmiResourceImpl.The_Container_reference_may_not_be_null_5", new Object[0]);
                    throw new AssertionError((Object)msg);
                }
            }
            if (this.container == null && (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL)) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.The_Container_reference_is_null_for_this_MtkXmiResourceImpl_6", new Object[0]));
            }
        }
        return this.container;
    }

    public ObjectManager getObjectManager() {
        if (this.objectManager == null) {
            Container ctnr = this.getContainer();
            this.objectManager = ctnr instanceof ContainerImpl ? ((ContainerImpl)ctnr).getObjectManager() : this.doGetDefaultObjectManager();
        }
        return this.objectManager;
    }

    protected ObjectManager doGetDefaultObjectManager() {
        return new ObjectManager(){

            @Override
            public String getObjectId(EObject object) {
                return null;
            }

            @Override
            public void setObjectId(EObject object, String uuid) {
            }

            @Override
            public EObject findEObject(String id) {
                return null;
            }

            @Override
            public EObject findEObject(String id, Resource resource) {
                return null;
            }
        };
    }

    @Override
    public EObject getEObject(Object object) {
        if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.MtkXmiResourceImpl.getEObject()_7", new Object[]{object}));
        }
        if (object instanceof URI) {
            return this.getResourceSet().getEObject(this.uri, true);
        }
        if (object instanceof ObjectID) {
            return this.getEObjectByID(((ObjectID)object).toString());
        }
        throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("MtkXmiResourceImpl.MtkXmiResourceImpl.getEObject()_invalid_param.__Key_must_be_a_Proxy,_a_URI,_or_an_ObjectID_6", new Object[]{object}));
    }

    public void addMany(Collection newRoots) {
        ArrayList newRootsToAdd = new ArrayList(newRoots);
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.addAll(newRootsToAdd);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        for (Object object : newRootsToAdd) {
            ((MtkContentsEList)this.contents).attachToResource(object);
            if (!(object instanceof BasicEObjectImpl)) continue;
            ((BasicEObjectImpl)object).eSetResource((Resource.Internal)this, null);
        }
    }

    public void removeMany(Collection roots) {
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.removeAll(roots);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        for (Object object : roots) {
            if (!(object instanceof EObjectImpl)) continue;
            ((EObjectImpl)object).eSetResource(null, null);
        }
    }

    public MetamodelRegistry getMetamodelRegistry() {
        if (this.registry == null) {
            Container emfContainer = this.getContainer();
            if (this.container != null) {
                this.registry = emfContainer.getMetamodelRegistry();
                if (this.registry == null) {
                    String msg = ModelerCore.Util.getString("MtkXmiResourceImpl.The_MetamodelRegistry_reference_may_not_be_null_7", new Object[0]);
                    throw new AssertionError((Object)msg);
                }
            }
            if (this.registry == null && (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL)) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.The_MetamodelRegistry_reference_is_null_for_this_MtkXmiResourceImpl_8", new Object[0]));
            }
        }
        return this.registry;
    }

    @Override
    public Annotation getAnnotation(EObject eobj) {
        return this.getModelContents().getAnnotation(eobj);
    }

    @Override
    public AnnotationContainer getAnnotationContainer(boolean createIfNeeded) {
        return this.getModelContents().getAnnotationContainer(createIfNeeded);
    }

    protected EObject resolveEObject(ObjectID id) {
        if (id == null) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("MtkXmiResourceImpl.The_ObjectID_reference_may_not_be_null", new Object[0]));
        }
        return this.getEObjectByID(id.toString());
    }

    private ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    @Override
    public void setUuid(EObject object, String uuid) {
        super.setID(object, uuid);
    }

    public void testUuidToEObjectMap(String description) {
        int missingMapEntryCount = 0;
        int eObjectCount = 0;
        for (EObject eObject : this.getContents()) {
            if (eObject == null) continue;
            ++eObjectCount;
            ObjectID id = ModelerCore.getObjectId(eObject);
            if (id == null || this.getEObjectByID(id.toString()) == null) {
                ++missingMapEntryCount;
            }
            TreeIterator iter2 = eObject.eAllContents();
            while (iter2.hasNext()) {
                EObject eObj = (EObject)iter2.next();
                if (eObj == null) continue;
                ++eObjectCount;
                id = ModelerCore.getObjectId(eObj);
                if (id != null && this.getEObjectByID(id.toString()) != null) continue;
                ++missingMapEntryCount;
            }
        }
        ModelerCore.Util.log(1, description);
        ModelerCore.Util.log(1, "Number of EObject instances in model           = " + eObjectCount);
        ModelerCore.Util.log(1, "Number of entries in the map                   = " + this.idToEObjectMap.size());
        int severity = missingMapEntryCount == 0 ? 1 : 4;
        ModelerCore.Util.log(severity, "Number of EObject instances missing in the map = " + missingMapEntryCount);
    }

    protected class MtkContentsEList
    extends ResourceImpl.ContentsEList {
        private static final long serialVersionUID = 1L;
        private final MtkXmiResourceImpl owner;

        public MtkContentsEList(MtkXmiResourceImpl owner) {
            super((ResourceImpl)MtkXmiResourceImpl.this);
            this.owner = owner;
        }

        protected void didChange() {
            MtkXmiResourceImpl.this.setModified(true);
        }

        public boolean removeAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return false;
            }
            boolean startTxn = this.getTxn();
            try {
                BasicEList vals = new BasicEList(c);
                int[] removedIndexes = this.getIndexes((Collection)vals);
                this.owner.removeMany(c);
                if (vals.size() == 1) {
                    MtkXmiResourceImpl.this.eNotify((Notification)this.createNotification(4, vals.get(0), null, removedIndexes[0]));
                } else {
                    MtkXmiResourceImpl.this.eNotify((Notification)this.createNotification(6, vals, removedIndexes, removedIndexes[0]));
                }
                return true;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        private int[] getIndexes(Collection vals) {
            BasicEList tmp = new BasicEList((Collection)((Object)this));
            int[] result = new int[vals.size()];
            Iterator it = tmp.iterator();
            int count = 0;
            int index = 0;
            while (it.hasNext()) {
                Object next = it.next();
                if (vals.contains(next)) {
                    result[count++] = index;
                }
                ++index;
            }
            return result;
        }

        public boolean addAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return false;
            }
            boolean startTxn = this.getTxn();
            try {
                int index = this.size;
                this.owner.addMany(c);
                BasicEList vals = new BasicEList(c);
                MtkXmiResourceImpl.this.eNotify((Notification)this.createNotification(5, null, vals, index, true));
                return true;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public void add(int index, Object element) {
            boolean startTxn = this.getTxn();
            try {
                super.add(index, element);
                this.attachToResource(element);
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public boolean add(Object o) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.add(o);
                this.attachToResource(o);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public boolean addAll(int index, Collection c) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.addAll(index, c);
                this.attachToResource(c);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public boolean remove(Object o) {
            boolean startTxn = this.getTxn();
            try {
                boolean bl = super.remove(o);
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            if (object == null) {
                return notifications;
            }
            boolean startTxn = this.getTxn();
            try {
                NotificationChain result = super.inverseAdd(object, notifications);
                this.attachToResource(object);
                NotificationChain notificationChain = result;
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            if (object == null) {
                return notifications;
            }
            boolean startTxn = this.getTxn();
            try {
                NotificationChain notificationChain = super.inverseRemove(object, notifications);
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public boolean addAllUnique(Collection collection) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.addAllUnique(collection);
                this.attachToResource(collection);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public boolean addAllUnique(int index, Collection collection) {
            boolean startTxn = this.getTxn();
            try {
                boolean result = super.addAllUnique(index, collection);
                this.attachToResource(collection);
                boolean bl = result;
                return bl;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public void addUnique(int index, Object object) {
            boolean startTxn = this.getTxn();
            try {
                super.addUnique(index, object);
                this.attachToResource(object);
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public void addUnique(Object object) {
            boolean startTxn = this.getTxn();
            try {
                super.addUnique(object);
                this.attachToResource(object);
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public NotificationChain basicAdd(Object object, NotificationChain notifications) {
            boolean startTxn = this.getTxn();
            try {
                NotificationChain result = super.basicAdd(object, notifications);
                this.attachToResource(object);
                NotificationChain notificationChain = result;
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            boolean startTxn = this.getTxn();
            try {
                NotificationChain notificationChain = super.basicRemove(object, notifications);
                return notificationChain;
            }
            finally {
                if (startTxn) {
                    this.commitTxn();
                }
            }
        }

        void attachToResource(Object object) {
            if (object instanceof Identifiable) {
                String uuidString = ((Identifiable)object).getUuid();
                if (uuidString != null && object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    ModelerCore.setObjectId(eObject, uuidString);
                    MtkXmiResourceImpl.this.ensureUuid(eObject, true);
                }
            } else if (object instanceof EObject) {
                EObject eObj = (EObject)object;
                MtkXmiResourceImpl.this.ensureUuid(eObj, true);
            } else if (ModelerCore.DEBUG || ModelerCore.DEBUG_METAMODEL) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("MtkXmiResourceImpl.DEBUG.Attaching_non-proxy_object_5", new Object[]{object}));
            }
        }

        private boolean getTxn() {
            return ModelerCore.startTxn(null, (Object)this);
        }

        private void commitTxn() {
            ModelerCore.commitTxn();
        }
    }
}

