/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.StringNameRule;
import org.teiid.designer.metamodels.core.extension.XClass;

public class XClassNameRule
extends StringNameRule {
    public XClassNameRule() {
        super(1);
    }

    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(XClass.class, (Object)eObject);
        XClass xclass = (XClass)eObject;
        String name = xclass.getName();
        if (name == null || name.trim().length() == 0) {
            ValidationResultImpl result = new ValidationResultImpl(xclass);
            String msg = ModelerCore.Util.getString("XClassNameRule.MissingName", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
    }

    @Override
    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        LinkedList siblings = new LinkedList(super.getSiblingsForUniquenessCheck(eObject));
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            EObject sibling = (EObject)iter.next();
            if (sibling instanceof XClass) continue;
            iter.remove();
        }
        return siblings;
    }

    @Override
    protected int getInvalidCharactersSeverityCode() {
        return 2;
    }

    @Override
    protected boolean validateCharacters() {
        return false;
    }

    @Override
    protected boolean validateUniqueness() {
        return true;
    }
}

