/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;

public class MetamodelEntityImpl
implements MetamodelEntity {
    private final URI metamodelURI;
    private final EClass eClass;
    private Map aspectMap;
    private List referencedClasses;
    private List containedClasses;
    private List attributes;
    private List uniReferences;

    public MetamodelEntityImpl(URI metamodelURI, EClass eClass) {
        if (metamodelURI == null) {
            String msg = ModelerCore.Util.getString("MetamodelEntityImpl.The_metamodel_URI_reference_may_not_be_null_1", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (eClass == null) {
            String msg = ModelerCore.Util.getString("MetamodelEntityImpl.The_EObject_reference_may_not_be_null_1", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        this.metamodelURI = metamodelURI;
        this.eClass = eClass;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getPluralDisplayName() {
        return null;
    }

    @Override
    public String getIconPath() {
        return null;
    }

    @Override
    public String getTooltip() {
        return null;
    }

    @Override
    public MetamodelAspect getMetamodelAspect(String id) {
        if (this.aspectMap == null) {
            return null;
        }
        return (MetamodelAspect)this.aspectMap.get(id);
    }

    @Override
    public Collection getMetamodelAspects() {
        if (this.aspectMap == null) {
            return Collections.EMPTY_LIST;
        }
        return this.aspectMap.values();
    }

    @Override
    public EClass getEClass() {
        return this.eClass;
    }

    @Override
    public List getAttributes() {
        EClass metamodelClass = this.getEClass();
        if (this.attributes == null) {
            EList attribs = metamodelClass.getEAllAttributes();
            this.attributes = new ArrayList(attribs.size());
        }
        return this.attributes;
    }

    @Override
    public List getContainedClasses() {
        EClass metamodelClass = this.getEClass();
        if (this.containedClasses == null) {
            EList refs = metamodelClass.getEAllContainments();
            this.containedClasses = new ArrayList(refs.size());
            for (EReference eRef : refs) {
                if (!(eRef.getEType() instanceof EClass)) continue;
                this.containedClasses.add(eRef.getEType());
            }
        }
        return this.containedClasses;
    }

    @Override
    public List getReferencedClasses() {
        EClass metamodelClass = this.getEClass();
        if (this.referencedClasses == null) {
            EList refs = metamodelClass.getEAllReferences();
            this.referencedClasses = new ArrayList(refs.size());
            for (EReference eRef : refs) {
                if (eRef.isContainment() || !(eRef.getEType() instanceof EClass)) continue;
                this.referencedClasses.add(eRef.getEType());
            }
        }
        return this.referencedClasses;
    }

    @Override
    public List getUniDirectionalReferences() {
        EClass metamodelClass = this.getEClass();
        if (this.uniReferences == null) {
            EList refs = metamodelClass.getEAllReferences();
            this.uniReferences = new ArrayList();
            for (EReference eRef : refs) {
                if (eRef.isContainment() || eRef.getEOpposite() != null) continue;
                this.uniReferences.add(eRef);
            }
        }
        return this.uniReferences;
    }

    public URI getMetamodelURI() {
        return this.metamodelURI;
    }

    public void addMetamodelAspect(String id, MetamodelAspect aspect) {
        if (this.aspectMap == null) {
            this.aspectMap = new HashMap();
        }
        this.aspectMap.put(id, aspect);
    }
}

