/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metadata.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IndexingContext;
import org.teiid.designer.core.index.WordEntry;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAnnotationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnSetAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlForeignKeyAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlModelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTransformationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTransformationInfo;
import org.teiid.designer.core.metamodel.aspect.sql.SqlUniqueKeyAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlVdbAspect;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metadata.runtime.impl.RecordFactory;
import org.teiid.designer.metamodels.core.Annotation;

public class RuntimeAdapter
extends RecordFactory {
    private static HashMap metaClassUriMap = new HashMap();

    public static void addIndexWord(Object eObject, IndexingContext context, String modelPath, Collection wordEntries) {
        RuntimeAdapter.addIndexWord(eObject, context, modelPath, wordEntries, true);
    }

    public static void addFileIndexWord(String filePath, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(50);
        sb.append('Z');
        sb.append('\u00a0');
        sb.append(filePath);
        sb.append('\u00a0');
        WordEntry wordEntry = new WordEntry(sb.toString().toCharArray());
        wordEntries.add(wordEntry);
    }

    public static void addIndexWord(Object eObject, IndexingContext context, String modelPath, Collection wordEntries, boolean addAllWords) {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)eObject);
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)eObject);
        if (sqlAspect == null || !sqlAspect.isQueryable((EObject)eObject)) {
            return;
        }
        if (sqlAspect.isRecordType('G')) {
            RuntimeAdapter.addColumnWord((SqlColumnAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('B')) {
            RuntimeAdapter.addTableWord((SqlTableAspect)sqlAspect, (EObject)eObject, context, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('M')) {
            RuntimeAdapter.addDatatypeWord((SqlDatatypeAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('E')) {
            RuntimeAdapter.addCallableWord((SqlProcedureAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('F')) {
            RuntimeAdapter.addCallableParameterWord((SqlProcedureParameterAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (sqlAspect.isRecordType('A')) {
            RuntimeAdapter.addModelWord((SqlModelAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
        if (addAllWords) {
            if (sqlAspect.isRecordType('I') || sqlAspect.isRecordType('K')) {
                RuntimeAdapter.addUniqueKeyWord((SqlUniqueKeyAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('L') || sqlAspect.isRecordType('H') || sqlAspect.isRecordType('C')) {
                RuntimeAdapter.addColumnSetWord((SqlColumnSetAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('J')) {
                RuntimeAdapter.addForeignKeyWord((SqlForeignKeyAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('P') || sqlAspect.isRecordType('Q') || sqlAspect.isRecordType('R') || sqlAspect.isRecordType('S') || sqlAspect.isRecordType('T') || sqlAspect.isRecordType('U')) {
                RuntimeAdapter.addTransformationWords((SqlTransformationAspect)sqlAspect, (EObject)eObject, context, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('V')) {
                RuntimeAdapter.addVdbWord((SqlVdbAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            if (sqlAspect.isRecordType('W')) {
                RuntimeAdapter.addAnnotationWord((SqlAnnotationAspect)sqlAspect, (EObject)eObject, modelPath, wordEntries);
            }
            RuntimeAdapter.addPropertyWord(sqlAspect, (EObject)eObject, modelPath, wordEntries);
        }
    }

    public static void addModelWord(SqlModelAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getName(eObject);
        RuntimeAdapter.addModelWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getMaxSetSize(eObject), aspect.getModelType(eObject), aspect.isVisible(eObject), aspect.supportsDistinct(eObject), aspect.supportsJoin(eObject), aspect.supportsOrderBy(eObject), aspect.supportsOuterJoin(eObject), aspect.supportsWhereAll(eObject), aspect.getPrimaryMetamodelUri(eObject), modelPath, wordEntries);
    }

    static void addModelWord(String objectID, String fullName, String nameInSource, String parentObjectID, int maxSetSize, int modelType, boolean isVisible, boolean supportsDistinct, boolean supportsJoin, boolean supportsOrderBy, boolean supportsOuterJoin, boolean supportsWhereAll, String primaryMetamodelUri, String modelPath, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('A', objectID, fullName, nameInSource, parentObjectID, sb);
        sb.append(maxSetSize);
        sb.append('\u00a0');
        sb.append(modelType);
        sb.append('\u00a0');
        sb.append(primaryMetamodelUri);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isVisible, sb);
        RuntimeAdapter.appendBoolean(supportsDistinct, sb);
        RuntimeAdapter.appendBoolean(supportsJoin, sb);
        RuntimeAdapter.appendBoolean(supportsOrderBy, sb);
        RuntimeAdapter.appendBoolean(supportsOuterJoin, sb);
        RuntimeAdapter.appendBoolean(supportsWhereAll, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, fullName, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addVdbWord(SqlVdbAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        RuntimeAdapter.addVdbWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getVersion(eObject), aspect.getIdentifier(eObject), aspect.getDescription(eObject), aspect.getProducerName(eObject), aspect.getProducerVersion(eObject), aspect.getProvider(eObject), aspect.getTimeLastChanged(eObject), aspect.getTimeLastProduced(eObject), aspect.getModelIDs(eObject), modelPath, name, wordEntries);
    }

    static void addVdbWord(String objectID, String fullName, String nameInSource, String parentObjectID, String version, String identifier, String description, String producerName, String producerVersion, String provider, String timeLastChanged, String timeLastProduced, List modelIDs, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('V', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendObject(version, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(identifier, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(producerName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(producerVersion, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(provider, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(timeLastChanged, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(timeLastProduced, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(modelIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(description, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addTransformationWords(SqlTransformationAspect aspect, EObject eObject, IndexingContext context, String modelPath, Collection wordEntries) {
        EObject virtualTable = (EObject)aspect.getTransformedObject(eObject);
        if (virtualTable == null) {
            return;
        }
        if (context != null) {
            if (context.hasTransformation(virtualTable)) {
                return;
            }
            context.addTargetTransform(virtualTable, eObject);
        }
        String upperName = aspect.getFullName(eObject).toUpperCase();
        String transformedObjectID = RuntimeAdapter.getObjectIdString(virtualTable);
        String transformationObjectID = RuntimeAdapter.getObjectIdString(eObject);
        String name = aspect.getName(eObject);
        String[] types = aspect.getTransformationTypes(eObject);
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                SqlTransformationInfo transInfo;
                if (!(types[i].equals("Insert") && !aspect.isInsertAllowed(eObject) || types[i].equals("Update") && !aspect.isUpdateAllowed(eObject) || types[i].equals("Delete") && !aspect.isDeleteAllowed(eObject) || (transInfo = aspect.getTransformationInfo(eObject, context, types[i])) == null || CoreStringUtil.isEmpty((String)transInfo.getSqlTransform()))) {
                    String sqlTransform = transInfo.getSqlTransform();
                    List bindingNames = transInfo.getBindings();
                    List schemaPaths = transInfo.getSchemaPaths();
                    RuntimeAdapter.addTransformationWord(upperName, types[i], transformationObjectID, transformedObjectID, sqlTransform, bindingNames, schemaPaths, modelPath, name, wordEntries);
                }
                ++i;
            }
        }
    }

    static void addTransformationWord(String upperName, String tranformType, String transformationObjectID, String transformedObjectID, String transformation, List bindings, List schemaPaths, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        if (tranformType.equals("Select")) {
            sb.append('P');
        } else if (tranformType.equals("Insert")) {
            sb.append('Q');
        } else if (tranformType.equals("Update")) {
            sb.append('R');
        } else if (tranformType.equals("Delete")) {
            sb.append('S');
        } else if (tranformType.equals("Procedure")) {
            sb.append('T');
        } else if (tranformType.equals("Mapping")) {
            sb.append('U');
        }
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(upperName, sb);
        sb.append('\u00a0');
        sb.append(transformedObjectID);
        sb.append('\u00a0');
        sb.append(transformationObjectID);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(transformation, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendStrings(bindings, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendStrings(schemaPaths, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(transformedObjectID, sb, wordEntries);
    }

    public static void addCallableWord(SqlProcedureAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('E', objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, sb);
        RuntimeAdapter.appendBoolean(aspect.isFunction(eObject), sb);
        RuntimeAdapter.appendBoolean(aspect.isVirtual(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(aspect.getParameters(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(aspect.getResult(eObject), sb);
        sb.append('\u00a0');
        sb.append(aspect.getUpdateCount(eObject));
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addCallableParameterWord(SqlProcedureParameterAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('F', objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, sb);
        RuntimeAdapter.appendObject(aspect.getDefaultValue(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(aspect.getRuntimeType(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(aspect.getDatatypeObjectID(eObject), sb);
        sb.append('\u00a0');
        sb.append(aspect.getLength(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getRadix(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getScale(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getNullType(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getPrecision(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getPosition(eObject));
        sb.append('\u00a0');
        sb.append(aspect.getType(eObject));
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(aspect.isOptional(eObject), sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addTableWord(SqlTableAspect aspect, EObject eObject, IndexingContext context, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String name = aspect.getName(eObject);
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String primaryKeyID = RuntimeAdapter.getObjectIdString(aspect.getPrimaryKey(eObject));
        String materializedTableID = null;
        boolean isMaterialized = aspect.isMaterialized(eObject);
        if (isMaterialized) {
            materializedTableID = aspect.getMaterializedTableId(eObject);
        }
        RuntimeAdapter.addTableWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getCardinality(eObject), aspect.getTableType(eObject), aspect.isVirtual(eObject), aspect.isSystem(eObject), isMaterialized, aspect.supportsUpdate(eObject), primaryKeyID, aspect.getColumns(eObject), aspect.getForeignKeys(eObject), aspect.getIndexes(eObject), aspect.getUniqueKeys(eObject), aspect.getAccessPatterns(eObject), materializedTableID, modelPath, name, wordEntries);
    }

    static void addTableWord(String objectID, String fullName, String nameInSource, String parentObjectID, int cardinality, int tableType, boolean isVirtual, boolean isSystem, boolean isMaterialized, boolean supportsUpdate, String primaryKeyID, List columnIDs, Collection foreignKeyIDs, Collection indexIDs, Collection uniqueKeyIDs, Collection accessPatternIDs, String materializedTableID, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('B', objectID, fullName, nameInSource, parentObjectID, sb);
        sb.append(cardinality);
        sb.append('\u00a0');
        sb.append(tableType);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isVirtual, sb);
        RuntimeAdapter.appendBoolean(isSystem, sb);
        RuntimeAdapter.appendBoolean(supportsUpdate, sb);
        RuntimeAdapter.appendBoolean(isMaterialized, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(Collections.EMPTY_LIST, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(primaryKeyID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(foreignKeyIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(indexIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(uniqueKeyIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(accessPatternIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(materializedTableID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendID(null, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addColumnWord(SqlColumnAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String name = aspect.getName(eObject);
        String fullName = aspect.getFullName(eObject);
        String minValue = aspect.getMinValue(eObject) != null ? aspect.getMinValue(eObject).toString() : null;
        String maxValue = aspect.getMaxValue(eObject) != null ? aspect.getMaxValue(eObject).toString() : null;
        String defaultValue = aspect.getDefaultValue(eObject) != null ? aspect.getDefaultValue(eObject).toString() : null;
        RuntimeAdapter.addColumnWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.isSelectable(eObject), aspect.isUpdatable(eObject), aspect.getNullType(eObject), aspect.isAutoIncrementable(eObject), aspect.isCaseSensitive(eObject), aspect.isSigned(eObject), aspect.isCurrency(eObject), aspect.isFixedLength(eObject), aspect.isTranformationInputParameter(eObject), aspect.getSearchType(eObject), aspect.getLength(eObject), aspect.getScale(eObject), aspect.getPrecision(eObject), aspect.getCharOctetLength(eObject), aspect.getRadix(eObject), aspect.getDistinctValues(eObject), aspect.getNullValues(eObject), minValue, maxValue, aspect.getFormat(eObject), aspect.getRuntimeType(eObject), aspect.getNativeType(eObject), aspect.getDatatypeObjectID(eObject), defaultValue, aspect.getPosition(eObject), modelPath, name, wordEntries);
    }

    static void addColumnWord(String objectID, String fullName, String nameInSource, String parentObjectID, boolean isSelectable, boolean isUpdatable, int nullType, boolean isAutoIncrementable, boolean isCaseSensitive, boolean isSigned, boolean isCurrency, boolean isFixedLength, boolean isTranformationInputParameter, int searchType, int length, int scale, int precision, int charOctetLength, int radix, int distinctValues, int nullValues, String minValue, String maxValue, String format, String runtimeType, String nativeType, String datatypeObjectID, String defaultValue, int position, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('G', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendBoolean(isSelectable, sb);
        RuntimeAdapter.appendBoolean(isUpdatable, sb);
        RuntimeAdapter.appendBoolean(isAutoIncrementable, sb);
        RuntimeAdapter.appendBoolean(isCaseSensitive, sb);
        RuntimeAdapter.appendBoolean(isSigned, sb);
        RuntimeAdapter.appendBoolean(isCurrency, sb);
        RuntimeAdapter.appendBoolean(isFixedLength, sb);
        RuntimeAdapter.appendBoolean(isTranformationInputParameter, sb);
        sb.append('\u00a0');
        sb.append(nullType);
        sb.append('\u00a0');
        sb.append(searchType);
        sb.append('\u00a0');
        sb.append(length);
        sb.append('\u00a0');
        sb.append(scale);
        sb.append('\u00a0');
        sb.append(precision);
        sb.append('\u00a0');
        sb.append(position);
        sb.append('\u00a0');
        sb.append(charOctetLength);
        sb.append('\u00a0');
        sb.append(radix);
        sb.append('\u00a0');
        sb.append(distinctValues);
        sb.append('\u00a0');
        sb.append(nullValues);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(minValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(maxValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(format, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(runtimeType, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(nativeType, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(datatypeObjectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(defaultValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addColumnSetWord(SqlColumnSetAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        char recordType = 'L';
        if (aspect.isRecordType('H')) {
            recordType = 'H';
        }
        if (aspect.isRecordType('C')) {
            recordType = 'C';
        }
        RuntimeAdapter.addColumnSetWord(recordType, objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getColumns(eObject), modelPath, name, wordEntries);
    }

    static void addColumnSetWord(char recordType, String objectID, String fullName, String nameInSource, String parentObjectID, List columnIDs, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader(recordType, objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendIDs(columnIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addUniqueKeyWord(SqlUniqueKeyAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String name = aspect.getName(eObject);
        String fullName = aspect.getFullName(eObject);
        char recordType = 'K';
        if (aspect.isRecordType('I')) {
            recordType = 'I';
        }
        RuntimeAdapter.addUniqueKeyWord(recordType, objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getColumns(eObject), aspect.getForeignKeys(eObject), modelPath, name, wordEntries);
    }

    static void addUniqueKeyWord(char recordType, String objectID, String fullName, String nameInSource, String parentObjectID, List columnIDs, List foreignKeyIDs, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader(recordType, objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendIDs(columnIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(foreignKeyIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addForeignKeyWord(SqlForeignKeyAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = RuntimeAdapter.getObjectIdString(aspect.getParentObjectID(eObject));
        String name = aspect.getName(eObject);
        String fullName = aspect.getFullName(eObject);
        String uniqueKeyID = aspect.getUniqueKey(eObject) != null ? RuntimeAdapter.getObjectIdString(aspect.getUniqueKey(eObject)) : null;
        RuntimeAdapter.addForeignKeyWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getColumns(eObject), uniqueKeyID, modelPath, name, wordEntries);
    }

    static void addForeignKeyWord(String objectID, String fullName, String nameInSource, String parentObjectID, List columnIDs, String uniqueKeyID, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('J', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendIDs(columnIDs, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(uniqueKeyID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addDatatypeWord(SqlDatatypeAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        EObject container = eObject != null ? eObject.eContainer() : null;
        String parentObjectID = RuntimeAdapter.getObjectIdString(container);
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        RuntimeAdapter.addDatatypeWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getLength(eObject), aspect.getPrecisionLength(eObject), aspect.getScale(eObject), aspect.getRadix(eObject), aspect.isSigned(eObject), aspect.isAutoIncrement(eObject), aspect.isCaseSensitive(eObject), aspect.getType(eObject), aspect.getSearchType(eObject), aspect.getNullType(eObject), aspect.getJavaClassName(eObject), aspect.getRuntimeTypeName(eObject), aspect.getDatatypeID(eObject), aspect.getBasetypeID(eObject), aspect.getPrimitiveTypeID(eObject), aspect.getVarietyType(eObject), aspect.getVarietyProps(eObject), modelPath, name, wordEntries);
    }

    static void addDatatypeWord(String objectID, String fullName, String nameInSource, String parentObjectID, int length, int precisionLength, int scale, int radix, boolean isSigned, boolean isAutoIncrement, boolean isCaseSensitive, short type, short searchType, short nullType, String javaClassName, String runtimeTypeName, String datatypeID, String baseTypeID, String primitiveTypeID, short varietyType, List varietyProps, String modelPath, String name, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append('M');
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(datatypeID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(baseTypeID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(fullName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(nameInSource, sb);
        sb.append('\u00a0');
        sb.append(varietyType);
        sb.append('\u00a0');
        RuntimeAdapter.appendIDs(varietyProps, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(runtimeTypeName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(javaClassName, sb);
        sb.append('\u00a0');
        sb.append(type);
        sb.append('\u00a0');
        sb.append(searchType);
        sb.append('\u00a0');
        sb.append(nullType);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isSigned, sb);
        RuntimeAdapter.appendBoolean(isAutoIncrement, sb);
        RuntimeAdapter.appendBoolean(isCaseSensitive, sb);
        sb.append('\u00a0');
        sb.append(length);
        sb.append('\u00a0');
        sb.append(precisionLength);
        sb.append('\u00a0');
        sb.append(scale);
        sb.append('\u00a0');
        sb.append(radix);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(primitiveTypeID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addPropertyWord(SqlAspect sqlAspect, EObject eObject, String modelPath, Collection wordEntries) {
        EObject extObject = null;
        try {
            ModelEditor editor = ModelerCore.getModelEditor();
            extObject = editor.getExtension(eObject);
        }
        catch (Exception e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        LinkedList<String> propertyNames = new LinkedList<String>();
        String objectID = RuntimeAdapter.getObjectIdString(eObject);
        String name = sqlAspect.getName(eObject);
        if (extObject != null) {
            EClass eClass = extObject.eClass();
            for (EStructuralFeature feature : eClass.getEAttributes()) {
                String key = feature.getName();
                Object value2 = extObject.eGet(feature);
                if (key == null || value2 == null) continue;
                String propName = key.toString();
                String propValue = value2.toString();
                if (CoreStringUtil.isEmpty((String)propName) || CoreStringUtil.isEmpty((String)propValue)) continue;
                if (feature.isMany()) {
                    EList valueList = (EList)value2;
                    if (valueList.isEmpty()) continue;
                    for (Object value2 : eClass.getEAttributes()) {
                        if (value2 == null || !CoreStringUtil.isEmpty((String)value2.toString())) continue;
                        RuntimeAdapter.addPropertyWord(objectID, name, propName, value2.toString(), true, modelPath, wordEntries);
                    }
                } else {
                    RuntimeAdapter.addPropertyWord(objectID, name, propName, propValue, true, modelPath, wordEntries);
                }
                propertyNames.add(propName);
            }
        }
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String metaclassName = eObject.getClass().getName();
        for (ModelExtensionAssistant tempAssistant : registry.getModelExtensionAssistants(metaclassName)) {
            if (!(tempAssistant instanceof ModelObjectExtensionAssistant)) continue;
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)tempAssistant;
            try {
                Properties extensionProperties = assistant.getPropertyValues((Object)eObject);
                if (extensionProperties == null) continue;
                for (String propName : extensionProperties.stringPropertyNames()) {
                    String propValue;
                    ModelExtensionPropertyDefinition propDefn = registry.getPropertyDefinition(metaclassName, propName);
                    if (!propDefn.shouldBeIndexed() || CoreStringUtil.isEmpty((String)(propValue = extensionProperties.getProperty(propName))) || propertyNames.contains(propName)) continue;
                    String propKey = ModelExtensionPropertyDefinition.Utils.getIndexedId((NamespaceProvider)assistant.getModelExtensionDefinition(), (String)propDefn.getSimpleId());
                    RuntimeAdapter.addPropertyWord(objectID, name, propKey, propValue, true, modelPath, wordEntries);
                    propertyNames.add(propName);
                }
            }
            catch (Exception e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    public static void addPropertyWord(String objectID, String name, String propName, String propValue, boolean isExtention, String modelPath, Collection wordEntries) {
        if (CoreStringUtil.isEmpty((String)propName) || CoreStringUtil.isEmpty((String)propValue)) {
            return;
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append('X');
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(propName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(propValue, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendBoolean(isExtention, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addAnnotationWord(SqlAnnotationAspect aspect, EObject eObject, String modelPath, Collection wordEntries) {
        SqlAspect sqlAspect;
        Annotation annotation;
        EObject target;
        String objectID = RuntimeAdapter.getObjectIdString(aspect.getObjectID(eObject));
        String parentObjectID = null;
        String fullName = aspect.getFullName(eObject);
        String name = aspect.getName(eObject);
        if (eObject instanceof Annotation && (target = (annotation = (Annotation)eObject).getAnnotatedObject()) != null && (sqlAspect = AspectManager.getSqlAspect(target)) != null && !sqlAspect.isQueryable(target)) {
            return;
        }
        RuntimeAdapter.addAnnotationWord(objectID, fullName, aspect.getNameInSource(eObject), parentObjectID, aspect.getDescription(eObject), modelPath, name, wordEntries);
    }

    static void addAnnotationWord(String objectID, String fullName, String nameInSource, String parentObjectID, String description, String modelPath, String name, Collection wordEntries) {
        if (CoreStringUtil.isEmpty((String)description)) {
            return;
        }
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        RuntimeAdapter.appendWordHeader('W', objectID, fullName, nameInSource, parentObjectID, sb);
        RuntimeAdapter.appendObject(description, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendWordFooter(modelPath, name, sb);
        RuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static List splitWordEntry(String objectID, WordEntry wordEntry, int blockSize) {
        CoreArgCheck.isNotNull((Object)objectID);
        CoreArgCheck.isNotNull((Object)wordEntry);
        String entryStr = wordEntry.toString();
        int length = entryStr.length();
        if (length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WordEntry> result = new ArrayList<WordEntry>(9);
        if (length < blockSize) {
            result.add(wordEntry);
            return result;
        }
        CoreArgCheck.isTrue((blockSize >= objectID.length() + 8 ? 1 : 0) != 0, (String)("Block size " + blockSize + " is too small"));
        char[] origEntry = entryStr.toCharArray();
        int segCount = 1;
        char recordType = origEntry[0];
        StringBuffer sb = new StringBuffer(blockSize);
        int i = 0;
        while (i < origEntry.length) {
            char c = origEntry[i];
            sb.append(c);
            if (sb.length() == blockSize - 1 && i < origEntry.length - 1) {
                RuntimeAdapter.appendContinuationTrailer(blockSize, sb);
                WordEntry partialEntry = new WordEntry(sb.toString().toCharArray());
                result.add(partialEntry);
                sb.setLength(0);
                RuntimeAdapter.appendContinuationHeader(recordType, objectID, segCount, sb);
                ++segCount;
            }
            ++i;
        }
        if (sb.length() > 0) {
            WordEntry partialEntry = new WordEntry(sb.toString().toCharArray());
            result.add(partialEntry);
        }
        return result;
    }

    protected static void appendIndexVersion(int indexVersion, StringBuffer sb) {
        CoreArgCheck.isTrue((indexVersion > -1 && indexVersion < 100 ? 1 : 0) != 0, (String)("Index version " + indexVersion + " out of range. (0 - 99)"));
        sb.append('\u00a1');
        if (indexVersion < 10) {
            sb.append(Integer.toString(0));
            sb.append(Integer.toString(indexVersion));
        } else {
            sb.append(Integer.toString(indexVersion));
        }
    }

    protected static void appendObject(Object obj, StringBuffer sb) {
        if (obj != null) {
            String objectString = obj.toString();
            if (obj instanceof URI) {
                objectString = URI.decode((String)objectString);
            }
            if (objectString.length() == 0) {
                sb.append(' ');
            }
            sb.append(objectString);
        } else {
            sb.append(' ');
        }
    }

    protected static void appendBoolean(boolean b, StringBuffer sb) {
        if (b) {
            sb.append('1');
        } else {
            sb.append('0');
        }
    }

    protected static void appendStrings(Collection objs, StringBuffer sb) {
        String obj;
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        ArrayList tmp = new ArrayList(objs);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = (String)iter.next();
            if (obj != null && obj.trim().length() != 0) continue;
            iter.remove();
        }
        if (tmp.isEmpty()) {
            sb.append(' ');
            return;
        }
        iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = (String)iter.next();
            sb.append(obj);
            if (!iter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendStrings(Map objs, int indexVersionNumber, StringBuffer sb) {
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        Iterator entryIter = objs.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry mapEntry = entryIter.next();
            if (mapEntry == null) continue;
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            if (key == null || value == null) {
                sb.append(' ');
                if (!entryIter.hasNext()) continue;
                sb.append('\u001f');
                continue;
            }
            sb.append(key.toString());
            sb.append('\u2060');
            sb.append(value.toString());
            if (!entryIter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendIDs(Collection objs, StringBuffer sb) {
        String obj;
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        ArrayList tmp = new ArrayList(objs);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = RuntimeAdapter.getObjectIdString(iter.next());
            if (obj != null && obj.trim().length() != 0) continue;
            iter.remove();
        }
        if (tmp.isEmpty()) {
            sb.append(' ');
            return;
        }
        iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            RuntimeAdapter.appendID(obj, sb);
            if (!iter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendID(Object obj, StringBuffer sb) {
        String id = RuntimeAdapter.getObjectIdString(obj);
        if (id == null || id.length() == 0) {
            sb.append(' ');
        } else {
            sb.append(id);
        }
    }

    protected static String getObjectIdString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof EClass) {
            return null;
        }
        if (obj instanceof EObject) {
            ModelEditorImpl modelEditor = (ModelEditorImpl)ModelerCore.getModelEditor();
            return modelEditor.getSearchIndexObjectID((EObject)obj);
        }
        if (obj instanceof ObjectID) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected static void appendURIs(Collection objs, int indexVersionNumber, StringBuffer sb) {
        String obj;
        if (objs == null || objs.isEmpty()) {
            sb.append(' ');
            return;
        }
        ArrayList tmp = new ArrayList(objs);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = RuntimeAdapter.getObjectIdString(iter.next());
            if (obj != null && obj.trim().length() != 0) continue;
            iter.remove();
        }
        if (tmp.isEmpty()) {
            sb.append(' ');
            return;
        }
        iter = tmp.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            RuntimeAdapter.appendURI(obj, sb, false);
            if (!iter.hasNext()) continue;
            sb.append('\u001f');
        }
    }

    protected static void appendURI(Object obj, StringBuffer sb, boolean isMetaClass) {
        String id = RuntimeAdapter.getObjectURIString(obj, isMetaClass);
        if (id == null || id.length() == 0) {
            sb.append(' ');
        } else {
            sb.append(id);
        }
    }

    protected static String getObjectURIString(Object obj, boolean isMetaClass) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof EObject) {
            String cachedUri;
            if (isMetaClass && (cachedUri = (String)metaClassUriMap.get(((EClass)obj).getName())) != null) {
                return cachedUri;
            }
            EObject eObj = (EObject)obj;
            String theUri = ModelerCore.getModelEditor().getUri(eObj).toString();
            if (isMetaClass) {
                metaClassUriMap.put(((EClass)obj).getName(), theUri);
            }
            return theUri;
        }
        if (obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected static Properties getProperties(String values, int indexVersionNumber) {
        char listDelimiter = RuntimeAdapter.getListDelimiter((int)indexVersionNumber);
        char propDelimiter = RuntimeAdapter.getPropDelimiter(indexVersionNumber);
        return RuntimeAdapter.getProperties(values, listDelimiter, propDelimiter);
    }

    protected static Properties getProperties(String values, char listDelimiter, char propDelimiter) {
        Properties props = new Properties();
        if (CoreStringUtil.isEmpty((String)values)) {
            return props;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return props;
        }
        List tokens = CoreStringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        for (String token : tokens) {
            List propTokens;
            if (token == null || (propTokens = CoreStringUtil.split((String)token, (String)String.valueOf(propDelimiter))).size() != 2) continue;
            props.put(propTokens.get(0), propTokens.get(1));
        }
        return props;
    }

    protected static char getPropDelimiter(int indexVersionNumber) {
        if (indexVersionNumber < 1) {
            return '=';
        }
        return '\u2060';
    }

    protected static void addNewWordEntryToList(String objectID, StringBuffer sb, Collection wordEntries) {
        String word = sb.toString().trim();
        if (!CoreStringUtil.isEmpty((String)word)) {
            WordEntry wordEntry = new WordEntry(word.toCharArray());
            if (word.length() < 8160) {
                wordEntries.add(wordEntry);
                return;
            }
            List splitEntries = RuntimeAdapter.splitWordEntry(objectID, wordEntry, 8160);
            for (WordEntry entry : splitEntries) {
                wordEntries.add(entry);
            }
        }
    }

    private static void appendWordHeader(char recordType, String objectID, String fullName, String nameInSource, String parentObjectID, StringBuffer sb) {
        sb.append(recordType);
        sb.append('\u00a0');
        String upperName = fullName != null ? fullName.toUpperCase() : null;
        RuntimeAdapter.appendObject(upperName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(fullName, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(nameInSource, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(parentObjectID, sb);
        sb.append('\u00a0');
    }

    private static void appendWordFooter(String modelPath, String name, StringBuffer sb) {
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        RuntimeAdapter.appendIndexVersion(RuntimeAdapter.getCurrentIndexVersionNumber(), sb);
        sb.append('\u00a0');
    }

    private static void appendContinuationHeader(char recordType, String objectID, int segCount, StringBuffer sb) {
        sb.append('&');
        sb.append(recordType);
        sb.append('\u00a0');
        RuntimeAdapter.appendObject(objectID, sb);
        sb.append('\u00a0');
        sb.append(segCount);
        sb.append('\u00a0');
    }

    private static void appendContinuationTrailer(int blockSize, StringBuffer sb) {
        int blanksToAdd = blockSize - sb.length() - 1;
        CoreArgCheck.isTrue((blanksToAdd >= 0 ? 1 : 0) != 0, (String)"Blanks to add must be >= 0");
        int i = 0;
        while (i < blanksToAdd) {
            sb.append(' ');
            ++i;
        }
        sb.append('&');
    }

    public static WordEntry createTestWordEntry(char recordType, int numFields, String fieldValue) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append(recordType);
        sb.append('\u00a0');
        int i = 0;
        while (i < numFields) {
            RuntimeAdapter.appendObject(fieldValue, sb);
            sb.append('\u00a0');
            ++i;
        }
        RuntimeAdapter.appendIndexVersion(RuntimeAdapter.getCurrentIndexVersionNumber(), sb);
        sb.append('\u00a0');
        return new WordEntry(sb.toString().toCharArray());
    }

    public static WordEntry createTestWordEntry(char recordType, int numFields, Collection fieldValue) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append(recordType);
        sb.append('\u00a0');
        int indexVersion = RuntimeAdapter.getCurrentIndexVersionNumber();
        int i = 0;
        while (i < numFields) {
            RuntimeAdapter.appendStrings(fieldValue, sb);
            sb.append('\u00a0');
            ++i;
        }
        RuntimeAdapter.appendIndexVersion(indexVersion, sb);
        sb.append('\u00a0');
        return new WordEntry(sb.toString().toCharArray());
    }

    public static WordEntry createTestWordEntry(char recordType, int numFields, Map fieldValue) {
        StringBuffer sb = new StringBuffer(RuntimeAdapter.getIniitalBufferSize());
        sb.append(recordType);
        sb.append('\u00a0');
        int indexVersion = RuntimeAdapter.getCurrentIndexVersionNumber();
        int i = 0;
        while (i < numFields) {
            RuntimeAdapter.appendStrings(fieldValue, indexVersion, sb);
            sb.append('\u00a0');
            ++i;
        }
        RuntimeAdapter.appendIndexVersion(indexVersion, sb);
        sb.append('\u00a0');
        return new WordEntry(sb.toString().toCharArray());
    }

    protected static int getIniitalBufferSize() {
        return 500;
    }
}

