/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.TargetLocationIndexSelector;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;

public class ModelWorkspaceSearchIndexSelector
extends TargetLocationIndexSelector {
    private static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private Collection resources = null;
    IProgressMonitor monitor;
    private final boolean bCreatedWithResources;
    private boolean indexesForCreatedResourcesAreSet = false;
    private Index[] cachedIndexes = null;

    public ModelWorkspaceSearchIndexSelector() {
        super(IndexUtil.INDEX_PATH);
        this.bCreatedWithResources = false;
    }

    public ModelWorkspaceSearchIndexSelector(IProgressMonitor monitor) {
        super(IndexUtil.INDEX_PATH);
        this.monitor = monitor;
        this.bCreatedWithResources = false;
    }

    public ModelWorkspaceSearchIndexSelector(Collection resources) {
        super(IndexUtil.INDEX_PATH);
        this.resources = resources;
        this.bCreatedWithResources = true;
    }

    public ModelWorkspaceSearchIndexSelector(Collection resources, IProgressMonitor monitor) {
        super(IndexUtil.INDEX_PATH);
        this.resources = resources;
        this.monitor = monitor;
        this.bCreatedWithResources = true;
    }

    private boolean updateIndexes() {
        LinkedList<IResource> nonIndexedResources = null;
        try {
            if (this.resources == null) {
                nonIndexedResources = ModelWorkspaceManager.getModelWorkspaceManager().getNonIndexedResources(2);
            } else {
                nonIndexedResources = new LinkedList<IResource>();
                Iterator rscIter = this.resources.iterator();
                while (rscIter.hasNext()) {
                    ModelResource mResource;
                    if (this.monitor != null) {
                        this.monitor.worked(1);
                    }
                    if ((mResource = (ModelResource)rscIter.next()).getIndexType() == 3 || mResource.getIndexType() == 2) continue;
                    nonIndexedResources.add(mResource.getResource());
                }
            }
            if (nonIndexedResources != null && !nonIndexedResources.isEmpty()) {
                final ArrayList resourcesToIndex = new ArrayList(nonIndexedResources);
                TransactionRunnable runnable = new TransactionRunnable(){

                    @Override
                    public Object run(UnitOfWork uow) {
                        ModelBuildUtil.createSearchIndexes(ModelWorkspaceSearchIndexSelector.this.monitor, resourcesToIndex);
                        return null;
                    }
                };
                ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
                return true;
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, String.valueOf(ModelerCore.Util.getString("ModelWorkspaceSearchIndexSelector.Error_trying_to_index_update_search_indexes___1", new Object[0])) + e.getMessage());
        }
        return false;
    }

    @Override
    public Index[] getIndexes() throws IOException {
        boolean indexesUpdated = this.updateIndexes();
        if (!this.bCreatedWithResources && !indexesUpdated) {
            return super.getIndexes();
        }
        this.setIndexes(null);
        if (this.resources != null) {
            if (!this.indexesForCreatedResourcesAreSet || indexesUpdated) {
                ArrayList<Index> tmp = new ArrayList<Index>();
                Iterator rscIter = this.resources.iterator();
                while (rscIter.hasNext()) {
                    Index theIndex;
                    String resourceFileName = null;
                    ModelResource mResource = (ModelResource)rscIter.next();
                    try {
                        resourceFileName = mResource.getEmfResource().getURI().lastSegment();
                    }
                    catch (ModelWorkspaceException theException) {
                        ModelerCore.Util.log((Throwable)((Object)theException));
                    }
                    String fileName = IndexUtil.getSearchIndexFileName(mResource);
                    String path = String.valueOf(IndexUtil.INDEX_PATH) + fileName;
                    if (!IndexUtil.indexFileExists(path) || (theIndex = IndexUtil.getIndexFile(fileName, path, resourceFileName)) == null) continue;
                    tmp.add(theIndex);
                }
                this.cachedIndexes = new Index[tmp.size()];
                tmp.toArray(this.cachedIndexes);
                this.indexesForCreatedResourcesAreSet = true;
            }
            super.setIndexes(this.cachedIndexes);
            return this.cachedIndexes;
        }
        return super.getIndexes();
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ModelWorkspaceSearchIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException iOException) {}
        int i = 0;
        while (i < indexes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i].getIndexFile());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected FilenameFilter getIndexFileFilter() {
        return IndexFilter.FILTER_INSTANCE;
    }

    public static class IndexFilter
    implements FilenameFilter {
        public static IndexFilter FILTER_INSTANCE = new IndexFilter();

        @Override
        public boolean accept(File dir, String name) {
            Path path = new Path(name);
            String extension = path.getFileExtension();
            return extension != null && extension.equals("SEARCH_INDEX");
        }
    }
}

