/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.TargetLocationIndexSelector;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;

public class ModelWorkspaceIndexSelector
extends TargetLocationIndexSelector {
    public ModelWorkspaceIndexSelector() {
        super(IndexUtil.INDEX_PATH);
    }

    @Override
    public Index[] getIndexes() throws IOException {
        boolean indexesUpdated = this.updateIndexes();
        if (indexesUpdated) {
            this.setIndexes(null);
        }
        return super.getIndexes();
    }

    private boolean updateIndexes() {
        try {
            final Collection nonIndexedResources = ModelWorkspaceManager.getModelWorkspaceManager().getNonIndexedResources(1);
            if (nonIndexedResources != null && !nonIndexedResources.isEmpty()) {
                TransactionRunnable runnable = new TransactionRunnable(){

                    @Override
                    public Object run(UnitOfWork uow) {
                        ModelBuildUtil.createModelIndexes(null, nonIndexedResources);
                        return null;
                    }
                };
                ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
                return true;
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("ModelWorkspaceIndexSelector.0", new Object[0]));
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ModelWorkspaceIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException iOException) {}
        int i = 0;
        while (i < indexes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i].getIndexFile());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected FilenameFilter getIndexFileFilter() {
        return IndexFilter.FILTER_INSTANCE;
    }

    public static class IndexFilter
    implements FilenameFilter {
        public static IndexFilter FILTER_INSTANCE = new IndexFilter();

        @Override
        public boolean accept(File dir, String name) {
            Path path = new Path(name);
            String extension = path.getFileExtension();
            return extension != null && extension.equals("INDEX");
        }
    }
}

