/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.index.BlocksIndexInput;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;

public class IndexViewer {
    private static final char[] FORMAT_CHARS = new char[]{'\n', '\r', '\t'};

    public static byte[] getByteContent(File file) throws IOException {
        CoreArgCheck.isNotNull((Object)file);
        CoreArgCheck.isTrue((boolean)IndexUtil.isIndexFile(file), (String)"File is not index file");
        CoreArgCheck.isTrue((boolean)IndexUtil.indexFileExists(file.getAbsolutePath()), (String)("Index File " + file.getAbsolutePath() + " does not exist"));
        String content = IndexViewer.getStringContent(file);
        return content != null ? content.getBytes() : new byte[]{};
    }

    public static String getStringContent(File file) throws IOException {
        CoreArgCheck.isNotNull((Object)file);
        CoreArgCheck.isTrue((boolean)IndexUtil.isIndexFile(file), (String)"File is not index file");
        CoreArgCheck.isTrue((boolean)IndexUtil.indexFileExists(file.getAbsolutePath()), (String)("Index File " + file.getAbsolutePath() + " does not exist"));
        BlocksIndexInput input = null;
        try {
            input = new BlocksIndexInput(file);
            input.open();
            StringBuffer buffer = new StringBuffer();
            while (input.hasMoreWords()) {
                String word = String.valueOf(input.getCurrentWordEntry().getWord());
                buffer.append(StringUtilities.removeChars((String)word, (char[])FORMAT_CHARS));
                buffer.append(CoreStringUtil.LINE_SEPARATOR);
                input.moveToNextWordEntry();
            }
            String string = buffer.toString();
            return string;
        }
        catch (Throwable t) {
            String string = CoreStringUtil.getStackTrace((Throwable)t);
            return string;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public static Collection getWords(String filePath) throws IOException {
        CoreArgCheck.isNotNull((Object)filePath);
        CoreArgCheck.isTrue((boolean)IndexUtil.isIndexFile(filePath), (String)"File is not index file");
        CoreArgCheck.isTrue((boolean)IndexUtil.indexFileExists(filePath), (String)("Index File " + filePath + " does not exist"));
        BlocksIndexInput input = null;
        try {
            input = new BlocksIndexInput(new File(filePath));
            input.open();
            ArrayList<char[]> words = new ArrayList<char[]>();
            while (input.hasMoreWords()) {
                words.add(input.getCurrentWordEntry().getWord());
                input.moveToNextWordEntry();
            }
            ArrayList<char[]> arrayList = words;
            return arrayList;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public static Collection getWords(File file) throws IOException {
        CoreArgCheck.isNotNull((Object)file);
        CoreArgCheck.isTrue((boolean)IndexUtil.isIndexFile(file), (String)"File is not index file");
        CoreArgCheck.isTrue((boolean)IndexUtil.indexFileExists(file.getAbsolutePath()), (String)("Index File " + file.getAbsolutePath() + " does not exist"));
        BlocksIndexInput input = null;
        try {
            input = new BlocksIndexInput(file);
            input.open();
            ArrayList<char[]> words = new ArrayList<char[]>();
            while (input.hasMoreWords()) {
                words.add(input.getCurrentWordEntry().getWord());
                input.moveToNextWordEntry();
            }
            ArrayList<char[]> arrayList = words;
            return arrayList;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public static void clearIndexFileContents(String filePath) throws IOException {
        Index index = new Index(filePath, null, true);
        index.empty();
    }

    public static String getStringContent(Index index) throws IOException {
        CoreArgCheck.isNotNull((Object)index);
        CoreArgCheck.isNotNull((Object)index.getIndexFile());
        CoreArgCheck.isTrue((boolean)IndexUtil.isIndexFile(index.getIndexFile()), (String)"File is not index file");
        CoreArgCheck.isTrue((boolean)IndexUtil.indexFileExists(index.getIndexFile().getAbsolutePath()), (String)("Index File " + index.getIndexFile().getAbsolutePath() + " does not exist"));
        return IndexViewer.getStringContent(index.getIndexFile());
    }
}

