/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.util.Collection;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IDocument;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IIndex;
import org.teiid.designer.core.index.IIndexer;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.ModelDocumentImpl;
import org.teiid.designer.core.index.ModelIndexer;
import org.teiid.designer.core.index.ModelSearchIndexer;
import org.teiid.designer.core.index.SimpleIndexUtil;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;

public class IndexUtil {
    public static final boolean CASE_SENSITIVE_INDEX_FILE_NAMES = false;
    private static final CRC32 CHECK_SUM_CALCULATOR = new CRC32();
    public static String INDEX_PATH;

    static {
        try {
            Plugin plugin = ModelerCore.getPlugin();
            INDEX_PATH = plugin != null ? plugin.getStateLocation().addTrailingSeparator().toString() : String.valueOf(System.getProperty("user.dir")) + "\\indexes";
        }
        catch (Throwable throwable) {
            INDEX_PATH = String.valueOf(System.getProperty("user.dir")) + "\\indexes";
        }
    }

    public static void indexResource(IResource resource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        ModelResource mResource = workspace.findModelResource(resource);
        ModelIndexer indexer = new ModelIndexer();
        IndexUtil.indexResource(indexer, mResource, INDEX_PATH, reuseExistingFile, addResource);
    }

    public static IIndex indexResource(Resource resource, String resourcePath, String indexDirectoryPath, String indexFileName) throws ModelerCoreException {
        if (resource == null) {
            CoreArgCheck.isNotNull((Object)resource, (String)ModelerCore.Util.getString("IndexUtil.The_Resource_reference_may_not_be_null_1", new Object[0]));
        }
        try {
            ModelIndexer indexer = new ModelIndexer();
            String indexFilePath = IndexUtil.getIndexFilePath(indexDirectoryPath, indexFileName);
            Index runtimeIndex = IndexUtil.getNewIndexFile(indexFileName, indexFilePath, resource.getURI().lastSegment());
            ModelDocumentImpl document = new ModelDocumentImpl(resource);
            runtimeIndex.add((IDocument)document, (IIndexer)indexer);
            runtimeIndex.save();
            return runtimeIndex;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("ModelBuilder.IO_Error_trying_to_index_an_EmfResource_2", new Object[0]), (Throwable)e);
            throw new ModelerCoreException((IStatus)status);
        }
    }

    public static void indexResource(EmfResource emfresource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ModelIndexer indexer = new ModelIndexer();
        ModelResource mResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource((Resource)emfresource);
        IndexUtil.indexResource(indexer, mResource, INDEX_PATH, reuseExistingFile, addResource);
    }

    public static void indexResource(ModelResource mResource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        ModelIndexer indexer = new ModelIndexer();
        IndexUtil.indexResource(indexer, mResource, INDEX_PATH, reuseExistingFile, addResource);
    }

    public static void indexResource(IIndexer indexer, ModelResource mResource, String indexPath, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)mResource, (String)ModelerCore.Util.getString("IndexUtil.The_Resource_reference_may_not_be_null_1", new Object[0]));
        try {
            String resourceFileName = mResource.getEmfResource().getURI().lastSegment();
            String indexFileName = IndexUtil.getRuntimeIndexFileName(mResource);
            String indexFilePath = IndexUtil.getIndexFilePath(indexPath, indexFileName);
            Index runtimeIndex = IndexUtil.getNewIndexFile(indexFileName, indexFilePath, resourceFileName);
            IResource resource = mResource.getResource();
            String resourcePath = resource.getFullPath().toString();
            resourcePath = resourcePath.replace('/', File.separatorChar);
            if (ModelerCore.DEBUG || ModelerCore.DEBUG_PROJECT_BUILDER) {
                Object[] params = new Object[]{indexFileName, resourcePath};
                String msg = ModelerCore.Util.getString("IndexUtil.DEBUG.Creating_index_file_0_for_resource_1_1", params);
                ModelerCore.Util.log(1, msg);
            }
            ModelDocumentImpl document = new ModelDocumentImpl(resource, mResource.getEmfResource());
            if (addResource) {
                runtimeIndex.add((IDocument)document, indexer);
            } else {
                runtimeIndex.remove(document.getName());
            }
            runtimeIndex.save();
            if (indexer instanceof ModelIndexer) {
                mResource.setIndexType(3);
            }
            if (indexer instanceof ModelSearchIndexer && mResource.getIndexType() == 0) {
                mResource.setIndexType(2);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("ModelBuilder.IO_Error_trying_to_index_an_EmfResource_2", new Object[0]), (Throwable)e);
            throw new ModelerCoreException((IStatus)status);
        }
    }

    public static String getIndexFilePath(String indexDirectoryPath, String indexFileName) {
        return SimpleIndexUtil.getIndexFilePath((String)indexDirectoryPath, (String)indexFileName);
    }

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, char fieldDelimiter) throws ModelerCoreException {
        try {
            return SimpleIndexUtil.queryIndex((Index[])indexes, (char[])pattern, (char)fieldDelimiter);
        }
        catch (TeiidDesignerException e) {
            throw new ModelerCoreException((Throwable)e);
        }
    }

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws ModelerCoreException {
        try {
            return SimpleIndexUtil.queryIndex((Index[])indexes, (char[])pattern, (boolean)isPrefix, (boolean)returnFirstMatch);
        }
        catch (TeiidDesignerException e) {
            throw new ModelerCoreException((Throwable)e);
        }
    }

    public static IEntryResult[] queryIndex(IProgressMonitor monitor, Index[] indexes, char[] pattern, boolean isPrefix, boolean returnFirstMatch) throws ModelerCoreException {
        try {
            return SimpleIndexUtil.queryIndex((SimpleIndexUtil.ProgressMonitor)(monitor != null ? new ProgressMonitorImpl(monitor) : null), (Index[])indexes, (char[])pattern, (boolean)isPrefix, (boolean)returnFirstMatch);
        }
        catch (TeiidDesignerException e) {
            throw new ModelerCoreException((Throwable)e);
        }
    }

    public static IEntryResult[] queryIndex(IProgressMonitor monitor, Index[] indexes, Collection patterns, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws ModelerCoreException {
        try {
            return SimpleIndexUtil.queryIndex((SimpleIndexUtil.ProgressMonitor)(monitor != null ? new ProgressMonitorImpl(monitor) : null), (Index[])indexes, (Collection)patterns, (boolean)isPrefix, (boolean)isCaseSensitive, (boolean)returnFirstMatch);
        }
        catch (TeiidDesignerException e) {
            throw new ModelerCoreException((Throwable)e);
        }
    }

    public static String getRuntimeIndexFileName(ModelResource model) {
        CoreArgCheck.isNotNull((Object)model);
        return IndexUtil.getRuntimeIndexFileName(model.getResource());
    }

    public static String getRuntimeIndexFileName(Resource model) {
        CoreArgCheck.isNotNull((Object)model);
        ModelResource mResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(model);
        return IndexUtil.getRuntimeIndexFileName(mResource);
    }

    public static String getRuntimeIndexFileName(IResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        String resourcePath = resource.getFullPath().toString();
        return IndexUtil.getRuntimeIndexFileName(resourcePath);
    }

    public static String getRuntimeIndexFileName(String fullPath) {
        CoreArgCheck.isNotNull((Object)fullPath);
        return IndexUtil.getIndexFileName(fullPath, "INDEX");
    }

    public static String getSearchIndexFileName(ModelResource model) {
        CoreArgCheck.isNotNull((Object)model);
        return IndexUtil.getSearchIndexFileName(model.getResource());
    }

    public static String getSearchIndexFileName(Resource model) {
        CoreArgCheck.isNotNull((Object)model);
        ModelResource mResource = ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(model);
        return IndexUtil.getSearchIndexFileName(mResource);
    }

    public static String getSearchIndexFileName(IResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        String resourcePath = resource.getFullPath().toString();
        return IndexUtil.getSearchIndexFileName(resourcePath);
    }

    public static String getSearchIndexFileName(String fullPath) {
        CoreArgCheck.isNotNull((Object)fullPath);
        return IndexUtil.getIndexFileName(fullPath, "SEARCH_INDEX");
    }

    public static String getIndexFileName(String fullPath, String extension) {
        CoreArgCheck.isNotNull((Object)fullPath);
        CoreArgCheck.isNotNull((Object)extension);
        String pathForName = fullPath;
        pathForName = pathForName.toUpperCase();
        CHECK_SUM_CALCULATOR.reset();
        CHECK_SUM_CALCULATOR.update(pathForName.getBytes());
        String indexFileName = String.valueOf(CHECK_SUM_CALCULATOR.getValue()) + "." + extension;
        return indexFileName;
    }

    public static boolean indexFileExists(String indexFilePath) {
        return SimpleIndexUtil.indexFileExists((String)indexFilePath);
    }

    public static boolean indexFileExists(File indexFile) {
        return SimpleIndexUtil.indexFileExists((File)indexFile);
    }

    public static boolean isModelIndex(String indexFileName) {
        return SimpleIndexUtil.isModelIndex((String)indexFileName);
    }

    public static boolean isIndexFile(String indexFileName) {
        return SimpleIndexUtil.isIndexFile((String)indexFileName);
    }

    public static boolean isIndexFile(File indexFile) {
        return SimpleIndexUtil.isIndexFile((File)indexFile);
    }

    public static Index[] getIndexes(String indexName, IndexSelector selector) throws ModelerCoreException {
        try {
            return SimpleIndexUtil.getIndexes((String)indexName, (IndexSelector)selector);
        }
        catch (TeiidDesignerException e) {
            throw new ModelerCoreException((Throwable)e);
        }
    }

    public static String getIndexFileNameForRecordType(char recordType) {
        return SimpleIndexUtil.getIndexFileNameForRecordType((char)recordType);
    }

    public static String getRecordTypeForIndexFileName(String indexName) {
        return SimpleIndexUtil.getRecordTypeForIndexFileName((String)indexName);
    }

    public static String getPrefixPattern(char recordType, String uuid) {
        return SimpleIndexUtil.getPrefixPattern((char)recordType, (String)uuid);
    }

    public static boolean deleteIndexFiles(File[] theFiles, boolean theContinueOnErrorFlag) {
        boolean result = true;
        int i = theFiles.length;
        while (--i >= 0) {
            File file = theFiles[i];
            if (!IndexUtil.isIndexFile(file)) continue;
            ModelWorkspaceManager.getModelWorkspaceManager().getIndexManager().disposeIndex(file.getName());
        }
        return result;
    }

    public static Index getIndexFile(String indexFileName, String indexFilePath, String resourceFileName) {
        return ModelWorkspaceManager.getModelWorkspaceManager().getIndexManager().getIndex(indexFileName, indexFilePath, resourceFileName);
    }

    public static Index getIndexFile(String indexFileName, String indexFilePath) {
        return ModelWorkspaceManager.getModelWorkspaceManager().getIndexManager().getIndex(indexFileName, indexFilePath);
    }

    public static Index getNewIndexFile(String indexFileName, String indexFilePath, String resourceFileName) {
        return ModelWorkspaceManager.getModelWorkspaceManager().getIndexManager().getNewIndex(indexFileName, indexFilePath, resourceFileName);
    }

    public static Index getNewIndexFile(String indexFileName, String indexFilePath) {
        return ModelWorkspaceManager.getModelWorkspaceManager().getIndexManager().getNewIndex(indexFileName, indexFilePath);
    }

    public static Index[] getExistingIndexes(File[] indexFiles) {
        return ModelWorkspaceManager.getModelWorkspaceManager().getIndexManager().getExistingIndexes(indexFiles);
    }

    private static final class ProgressMonitorImpl
    implements SimpleIndexUtil.ProgressMonitor {
        private final IProgressMonitor monitor;

        ProgressMonitorImpl(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void beginTask(String name, int totalWork) {
            this.monitor.beginTask(name, totalWork);
        }

        public void worked(int work) {
            this.monitor.worked(work);
        }
    }
}

