/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.Stopwatch;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ResourceValidator;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.index.ModelIndexer;
import org.teiid.designer.core.index.ModelSearchIndexer;
import org.teiid.designer.core.index.ResourceIndexer;
import org.teiid.designer.core.refactor.OrganizeImportCommand;
import org.teiid.designer.core.refactor.OrganizeImportHandler;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;

public class VdbModelBuilder {
    public static final int MONITOR_TASK_NAME_MAX_LENGTH = 200;
    public static final String TASK_NAME_TRUNCTATION_SUFFIX = ModelerCore.Util.getString("ModelBuildUtil.taskNameTruncationSuffix", new Object[0]);
    public static final String MONITOR_RESOURCE_VALIDATION_MSG = ModelerCore.Util.getString("ModelBuildUtil.Validating_Resource__1", new Object[0]);
    public static final String MONITOR_OBJECT_VALIDATION_MSG = ModelerCore.Util.getString("ModelBuildUtil.Validating__2", new Object[0]);
    private static Collection VALIDATORS;
    private static Collection INDEXERS;
    private Collection<IResource> indexedResources = new ArrayList<IResource>();
    private Collection<IResource> builtResources = new ArrayList<IResource>();
    private boolean synchronizing = false;

    static {
        VdbModelBuilder.initValidators();
        VdbModelBuilder.initIndexers();
    }

    public void start() {
        this.synchronizing = true;
        this.indexedResources.clear();
        this.builtResources.clear();
    }

    public void stop() {
        this.synchronizing = false;
        this.indexedResources.clear();
        this.builtResources.clear();
    }

    public void buildResources(IProgressMonitor monitor, Collection iResources, Container container, boolean validateInContext) {
        List modifiedResources = this.getModifiedResources();
        this.indexResources(monitor, iResources);
        this.setModifiedResources(modifiedResources);
        this.validateResources(monitor, iResources, container, validateInContext);
        this.setModifiedResources(modifiedResources);
    }

    public void clearResourceMarkers(Collection iResources) {
        try {
            for (IResource iResource : iResources) {
                if (!iResource.exists()) continue;
                iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    public void clearResourceMarkers(IResource iResource) {
        try {
            if (iResource.exists()) {
                iResource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 2);
            }
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
        }
    }

    public void createModelIndexes(IProgressMonitor monitor, Collection resources) {
        ModelIndexer modelIndexer = new ModelIndexer();
        this.indexResources(monitor, resources, modelIndexer);
    }

    public ValidationContext createValidationContext() {
        ValidationContext context = null;
        Plugin corePlugin = ModelerCore.getPlugin();
        context = corePlugin != null && !ModelerCore.ignoreValidationPreferencesOnBuild() ? new ValidationContext("org.teiid.designer.core") : new ValidationContext();
        return context;
    }

    public List getModifiedResources() {
        try {
            return this.getModifiedResources((List)ModelerCore.getModelContainer().getResources());
        }
        catch (CoreException coreException) {
            return Collections.EMPTY_LIST;
        }
    }

    public List getModifiedResources(List eResources) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (eResources != null) {
            for (Resource resource : eResources) {
                if (!resource.isModified()) continue;
                result.add(resource);
            }
        }
        return result;
    }

    private Resource[] getWorkspaceResourcesInScope(ModelWorkspace workspace) throws CoreException {
        Resource[] wsEmfResources = workspace.getEmfResources();
        ArrayList<Resource> resourcesInScope = new ArrayList<Resource>(Arrays.asList(wsEmfResources));
        this.updateResource(resourcesInScope);
        return resourcesInScope.toArray(new Resource[resourcesInScope.size()]);
    }

    public void indexResource(IProgressMonitor monitor, IResource iResource, ResourceIndexer indexer) {
        if (this.synchronizing && this.indexedResources.contains(iResource)) {
            return;
        }
        Object object = monitor = monitor != null ? monitor : new NullProgressMonitor();
        if (monitor.isCanceled()) {
            return;
        }
        String sTask = ModelerCore.Util.getString("ModelBuildUtil.Creating_{0}_for_{1}_1", new Object[]{indexer.getIndexType(), iResource.getFullPath()});
        monitor.setTaskName(sTask);
        try {
            this.indexedResources.add(iResource);
            Stopwatch totalWatch = new Stopwatch();
            totalWatch.start();
            indexer.indexResource(iResource, false, true);
            totalWatch.stop();
        }
        catch (Throwable e) {
            ModelerCore.Util.log(4, e, ModelerCore.Util.getString("ModelBuilder.Error_indexing_model_resource_3", (Object)iResource.getFullPath()));
        }
    }

    public void indexResources(IProgressMonitor monitor, Collection resources) {
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        for (ResourceIndexer indexer : INDEXERS) {
            this.indexResources(monitor, resources, indexer);
        }
    }

    public void indexResources(IProgressMonitor monitor, Collection resources, ResourceIndexer indexer) {
        for (IResource resource : resources) {
            this.indexResource(monitor, resource, indexer);
            if (monitor == null) continue;
            monitor.worked(1);
        }
    }

    private static void initIndexers() {
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.resourceIndexer");
        INDEXERS = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                Object instance = PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
                if (instance instanceof ResourceIndexer) {
                    if (!(instance instanceof ModelSearchIndexer)) {
                        INDEXERS.add(instance);
                    }
                } else {
                    String message = ModelerCore.Util.getString("ModelBuildUtil.Extension_class_not_instance_of_IIndexer_1", new Object[0]);
                    ModelerCore.Util.log((Object)message);
                }
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            ++i;
        }
    }

    private static void initValidators() {
        IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.resourceValidator");
        VALIDATORS = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            try {
                Object instance = PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
                if (instance instanceof ResourceValidator) {
                    VALIDATORS.add(instance);
                } else {
                    String message = ModelerCore.Util.getString("ModelBuildUtil.Extension_class_not_instance_of_ResourceValidator_1", new Object[0]);
                    ModelerCore.Util.log((Object)message);
                }
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
            ++i;
        }
    }

    private void internalValidateResource(IProgressMonitor monitor, IResource iResource, ResourceValidator validator, ValidationContext context, boolean clearMarkers) {
        IProgressMonitor progresssMonitor;
        if (this.synchronizing && this.builtResources.contains(iResource)) {
            return;
        }
        Object object = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (progresssMonitor.isCanceled() || !validator.isValidatorForObject(iResource)) {
            return;
        }
        progresssMonitor.setTaskName(String.valueOf(MONITOR_RESOURCE_VALIDATION_MSG) + iResource.getFullPath());
        Object duplicateOfModel = null;
        try {
            duplicateOfModel = iResource.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
        }
        catch (CoreException coreException) {}
        if (clearMarkers) {
            this.clearResourceMarkers(iResource);
        }
        if (duplicateOfModel == null) {
            this.builtResources.add(iResource);
            try {
                ModelWorkspace workspace = ModelerCore.getModelWorkspace();
                ModelResource mResource = workspace.findModelResource(iResource);
                IResource resource = null;
                if (!ModelUtil.isVdbArchiveFile(iResource)) {
                    try {
                        if (mResource != null && mResource.getEmfResource() != null) {
                            resource = mResource.getEmfResource();
                        } else {
                            IPath location = ModelUtil.getLocation(iResource);
                            if (location != null) {
                                URI uri = URI.createFileURI((String)location.toString());
                                resource = ModelerCore.getModelContainer().getResource(uri, true);
                                if (resource != null) {
                                    resource.setModified(false);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                IResource objToValidate = resource != null ? resource : iResource;
                Stopwatch totalWatch = new Stopwatch();
                totalWatch.start();
                validator.validate(progresssMonitor, objToValidate, context);
                totalWatch.stop();
                validator.addMarkers(context, iResource);
                context.clearResults();
            }
            catch (ModelerCoreException e) {
                Throwable underlyingException = e.getException();
                if (underlyingException instanceof DuplicateResourceException) {
                    try {
                        duplicateOfModel = iResource.getSessionProperty(ModelerCore.DUPLICATE_MODEL_OF_IPATH_KEY);
                    }
                    catch (CoreException err) {
                        ModelerCore.Util.log((Throwable)err);
                    }
                }
                ModelerCore.Util.log((Throwable)e);
            }
        }
        if (duplicateOfModel != null) {
            try {
                Object[] params = new Object[]{duplicateOfModel};
                String msg = ModelerCore.Util.getString("ModelBuildUtil.ModelDuplicateOf_0", params);
                IMarker marker = iResource.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("location", duplicateOfModel);
                marker.setAttribute("org.teiid.designer.core.markerURI", null);
                marker.setAttribute("org.teiid.designer.core.targetMarkerURI", null);
                marker.setAttribute("message", (Object)msg);
            }
            catch (CoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
    }

    public boolean rebuildImports(Resource resource, boolean includeDiagramReferences) {
        ModelResource mr;
        if (resource != null && (mr = ModelerCore.getModelEditor().findModelResource(resource)) != null && !mr.isReadOnly()) {
            OrganizeImportHandler handler = new OrganizeImportHandler(){

                @Override
                public Object choose(List options) {
                    return null;
                }
            };
            OrganizeImportCommand importCommand = new OrganizeImportCommand();
            importCommand.setResource(resource);
            importCommand.setHandler(handler);
            importCommand.setIncludeDiagramReferences(includeDiagramReferences);
            IProgressMonitor monitor = null;
            IStatus status = importCommand.canExecute();
            if (status.isOK()) {
                IStatus runStatus = importCommand.execute(monitor);
                if (!runStatus.isOK()) {
                    ModelerCore.Util.log(runStatus);
                    return false;
                }
                return true;
            }
            ModelerCore.Util.log(status);
        }
        return false;
    }

    public void setModifiedResources(List modifiedResources) {
        try {
            Container container = ModelerCore.getModelContainer();
            for (Object element : container.getResources()) {
                Resource resource = (Resource)element;
                if (modifiedResources != null && modifiedResources.contains(resource)) {
                    resource.setModified(true);
                    continue;
                }
                resource.setModified(false);
            }
        }
        catch (CoreException theException) {
            ModelerCore.Util.log(4, (Throwable)theException, theException.getMessage());
        }
    }

    private void updateResource(Collection resourcesInScope) {
        Resource[] systemVdbResources;
        Resource[] resourceArray = systemVdbResources = ModelerCore.getSystemVdbResources();
        int n = systemVdbResources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource systemVdbResource = resourceArray[n2];
            if (systemVdbResource instanceof EmfResource) {
                ObjectID objectID = ((EmfResource)systemVdbResource).getUuid();
                try {
                    Resource resrc = ModelerCore.getModelContainer().getResourceFinder().findByUUID(objectID, false);
                    if (resrc != null && !resourcesInScope.contains(resrc)) {
                        resourcesInScope.add(systemVdbResource);
                    }
                }
                catch (CoreException err) {
                    ModelerCore.Util.log((Throwable)err);
                }
            } else {
                resourcesInScope.add(systemVdbResource);
            }
            ++n2;
        }
    }

    public void validateResource(IProgressMonitor monitor, IResource iResource, ResourceValidator validator, ValidationContext context) {
        this.internalValidateResource(monitor, iResource, validator, context, true);
    }

    private void validateResource(IProgressMonitor monitor, Resource eResource, ResourceValidator validator, ValidationContext context) {
        IProgressMonitor progresssMonitor;
        CoreArgCheck.isNotNull((Object)eResource);
        CoreArgCheck.isNotNull((Object)validator);
        CoreArgCheck.isNotNull((Object)context);
        Object object = progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        if (monitor.isCanceled() || !validator.isValidatorForObject(eResource)) {
            return;
        }
        monitor.setTaskName(String.valueOf(MONITOR_RESOURCE_VALIDATION_MSG) + eResource.getURI().lastSegment());
        boolean isModified = eResource.isModified();
        try {
            try {
                Stopwatch totalWatch = new Stopwatch();
                totalWatch.start();
                validator.validate(progresssMonitor, eResource, context);
                totalWatch.stop();
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
                eResource.setModified(isModified);
            }
        }
        finally {
            eResource.setModified(isModified);
        }
    }

    public void validateResource(IProgressMonitor monitor, Resource eResource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)eResource);
        CoreArgCheck.isNotNull((Object)context);
        for (ResourceValidator validator : VALIDATORS) {
            this.validateResource(monitor, eResource, validator, context);
        }
    }

    public void validateResources(IProgressMonitor monitor, Collection iResources, Container container, boolean validateInContext) {
        IProgressMonitor progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        ValidationContext context = this.createValidationContext();
        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
        try {
            Resource[] resourcesInScope = this.getWorkspaceResourcesInScope(workspace);
            context.setResourcesInScope(resourcesInScope);
        }
        catch (CoreException theException) {
            ModelerCore.Util.log((Throwable)theException);
        }
        if (validateInContext && iResources != null) {
            ArrayList<Resource> temp = new ArrayList<Resource>();
            for (IResource iResource : iResources) {
                if (!ModelUtil.isModelFile(iResource)) continue;
                try {
                    ModelResource modelResource = ModelerCore.getModelEditor().findModelResource((IResource)((IFile)iResource));
                    if (modelResource == null) continue;
                    temp.add(modelResource.getEmfResource());
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log((Throwable)((Object)theException));
                }
            }
            context.setResourcesToValidate(temp.toArray(new Resource[temp.size()]));
        }
        context.setResourceContainer(container);
        this.clearResourceMarkers(iResources);
        for (ResourceValidator validator : VALIDATORS) {
            validator.validationStarted(iResources, context);
            try {
                for (IResource resource : iResources) {
                    this.internalValidateResource(progresssMonitor, resource, validator, context, false);
                }
            }
            finally {
                validator.validationEnded(context);
            }
        }
        context.clearState();
    }

    public void validateResources(IProgressMonitor monitor, Resource[] eResources, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)eResources);
        CoreArgCheck.isNotNull((Object)context);
        IProgressMonitor progresssMonitor = monitor != null ? monitor : new NullProgressMonitor();
        context.setResourcesToValidate(eResources);
        int i = 0;
        while (i < eResources.length) {
            this.validateResource(progresssMonitor, eResources[i], context);
            ++i;
        }
    }
}

