/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.ui.forms;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class FormUtils {
    public static Section createSection(final IManagedForm managedForm, FormToolkit toolkit, Composite parent, String title, String description, int style, boolean shouldGiveUpVerticalSpaceWhenFolded) {
        final Section section = toolkit.createSection(parent, style);
        section.setText(title);
        if ((style & 0x80) != 0) {
            section.setDescription(description);
            section.getDescriptionControl().setFont(JFaceResources.getBannerFont());
        }
        section.setLayoutData((Object)new GridData(4, 4, true, (style & 0x40) == 64));
        managedForm.addPart((IFormPart)new SectionPart(section));
        if (shouldGiveUpVerticalSpaceWhenFolded) {
            ExpansionAdapter handler = new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    GridData gridData = (GridData)section.getLayoutData();
                    gridData.grabExcessVerticalSpace = e.getState();
                    managedForm.reflow(true);
                }
            };
            section.addExpansionListener((IExpansionListener)handler);
        }
        return section;
    }

    public static IToolBarManager createSectionToolBar(Section section, FormToolkit toolkit, IAction[] actions) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)section);
        toolkit.adapt((Composite)toolBar);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        section.setTextClient((Control)toolBar);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            toolBarManager.add(action);
            ++n2;
        }
        toolBarManager.update(true);
        return toolBarManager;
    }

    public static Table createTable(FormToolkit toolkit, Composite parent) {
        Table table = toolkit.createTable(parent, 2820);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        return table;
    }

    public static IToolBarManager createToolBar(Composite parent, FormToolkit toolkit, IAction[] actions, int ... separatorIndexes) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl(parent);
        toolBar.setLayoutData((Object)new GridData(4, 16384, true, false));
        toolkit.adapt((Composite)toolBar);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        boolean hasSeparators = separatorIndexes != null && separatorIndexes.length != 0;
        int i = 0;
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            if (hasSeparators) {
                int[] indexes;
                int[] nArray = indexes = separatorIndexes;
                int n3 = indexes.length;
                int n4 = 0;
                while (n4 < n3) {
                    int separatorIndex = nArray[n4];
                    if (separatorIndex == i) {
                        toolBarManager.add((IContributionItem)new Separator());
                        ++i;
                        break;
                    }
                    ++n4;
                }
            }
            toolBarManager.add(action);
            ++i;
            ++n2;
        }
        toolBarManager.update(true);
        return toolBarManager;
    }

    private FormUtils() {
    }

    public static interface Styles {
        public static final int COMBO_STYLE = 0x800808;
        public static final int SECTION_STYLE = 8642;
        public static final int TEXT_STYLE = 2048;
        public static final int VIEWER_STYLE = 2820;
    }
}

