/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.PreferenceConstants;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.PreviewVdbJob;
import org.teiid.designer.runtime.spi.ITeiidServer;

public abstract class TeiidPreviewVdbJob
extends Job
implements PreferenceConstants,
PreviewVdbJob {
    public static final Object TEIID_PREVIEW_FAMILY = PreviewVdbJob.PREVIEW_FAMILY + ".teiid";
    private final PreviewContext context;
    private final ITeiidServer previewServer;

    public TeiidPreviewVdbJob(String jobName, PreviewContext context, ITeiidServer previewServer) {
        super(jobName);
        assert (context != null);
        this.context = context;
        this.previewServer = previewServer;
    }

    public boolean belongsTo(Object family) {
        return TEIID_PREVIEW_FAMILY == family;
    }

    @Override
    public boolean completedSuccessfully() {
        IStatus status = this.getResult();
        if (status == null) {
            return false;
        }
        return status.getSeverity() != 4;
    }

    @Override
    public PreviewContext getContext() {
        return this.context;
    }

    protected final ITeiidServer getPreviewServer() {
        return this.previewServer;
    }

    protected final IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        long startTime;
        block13: {
            assert (this.getPreviewServer() != null) : "Teiid Instance is null";
            if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobStart")) {
                DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobStarted, (Object)this.getName()));
            }
            IStatus results = null;
            startTime = System.currentTimeMillis();
            monitor.setTaskName(this.getName());
            try {
                results = this.runImpl(monitor);
                assert (results != null);
                iStatus = results;
                if (!DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) break block13;
            }
            catch (Exception e) {
                Status status;
                block16: {
                    block14: {
                        Status status2;
                        block15: {
                            try {
                                if (!(e instanceof InterruptedException)) break block14;
                                status2 = new Status(2, "org.teiid.designer.dqp", NLS.bind((String)Messages.JobCanceled, (Object)this.getName()), (Throwable)e);
                                if (!DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) break block15;
                            }
                            catch (Throwable throwable) {
                                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) {
                                    DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
                                }
                                monitor.done();
                                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
                                    long milliseconds = System.currentTimeMillis() - startTime;
                                    long hours = milliseconds / 3600000L;
                                    long minutes = milliseconds % 3600000L / 60000L;
                                    long seconds = milliseconds % 3600000L % 60000L / 1000L;
                                    String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
                                    DqpPlugin.Util.log(1, msg);
                                }
                                throw throwable;
                            }
                            DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
                        }
                        monitor.done();
                        if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
                            long milliseconds = System.currentTimeMillis() - startTime;
                            long hours = milliseconds / 3600000L;
                            long minutes = milliseconds % 3600000L / 60000L;
                            long seconds = milliseconds % 3600000L % 60000L / 1000L;
                            String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
                            DqpPlugin.Util.log(1, msg);
                        }
                        return status2;
                    }
                    status = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.UnexpectedErrorRunningJob, (Object)this.getName()), (Throwable)e);
                    if (!DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDone")) break block16;
                    DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
                }
                monitor.done();
                if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
                    long milliseconds = System.currentTimeMillis() - startTime;
                    long hours = milliseconds / 3600000L;
                    long minutes = milliseconds % 3600000L / 60000L;
                    long seconds = milliseconds % 3600000L % 60000L / 1000L;
                    String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
                    DqpPlugin.Util.log(1, msg);
                }
                return status;
            }
            DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobFinished, (Object)this.getName(), (Object)(results.getSeverity() != 4 ? 1 : 0)));
        }
        monitor.done();
        if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobDuration")) {
            long milliseconds = System.currentTimeMillis() - startTime;
            long hours = milliseconds / 3600000L;
            long minutes = milliseconds % 3600000L / 60000L;
            long seconds = milliseconds % 3600000L % 60000L / 1000L;
            String msg = hours > 0L ? NLS.bind((String)Messages.LongDurationJob, (Object[])new Object[]{this.getName(), hours, minutes, seconds}) : (minutes > 0L ? NLS.bind((String)Messages.LessThanAnHourDurationJob, (Object[])new Object[]{this.getName(), minutes, seconds}) : (seconds > 0L ? NLS.bind((String)Messages.LessThanAMinuteDurationJob, (Object)this.getName(), (Object)seconds) : NLS.bind((String)Messages.LessThanASecondDurationJob, (Object)this.getName())));
            DqpPlugin.Util.log(1, msg);
        }
        return iStatus;
    }

    protected abstract IStatus runImpl(IProgressMonitor var1) throws Exception;

    public boolean shouldRun() {
        boolean result = DqpPlugin.getInstance().getPreferences().getBoolean("org.teiid.designer.dqp.preferences.PreviewEnabled", true);
        if (result) {
            boolean bl = result = this.getPreviewServer() != null && this.getPreviewServer().isConnected();
        }
        if (DqpPlugin.getInstance().isDebugOptionEnabled("org.teiid.designer.dqp/debug/preview/jobs/jobShouldRun")) {
            DqpPlugin.Util.log(1, NLS.bind((String)Messages.JobShouldRun, (Object)this.getName(), (Object)result));
        }
        return result;
    }
}

