/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.preview.jobs.CompositePreviewJob;
import org.teiid.designer.runtime.preview.jobs.CreatePreviewVdbJob;
import org.teiid.designer.runtime.preview.jobs.UpdatePreviewVdbJob;
import org.teiid.designer.runtime.preview.jobs.WorkspacePreviewVdbJob;
import org.teiid.designer.runtime.spi.ITeiidServer;

public final class ModelChangedJob
extends CompositePreviewJob {
    private final IFile changedModel;

    public ModelChangedJob(IFile changedModel, PreviewContext context, ITeiidServer previewServer) throws Exception {
        super(NLS.bind((String)Messages.ModelChangedJob, (Object)changedModel), context, previewServer, true);
        assert (PreviewManager.isPreviewableResource(changedModel)) : "model is not previewable" + changedModel.getFullPath();
        this.changedModel = changedModel;
        this.process(previewServer);
    }

    public boolean belongsTo(Object family) {
        return WorkspacePreviewVdbJob.WORKSPACE_PREVIEW_FAMILY == family;
    }

    private void process(ITeiidServer previewServer) throws Exception {
        PreviewContext context = this.getContext();
        try {
            if (this.changedModel.exists()) {
                if (!this.changedModel.isSynchronized(2)) {
                    this.changedModel.refreshLocal(2, null);
                }
                this.add(new CreatePreviewVdbJob(this.changedModel, context));
                this.add(new UpdatePreviewVdbJob(this.changedModel, previewServer, context));
            } else {
                this.cancel();
            }
        }
        catch (Exception e) {
            this.cancel();
            DqpPlugin.Util.log((Throwable)e);
        }
    }
}

