/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.connection;

import java.util.Properties;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.vdb.connections.VdbSourceConnection;

public class ModelConnectionMapper {
    String modelName;
    Properties properties;
    private ModelResource modelResource;
    private IConnectionInfoProvider connectionInfoProvider;

    public ModelConnectionMapper(String modelName, Properties properties) {
        CoreArgCheck.isNotEmpty((String)modelName);
        CoreArgCheck.isNotEmpty((Properties)properties);
        this.modelName = modelName;
        this.properties = (Properties)properties.clone();
        String profileID = this.properties.getProperty("connectionProfile:connectionProfileInstanceID");
        this.connectionInfoProvider = new ConnectionInfoProviderFactory().getProviderFromProfileID(profileID);
    }

    public ModelConnectionMapper(String modelName, Properties properties, IConnectionInfoProvider connectionInfoProvider) {
        this(connectionInfoProvider);
        CoreArgCheck.isNotEmpty((String)modelName);
        CoreArgCheck.isNotEmpty((Properties)properties);
        this.modelName = modelName;
        this.properties = (Properties)properties.clone();
    }

    public ModelConnectionMapper(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        this.modelResource = modelResource;
        try {
            this.connectionInfoProvider = new ConnectionInfoProviderFactory().getProvider(this.modelResource);
        }
        catch (Exception exception) {}
    }

    public ModelConnectionMapper(ModelResource modelResource, IConnectionInfoProvider connectionInfoProvider) {
        this(connectionInfoProvider);
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        this.modelResource = modelResource;
    }

    private ModelConnectionMapper(IConnectionInfoProvider connectionInfoProvider) {
        CoreArgCheck.isNotNull((Object)connectionInfoProvider, (String)"connectionInfoProvider");
        this.connectionInfoProvider = connectionInfoProvider;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private IConnectionInfoProvider getConnectionInfoProvider() throws Exception {
        if (this.connectionInfoProvider == null) {
            if (this.modelResource != null) {
                this.connectionInfoProvider = new ConnectionInfoProviderFactory().getProvider(this.modelResource);
            } else if (this.properties != null) {
                this.connectionInfoProvider = new ConnectionInfoProviderFactory().getProvider(this.properties);
            } else {
                throw new Exception(DqpPlugin.Util.getString("ModelConnectionoMapper.cant.create.ConnectionInfoProvider", new Object[0]));
            }
        }
        return this.connectionInfoProvider;
    }

    public VdbSourceConnection getVdbSourceConnection(ITeiidServer teiidServer, String workspaceUuid) throws Exception {
        if (teiidServer == null || !teiidServer.isConnected()) {
            return null;
        }
        VdbSourceConnection sourceConnection = null;
        String translatorName = null;
        String jndiName = null;
        String dsTypeName = null;
        IConnectionInfoProvider provider = this.getConnectionInfoProvider();
        Properties sourceProps = provider.getConnectionProperties(this.modelResource);
        jndiName = provider.generateUniqueConnectionJndiName(this.modelResource, workspaceUuid);
        dsTypeName = provider.findMatchingDataSourceTypeName(this.modelResource);
        teiidServer.getOrCreateDataSource(this.modelResource.getItemName(), jndiName, dsTypeName, sourceProps);
        translatorName = provider.getTranslatorName(this.modelResource);
        sourceConnection = new VdbSourceConnection(this.modelName, translatorName, jndiName);
        sourceConnection = new VdbSourceConnection(this.modelName, translatorName, jndiName);
        return sourceConnection;
    }
}

