/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.teiid.core.designer.util.Base64;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.core.util.KeyInValueHashMap;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.IServersProvider;
import org.teiid.designer.runtime.OrphanedTeiidServerException;
import org.teiid.designer.runtime.TeiidAdminInfo;
import org.teiid.designer.runtime.TeiidJdbcInfo;
import org.teiid.designer.runtime.TeiidParentServerListener;
import org.teiid.designer.runtime.TeiidServerFactory;
import org.teiid.designer.runtime.importer.ImportManager;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidAdminInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.spi.ITeiidServerVersionListener;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TeiidServerManager
implements ITeiidServerManager {
    private static final String DESIGNER_UI_PLUGIN_ID = "org.teiid.designer.ui";
    private static final String CUSTOM_LABEL_ATTR = "customLabel";
    private static final String DEFAULT_ATTR = "default";
    private static final String PASSWORD_ATTR = "password";
    private static final String REGISTRY_FILE = "serverRegistry.xml";
    private static final String SERVER_TAG = "server";
    private static final String SERVERS_TAG = "servers";
    private static final String ADMIN_TAG = "admin";
    private static final String JDBC_TAG = "jdbc";
    private static final String USER_ATTR = "user";
    private static final String HOST_ATTR = "host";
    private static final String PARENT_SERVER_ID = "parentServerId";
    private static final String SERVER_VERSION = "version";
    private static final String PORT_ATTR = "port";
    private static final String SECURE_ATTR = "secure";
    private static final String JDBC_HOST_ATTR = "jdbchost";
    private static final String JDBC_PORT_ATTR = "jdbcport";
    private static final String JDBC_USER_ATTR = "jdbcuser";
    private static final String JDBC_PASSWORD_ATTR = "jdbcpassword";
    private static final String JDBC_SECURE_ATTR = "jdbcsecure";
    private final CopyOnWriteArrayList<IExecutionConfigurationListener> listeners;
    private final String stateLocationPath;
    private final KeyInValueHashMap<String, ITeiidServer> teiidServers;
    private ITeiidServer defaultServer;
    private Set<ITeiidServerVersionListener> teiidServerVersionListeners;
    private final ReadWriteLock serverLock = new ReentrantReadWriteLock();
    private ITeiidServerManager.RuntimeState state = ITeiidServerManager.RuntimeState.INVALID;
    private IServersProvider parentServersProvider;
    private ISecureStorageProvider secureStorageProvider;
    private boolean closeEditorsOnDefaultServerChange = false;
    private boolean notifyListeners = true;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"defaultTeiidServerVersion".equals(event.getKey())) {
                return;
            }
            if (TeiidServerManager.this.getDefaultServer() != null) {
                return;
            }
            if (TeiidServerManager.this.getDefaultServerVersion().equals(event.getNewValue())) {
                return;
            }
            TeiidServerManager.this.closeEditors();
            if (TeiidServerManager.this.teiidServerVersionListeners == null) {
                return;
            }
            for (ITeiidServerVersionListener listener : TeiidServerManager.this.teiidServerVersionListeners) {
                listener.versionChanged(TeiidServerManager.this.getDefaultServerVersion());
            }
        }
    };

    public TeiidServerManager() {
        this(DqpPlugin.getInstance().getRuntimePath().toFile().getAbsolutePath(), DqpPlugin.getInstance().getServersProvider(), ConnectivityUtil.getSecureStorageProvider());
    }

    public TeiidServerManager(String stateLocationPath, IServersProvider parentServersProvider, ISecureStorageProvider secureStorageProvider) {
        CoreArgCheck.isNotNull((Object)stateLocationPath);
        CoreArgCheck.isNotNull((Object)parentServersProvider);
        CoreArgCheck.isNotNull((Object)secureStorageProvider);
        this.teiidServers = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new TeiidServerKeyValueAdapter());
        this.stateLocationPath = stateLocationPath;
        this.parentServersProvider = parentServersProvider;
        this.secureStorageProvider = secureStorageProvider;
        this.listeners = new CopyOnWriteArrayList();
    }

    private void checkStarted() {
        if (!ITeiidServerManager.RuntimeState.STARTED.equals((Object)this.state)) {
            throw new RuntimeException("Programming error: The TeiidServerManager is being used before it has been initialised");
        }
    }

    public ISecureStorageProvider getSecureStorageProvider() {
        this.checkStarted();
        return this.secureStorageProvider;
    }

    public ITeiidServer getDefaultServer() {
        this.checkStarted();
        return this.defaultServer;
    }

    public ITeiidServer getServer(String id) {
        this.checkStarted();
        CoreArgCheck.isNotNull((Object)id, (String)"id");
        return (ITeiidServer)this.teiidServers.get((Object)id);
    }

    public ITeiidServer getServer(IServer parentServer) {
        this.checkStarted();
        CoreArgCheck.isNotNull((Object)parentServer, (String)"parentServer");
        for (ITeiidServer teiidServer : this.getServers()) {
            if (!parentServer.equals(teiidServer.getParent())) continue;
            return teiidServer;
        }
        return null;
    }

    public Collection<ITeiidServer> getServers() {
        this.checkStarted();
        try {
            this.serverLock.readLock().lock();
            Collection<ITeiidServer> collection = Collections.unmodifiableCollection(this.teiidServers.values());
            return collection;
        }
        finally {
            this.serverLock.readLock().unlock();
        }
    }

    private ITeiidServerVersion getDefaultServerVersionInternal() {
        if (this.defaultServer == null) {
            IEclipsePreferences preferences = DqpPlugin.getInstance().getPreferences(DESIGNER_UI_PLUGIN_ID);
            ITeiidServerVersion defaultVersion = TeiidServerVersion.deriveUltimateDefaultServerVersion();
            String versionString = preferences.get("defaultTeiidServerVersion", defaultVersion.toString());
            return new TeiidServerVersion(versionString);
        }
        return this.defaultServer.getServerVersion();
    }

    public ITeiidServerVersion getDefaultServerVersion() {
        this.checkStarted();
        return this.getDefaultServerVersionInternal();
    }

    public ITeiidServerManager.RuntimeState getState() {
        return this.state;
    }

    public boolean isStarted() {
        return ITeiidServerManager.RuntimeState.STARTED.equals((Object)this.state);
    }

    private String getStateFileName() {
        String name = this.stateLocationPath;
        if (this.stateLocationPath != null) {
            name = String.valueOf(name) + File.separatorChar + REGISTRY_FILE;
        }
        return name;
    }

    private IStatus addServerInternal(ITeiidServer teiidServer, boolean notifyListeners) {
        CoreArgCheck.isNotNull((Object)teiidServer, (String)SERVER_TAG);
        boolean added = false;
        ITeiidServer defaultServer = null;
        try {
            this.serverLock.writeLock().lock();
            if (!this.isRegisteredInternal(teiidServer)) {
                if (this.teiidServers.isEmpty()) {
                    defaultServer = teiidServer;
                }
                added = this.teiidServers.add((Object)teiidServer);
            }
        }
        finally {
            this.serverLock.writeLock().unlock();
        }
        if (added) {
            if (notifyListeners) {
                this.notifyListeners(ExecutionConfigurationEvent.createAddServerEvent((ITeiidServer)teiidServer));
            }
            if (defaultServer != null) {
                this.setDefaultServerInternal(defaultServer);
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("serverExistsMsg", (Object)teiidServer));
    }

    public IStatus addServer(ITeiidServer teiidServer) {
        this.checkStarted();
        return this.addServerInternal(teiidServer, true);
    }

    private IStatus removeServerInternal(ITeiidServer teiidServer, boolean notifyListeners) {
        ITeiidServer removed = null;
        try {
            this.serverLock.writeLock().lock();
            removed = (ITeiidServer)this.teiidServers.remove((Object)teiidServer);
            if (teiidServer.equals(this.getDefaultServer())) {
                if (this.teiidServers.isEmpty()) {
                    this.setDefaultServerInternal(null);
                } else {
                    this.setDefaultServerInternal((ITeiidServer)this.teiidServers.values().iterator().next());
                }
            }
        }
        finally {
            this.serverLock.writeLock().unlock();
        }
        if (removed != null) {
            if (notifyListeners) {
                this.notifyListeners(ExecutionConfigurationEvent.createRemoveServerEvent((ITeiidServer)teiidServer));
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("serverManagerRegistryRemoveUnexpectedError", (Object)teiidServer));
    }

    public IStatus removeServer(ITeiidServer teiidServer) {
        this.checkStarted();
        CoreArgCheck.isNotNull((Object)teiidServer, (String)SERVER_TAG);
        return this.removeServerInternal(teiidServer, true);
    }

    public boolean isDefaultServer(ITeiidServer teiidServer) {
        this.checkStarted();
        CoreArgCheck.isNotNull((Object)teiidServer, (String)SERVER_TAG);
        if (this.defaultServer == null) {
            return false;
        }
        return this.defaultServer.equals(teiidServer);
    }

    private boolean isRegisteredInternal(ITeiidServer teiidServer) {
        try {
            this.serverLock.readLock().lock();
            boolean bl = this.teiidServers.containsValue((Object)teiidServer);
            return bl;
        }
        finally {
            this.serverLock.readLock().unlock();
        }
    }

    public boolean isRegistered(ITeiidServer teiidServer) {
        this.checkStarted();
        CoreArgCheck.isNotNull((Object)teiidServer, (String)SERVER_TAG);
        return this.isRegisteredInternal(teiidServer);
    }

    public void permitListeners(boolean enable) {
        this.notifyListeners = enable;
    }

    public void notifyListeners(ExecutionConfigurationEvent event) {
        if (!this.notifyListeners) {
            return;
        }
        if (ITeiidServerManager.RuntimeState.SHUTTING_DOWN.equals((Object)this.getState()) || ITeiidServerManager.RuntimeState.SHUTDOWN.equals((Object)this.getState())) {
            return;
        }
        for (IExecutionConfigurationListener l : this.listeners) {
            try {
                l.configurationChanged(event);
            }
            catch (Exception e) {
                this.removeListener(l);
                DqpPlugin.Util.log(2, (Throwable)e, DqpPlugin.Util.getString("unexpectedErrorInExecutionConfigurationListener", (Object)l));
            }
        }
    }

    private IServer findParentServer(String host, String parentServerId, ITeiidAdminInfo teiidAdminInfo) throws OrphanedTeiidServerException {
        IServer[] servers;
        IServer[] iServerArray = servers = this.parentServersProvider.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (host.equals(server.getHost()) && (parentServerId == null || server.getId().equals(parentServerId))) {
                return server;
            }
            ++n2;
        }
        throw new OrphanedTeiidServerException(teiidAdminInfo);
    }

    private void initialiseManagers() {
        PreviewManager previewManager = PreviewManager.getInstance();
        this.addListener(previewManager);
        this.addListener(ImportManager.getInstance());
        IEclipsePreferences preferences = DqpPlugin.getInstance().getPreferences(DESIGNER_UI_PLUGIN_ID);
        preferences.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    private void restoreStateInternal() {
        this.parentServersProvider.addServerStateListener(TeiidParentServerListener.getInstance());
        this.parentServersProvider.addServerLifecycleListener(TeiidParentServerListener.getInstance());
        ITeiidServer defaultServer = null;
        try {
            this.notifyListeners = false;
            if (this.stateLocationPath == null || !this.stateFileExists()) {
                return;
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.parse(new File(this.getStateFileName()));
                Element root = doc.getDocumentElement();
                NodeList servers = root.getChildNodes();
                int size = servers.getLength();
                int i = 0;
                while (i < size) {
                    block32: {
                        TeiidAdminInfo teiidAdminInfo = null;
                        TeiidJdbcInfo teiidJdbcInfo = null;
                        Node serverNode = servers.item(i);
                        NamedNodeMap serverAttributeMap = serverNode.getAttributes();
                        if (serverAttributeMap != null) {
                            NodeList connectionNodes;
                            Node defaultServerNode;
                            Node customLabelNode;
                            Node parentServerNode;
                            Node hostNode;
                            String host = null;
                            String parentServerId = null;
                            String customLabel = null;
                            boolean previewServer = false;
                            ITeiidServerVersion teiidServerVersion = TeiidServerVersion.Version.TEIID_DEFAULT.get();
                            Node versionNode = serverAttributeMap.getNamedItem(SERVER_VERSION);
                            if (versionNode != null) {
                                teiidServerVersion = new TeiidServerVersion(versionNode.getNodeValue());
                            }
                            if ((hostNode = serverAttributeMap.getNamedItem(HOST_ATTR)) != null) {
                                host = hostNode.getNodeValue();
                            }
                            if ((parentServerNode = serverAttributeMap.getNamedItem(PARENT_SERVER_ID)) != null) {
                                parentServerId = parentServerNode.getNodeValue();
                            }
                            if ((customLabelNode = serverAttributeMap.getNamedItem(CUSTOM_LABEL_ATTR)) != null) {
                                customLabel = customLabelNode.getNodeValue();
                            }
                            if ((defaultServerNode = serverAttributeMap.getNamedItem(DEFAULT_ATTR)) != null) {
                                previewServer = Boolean.parseBoolean(defaultServerNode.getNodeValue());
                            }
                            if ((connectionNodes = serverNode.getChildNodes()).getLength() > 0) {
                                int connSize = connectionNodes.getLength();
                                int j = 0;
                                while (j < connSize) {
                                    Node connNode = connectionNodes.item(j);
                                    if (connNode.getNodeType() != 3) {
                                        NamedNodeMap attributeMap;
                                        if (connNode.getNodeName().equalsIgnoreCase(ADMIN_TAG)) {
                                            attributeMap = connNode.getAttributes();
                                            if (attributeMap != null) {
                                                if (host == null) {
                                                    Node adminHostNode = attributeMap.getNamedItem(HOST_ATTR);
                                                    assert (adminHostNode != null);
                                                    host = adminHostNode.getNodeValue();
                                                }
                                                Node adminPortNode = attributeMap.getNamedItem(PORT_ATTR);
                                                assert (adminPortNode != null);
                                                String adminPort = adminPortNode.getNodeValue();
                                                Node userNode = attributeMap.getNamedItem(USER_ATTR);
                                                assert (userNode != null);
                                                String adminUsername = userNode.getNodeValue();
                                                Node passwordNode = attributeMap.getNamedItem(PASSWORD_ATTR);
                                                String adminPassword = passwordNode == null ? null : new String(Base64.decode((CharSequence)passwordNode.getNodeValue()), "UTF-8");
                                                Node adminSecureNode = attributeMap.getNamedItem(SECURE_ATTR);
                                                String adminSecureStr = adminSecureNode == null ? Boolean.FALSE.toString() : adminSecureNode.getNodeValue();
                                                teiidAdminInfo = new TeiidAdminInfo(adminPort, adminUsername, this.secureStorageProvider, adminPassword, Boolean.parseBoolean(adminSecureStr));
                                            }
                                        } else if (connNode.getNodeName().equalsIgnoreCase(JDBC_TAG) && (attributeMap = connNode.getAttributes()) != null) {
                                            if (host == null) {
                                                Node jdbcHostNode = attributeMap.getNamedItem(JDBC_HOST_ATTR);
                                                assert (jdbcHostNode != null);
                                                host = jdbcHostNode.getNodeValue();
                                            }
                                            Node jdbcPortNode = attributeMap.getNamedItem(JDBC_PORT_ATTR);
                                            assert (jdbcPortNode != null);
                                            String jdbcPort = jdbcPortNode.getNodeValue();
                                            Node jdbcUserNode = attributeMap.getNamedItem(JDBC_USER_ATTR);
                                            assert (jdbcUserNode != null);
                                            String jdbcUsername = jdbcUserNode.getNodeValue();
                                            Node jdbcPasswordNode = attributeMap.getNamedItem(JDBC_PASSWORD_ATTR);
                                            String jdbcPassword = jdbcPasswordNode == null ? null : new String(Base64.decode((CharSequence)jdbcPasswordNode.getNodeValue()), "UTF-8");
                                            Node jdbcSecureNode = attributeMap.getNamedItem(JDBC_SECURE_ATTR);
                                            String jdbcSecureStr = jdbcSecureNode == null ? Boolean.FALSE.toString() : jdbcSecureNode.getNodeValue();
                                            teiidJdbcInfo = new TeiidJdbcInfo(jdbcPort, jdbcUsername, this.secureStorageProvider, jdbcPassword, Boolean.parseBoolean(jdbcSecureStr));
                                        }
                                    }
                                    ++j;
                                }
                            }
                            IServer parentServer = null;
                            try {
                                parentServer = this.findParentServer(host, parentServerId, teiidAdminInfo);
                            }
                            catch (OrphanedTeiidServerException orphanedTeiidServerException) {
                                break block32;
                            }
                            TeiidServerFactory teiidServerFactory = new TeiidServerFactory();
                            ITeiidServer teiidServer = teiidServerFactory.createTeiidServer(teiidServerVersion, teiidAdminInfo, teiidJdbcInfo, this, parentServer, new TeiidServerFactory.ServerOptions[0]);
                            teiidServer.setCustomLabel(customLabel);
                            this.addServerInternal(teiidServer, true);
                            if (previewServer) {
                                defaultServer = teiidServer;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                DqpPlugin.Util.log((Throwable)e);
            }
        }
        finally {
            this.notifyListeners = true;
            this.state = ITeiidServerManager.RuntimeState.STARTED;
            this.initialiseManagers();
            this.setDefaultServerInternal(defaultServer);
            this.closeEditorsOnDefaultServerChange = true;
        }
    }

    public void restoreState() {
        this.state = ITeiidServerManager.RuntimeState.RESTORING;
        if (this.parentServersProvider.isInitialised()) {
            this.restoreStateInternal();
            return;
        }
        IServersProvider.IServersInitialiseListener listener = new IServersProvider.IServersInitialiseListener(){

            @Override
            public void serversInitialised() {
                TeiidServerManager.this.restoreStateInternal();
            }
        };
        this.parentServersProvider.addServerInitialisedListener(listener);
    }

    private void setDefaultServerInternal(ITeiidServer teiidServer) {
        ITeiidServerVersion oldServerVersion;
        if (this.defaultServer == null && teiidServer == null) {
            return;
        }
        ITeiidServer oldDefaultServer = this.defaultServer;
        this.defaultServer = teiidServer;
        if (this.teiidServerVersionListeners != null) {
            for (ITeiidServerVersionListener listener : this.teiidServerVersionListeners) {
                listener.serverChanged(this.defaultServer);
            }
        }
        ITeiidServerVersion iTeiidServerVersion = oldServerVersion = oldDefaultServer != null ? oldDefaultServer.getServerVersion() : null;
        if (this.teiidServerVersionListeners != null && !this.getDefaultServerVersionInternal().equals(oldServerVersion)) {
            this.closeEditors();
            for (ITeiidServerVersionListener listener : this.teiidServerVersionListeners) {
                listener.versionChanged(this.getDefaultServerVersionInternal());
            }
        }
        this.notifyListeners(ExecutionConfigurationEvent.createSetDefaultServerEvent((ITeiidServer)oldDefaultServer, (ITeiidServer)this.defaultServer));
    }

    public void setDefaultServer(ITeiidServer teiidServer) {
        this.checkStarted();
        this.setDefaultServerInternal(teiidServer);
    }

    private void closeEditors() {
        if (ITeiidServerManager.RuntimeState.RESTORING == this.state || !this.closeEditorsOnDefaultServerChange) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] editorReferences;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                        int n5 = editorReferences.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorRef = iEditorReferenceArray[n6];
                            try {
                                IEditorInput input = editorRef.getEditorInput();
                                IResource resource = (IResource)input.getAdapter(IResource.class);
                                if (resource != null && DotProjectUtils.isModelerProject((IProject)resource.getProject())) {
                                    page.closeEditor(editorRef.getEditor(true), true);
                                }
                            }
                            catch (PartInitException ex) {
                                DqpPlugin.Util.log((Throwable)ex);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
    }

    public void shutdown(IProgressMonitor monitor) throws Exception {
        if (this.state == ITeiidServerManager.RuntimeState.SHUTTING_DOWN || this.state == ITeiidServerManager.RuntimeState.SHUTDOWN) {
            return;
        }
        try {
            IEclipsePreferences preferences;
            this.state = ITeiidServerManager.RuntimeState.SHUTTING_DOWN;
            if (monitor != null) {
                monitor.subTask(DqpPlugin.Util.getString("serverManagerSavingServerRegistryTask", new Object[0]));
            }
            if ((preferences = DqpPlugin.getInstance().getPreferences(DESIGNER_UI_PLUGIN_ID)) != null) {
                preferences.removePreferenceChangeListener(this.preferenceChangeListener);
            }
            this.saveState();
        }
        finally {
            this.state = ITeiidServerManager.RuntimeState.SHUTDOWN;
        }
    }

    private void saveState() throws TransformerFactoryConfigurationError {
        if (this.stateLocationPath == null) {
            return;
        }
        if (this.teiidServers.isEmpty()) {
            if (this.stateFileExists()) {
                try {
                    new File(this.getStateFileName()).delete();
                }
                catch (Exception exception) {
                    Status status = new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("errorDeletingServerRegistryFile", (Object)this.getStateFileName()));
                    DqpPlugin.Util.log((IStatus)status);
                }
            }
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement(SERVERS_TAG);
            doc.appendChild(root);
            Collection servers = this.teiidServers.values();
            for (ITeiidServer teiidServer : servers) {
                Element serverElement = doc.createElement(SERVER_TAG);
                root.appendChild(serverElement);
                serverElement.setAttribute(SERVER_VERSION, teiidServer.getServerVersion().toString());
                serverElement.setAttribute(HOST_ATTR, teiidServer.getHost());
                serverElement.setAttribute(PARENT_SERVER_ID, teiidServer.getParent().getId());
                if (!StringUtilities.isEmpty((String)teiidServer.getCustomLabel())) {
                    serverElement.setAttribute(CUSTOM_LABEL_ATTR, teiidServer.getCustomLabel());
                }
                Element adminElement = doc.createElement(ADMIN_TAG);
                serverElement.appendChild(adminElement);
                adminElement.setAttribute(PORT_ATTR, teiidServer.getTeiidAdminInfo().getPort());
                adminElement.setAttribute(USER_ATTR, teiidServer.getTeiidAdminInfo().getUsername());
                String passToken = teiidServer.getTeiidAdminInfo().getPassToken();
                if (passToken != null) {
                    adminElement.setAttribute(PASSWORD_ATTR, Base64.encodeBytes((byte[])passToken.getBytes("UTF-8")));
                }
                adminElement.setAttribute(SECURE_ATTR, Boolean.toString(teiidServer.getTeiidAdminInfo().isSecure()));
                Element jdbcElement = doc.createElement(JDBC_TAG);
                serverElement.appendChild(jdbcElement);
                jdbcElement.setAttribute(JDBC_PORT_ATTR, teiidServer.getTeiidJdbcInfo().getPort());
                jdbcElement.setAttribute(JDBC_USER_ATTR, teiidServer.getTeiidJdbcInfo().getUsername());
                jdbcElement.setAttribute(JDBC_SECURE_ATTR, Boolean.toString(teiidServer.getTeiidJdbcInfo().isSecure()));
                if (this.defaultServer == null || !this.defaultServer.equals(teiidServer)) continue;
                serverElement.setAttribute(DEFAULT_ATTR, Boolean.toString(true));
            }
            DOMSource source = new DOMSource(doc);
            StreamResult resultXML = new StreamResult(new FileOutputStream(this.getStateFileName()));
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, resultXML);
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("errorSavingServerRegistry", (Object)this.getStateFileName()));
            DqpPlugin.Util.log((IStatus)status);
        }
    }

    private boolean stateFileExists() {
        return new File(this.getStateFileName()).exists();
    }

    public IStatus updateServer(ITeiidServer replacedServer, ITeiidServer updatedServer) {
        this.checkStarted();
        CoreArgCheck.isNotNull((Object)replacedServer, (String)"previousServerVersion");
        CoreArgCheck.isNotNull((Object)updatedServer, (String)"newServerVersion");
        IStatus status = null;
        try {
            this.serverLock.writeLock().lock();
            status = this.removeServerInternal(replacedServer, false);
            if (status.isOK()) {
                status = this.addServerInternal(updatedServer, false);
                if (status.isOK()) {
                    this.notifyListeners(ExecutionConfigurationEvent.createUpdateServerEvent((ITeiidServer)replacedServer, (ITeiidServer)updatedServer));
                    IStatus iStatus = status;
                    return iStatus;
                }
                IStatus undoRemoveServerStatus = this.addServerInternal(replacedServer, false);
                if (undoRemoveServerStatus.getSeverity() == 4) {
                    DqpPlugin.Util.log(undoRemoveServerStatus);
                }
                Status status2 = new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("serverManagerRegistryUpdateAddError", (Object)status.getMessage()));
                return status2;
            }
        }
        finally {
            this.serverLock.writeLock().unlock();
        }
        return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("serverManagerRegistryUpdateRemoveError", (Object)status.getMessage()));
    }

    public boolean addListener(IExecutionConfigurationListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener");
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(IExecutionConfigurationListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener");
        return this.listeners.remove(listener);
    }

    public void addTeiidServerVersionListener(ITeiidServerVersionListener listener) {
        if (this.teiidServerVersionListeners == null) {
            this.teiidServerVersionListeners = new HashSet<ITeiidServerVersionListener>();
        }
        this.teiidServerVersionListeners.add(listener);
    }

    public void removeTeiidServerVersionListener(ITeiidServerVersionListener listener) {
        if (this.teiidServerVersionListeners == null) {
            return;
        }
        this.teiidServerVersionListeners.remove(listener);
    }

    private class TeiidServerKeyValueAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, ITeiidServer> {
        private TeiidServerKeyValueAdapter() {
        }

        public String getKey(ITeiidServer value) {
            return value.getId();
        }
    }
}

