/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidServerFactory;
import org.teiid.designer.runtime.adapter.TeiidServerAdapterFactory;
import org.teiid.designer.runtime.spi.ITeiidConnectionInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class TeiidParentServerListener
implements IServerLifecycleListener,
IServerListener {
    private static TeiidParentServerListener instance;
    private TeiidServerAdapterFactory factory = new TeiidServerAdapterFactory();
    private boolean sleep;

    public static TeiidParentServerListener getInstance() {
        if (instance == null) {
            instance = new TeiidParentServerListener();
        }
        return instance;
    }

    private TeiidParentServerListener() {
    }

    public void serverAdded(IServer server) {
        if (this.sleep) {
            return;
        }
        DqpPlugin.getInstance().getServerManager();
        server.addServerListener((IServerListener)this);
        try {
            this.factory.adaptServer(server, TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY);
        }
        catch (Exception ex) {
            DqpPlugin.handleException(ex);
        }
    }

    public void serverChanged(IServer server) {
        if (this.sleep) {
            return;
        }
        ITeiidServerManager serverManager = DqpPlugin.getInstance().getServerManager();
        try {
            for (ITeiidServer teiidServer : serverManager.getServers()) {
                if (!server.equals(teiidServer.getParent())) continue;
                ITeiidServer newTeiidServer = this.factory.adaptServer(server, TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY, TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION);
                if (teiidServer.getServerVersion().isGreaterThan(TeiidServerVersion.Version.TEIID_7_7.get())) {
                    teiidServer.getTeiidAdminInfo().setAll((ITeiidConnectionInfo)newTeiidServer.getTeiidAdminInfo());
                }
                teiidServer.getTeiidJdbcInfo().setPort(newTeiidServer.getTeiidJdbcInfo().getPort());
                teiidServer.notifyRefresh();
                return;
            }
            this.factory.adaptServer(server, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY);
        }
        catch (Exception ex) {
            DqpPlugin.handleException(ex);
        }
    }

    public void serverRemoved(IServer server) {
        if (this.sleep) {
            return;
        }
        server.removeServerListener((IServerListener)this);
        ITeiidServerManager serverManager = DqpPlugin.getInstance().getServerManager();
        for (ITeiidServer teiidServer : serverManager.getServers()) {
            if (!server.equals(teiidServer.getParent())) continue;
            serverManager.removeServer(teiidServer);
            break;
        }
    }

    public void serverChanged(ServerEvent event) {
        if (this.sleep) {
            return;
        }
        if (event == null) {
            return;
        }
        int eventKind = event.getKind();
        if ((eventKind & 0x10) == 0) {
            return;
        }
        if ((eventKind & 1) == 0) {
            return;
        }
        int state = event.getState();
        IServer parentServer = event.getServer();
        try {
            ITeiidServer teiidServer;
            if (state == 3 || state == 4) {
                ITeiidServer teiidServer2 = this.factory.adaptServer(parentServer, new TeiidServerFactory.ServerOptions[0]);
                if (teiidServer2 != null) {
                    teiidServer2.disconnect();
                }
            } else if (state == 2 && (teiidServer = this.factory.adaptServer(parentServer, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY)) != null && teiidServer.isParentConnected()) {
                ITeiidServer queryServer = this.factory.adaptServer(parentServer, TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY);
                if (queryServer != null) {
                    teiidServer.getTeiidAdminInfo().setAll((ITeiidConnectionInfo)queryServer.getTeiidAdminInfo());
                    teiidServer.getTeiidJdbcInfo().setPort(queryServer.getTeiidJdbcInfo().getPort());
                } else {
                    DqpPlugin.getInstance().getServerManager().removeServer(teiidServer);
                }
                teiidServer.reconnect();
            }
        }
        catch (Exception ex) {
            DqpPlugin.handleException(ex);
        }
    }

    public void sleep() {
        this.sleep = true;
    }

    public void wake() {
        this.sleep = false;
    }
}

