/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidServerUtils;
import org.teiid.designer.runtime.spi.HostProvider;
import org.teiid.designer.runtime.spi.ITeiidConnectionInfo;

public abstract class TeiidConnectionInfo
implements ITeiidConnectionInfo {
    protected static final int DEFAULT_PORT_NUMBER = 0;
    private HostProvider hostProvider;
    private ISecureStorageProvider secureStorageProvider;
    private String passToken;
    private String port;
    private int portNumber = 0;
    private boolean secure;
    private String username;

    protected TeiidConnectionInfo(String port, String username, ISecureStorageProvider secureStorageProvider, String password, boolean secure) {
        this.port = port;
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 0;
        }
        this.username = username;
        this.secureStorageProvider = secureStorageProvider;
        this.secure = secure;
        this.initPassword(password);
    }

    protected void initPassword(String password) {
        if (password == null) {
            return;
        }
        if (ConnectivityUtil.isPasswordToken((String)password)) {
            this.setPassToken(password);
        } else {
            this.setPassword(password);
        }
    }

    protected abstract String getPasswordKey();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TeiidConnectionInfo thatInfo = (TeiidConnectionInfo)object;
        String thisHost = this.getHostProvider().getHost();
        String thatHost = thatInfo.getHostProvider().getHost();
        if (thisHost == null) {
            if (thatHost != null) {
                return false;
            }
        } else {
            if (thatHost == null) {
                return false;
            }
            if (!thisHost.equals(thatHost)) {
                return false;
            }
        }
        if (this.getPort() == null) {
            if (thatInfo.getPort() != null) {
                return false;
            }
        } else {
            if (thatInfo.getPort() == null) {
                return false;
            }
            if (!this.getPort().equals(thatInfo.getPort())) {
                return false;
            }
        }
        if (this.isSecure() != thatInfo.isSecure()) {
            return false;
        }
        if (this.getUsername() == null) {
            if (thatInfo.getUsername() != null) {
                return false;
            }
        } else {
            if (thatInfo.getUsername() == null) {
                return false;
            }
            if (!this.getUsername().equals(thatInfo.getUsername())) {
                return false;
            }
        }
        if (this.getPassword() == null) {
            if (thatInfo.getPassword() != null) {
                return false;
            }
        } else {
            if (thatInfo.getPassword() == null) {
                return false;
            }
            if (!this.getPassword().equals(thatInfo.getPassword())) {
                return false;
            }
        }
        return true;
    }

    public HostProvider getHostProvider() {
        if (this.hostProvider == null) {
            return HostProvider.DEFAULT_HOST_PROVIDER;
        }
        return this.hostProvider;
    }

    public ISecureStorageProvider getSecureStorageProvider() {
        return this.secureStorageProvider;
    }

    private String getProviderKey() {
        String key = this.passToken == null ? ConnectivityUtil.buildSecureStorageKey(this.getClass(), (String[])new String[]{this.getUrl()}) : ConnectivityUtil.buildSecureStorageKey(this.getClass(), (String[])new String[]{this.getUrl(), this.passToken});
        return key;
    }

    private boolean passwordExists() {
        try {
            String providerKey = this.getProviderKey();
            boolean exists = this.secureStorageProvider.existsInSecureStorage(providerKey, this.getPasswordKey());
            return exists;
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
            return false;
        }
    }

    private String retrievePassword() {
        try {
            String providerKey = this.getProviderKey();
            return this.secureStorageProvider.getFromSecureStorage(providerKey, this.getPasswordKey());
        }
        catch (Exception ex) {
            DqpPlugin.Util.log((Throwable)ex);
            return null;
        }
    }

    private void generatePasswordToken(String password) {
        try {
            this.passToken = ConnectivityUtil.generateHashToken((String[])new String[]{this.getUrl(), password});
            String providerKey = this.getProviderKey();
            this.secureStorageProvider.storeInSecureStorage(providerKey, this.getPasswordKey(), password);
        }
        catch (Exception e) {
            DqpPlugin.Util.log((Throwable)e);
        }
    }

    public String getPassword() {
        String password = this.retrievePassword();
        if (this.passToken == null && password != null) {
            this.generatePasswordToken(password);
        }
        return password;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public abstract String getType();

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isSecure() ? "mms://" : "mm://");
        sb.append(this.getHostProvider().getHost());
        sb.append(':');
        sb.append(this.getPort());
        return sb.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getHostProvider().getHost(), this.getPort(), this.isSecure(), this.getUsername()});
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setAll(ITeiidConnectionInfo info) {
        this.setHostProvider(info.getHostProvider());
        this.setPort(info.getPort());
        this.setUsername(info.getUsername());
        this.setSecure(info.isSecure());
        this.setPassToken(info.getPassToken());
        this.setPassword(info.getPassword());
    }

    public void setHostProvider(HostProvider hostProvider) {
        CoreArgCheck.isNotNull((Object)hostProvider, (String)"hostProvider");
        boolean passwordExists = this.passwordExists();
        String myPassword = null;
        if (passwordExists) {
            myPassword = this.retrievePassword();
        }
        this.hostProvider = hostProvider;
        if (passwordExists) {
            this.setPassword(myPassword);
        }
    }

    public String getPassToken() {
        return this.passToken;
    }

    public void setPassToken(String passToken) {
        this.passToken = passToken;
    }

    public void setPassword(String password) {
        this.generatePasswordToken(password);
    }

    public void setPort(String port) {
        boolean passwordExists = this.passwordExists();
        String myPassword = null;
        if (passwordExists) {
            myPassword = this.retrievePassword();
        }
        this.port = port;
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 0;
        }
        if (passwordExists) {
            this.setPassword(myPassword);
        }
    }

    public void setSecure(boolean secure) {
        boolean passwordExists = this.passwordExists();
        String myPassword = null;
        if (passwordExists) {
            myPassword = this.retrievePassword();
        }
        this.secure = secure;
        if (passwordExists) {
            this.setPassword(myPassword);
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return DqpPlugin.Util.getString("teiidConnectionInfoProperties", new Object[]{this.getType(), this.getHostProvider().getHost(), this.getPort(), this.getUsername(), this.getPassword(), this.isSecure()});
    }

    public IStatus validate() {
        IStatus status = this.validateUrl();
        if (!status.isOK()) {
            return status;
        }
        return this.validateUsername();
    }

    protected IStatus validateUrl() {
        try {
            TeiidServerUtils.validateServerUrl(this.getUrl());
        }
        catch (MalformedURLException e) {
            return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("invalidServerUrl", new Object[]{this.getType(), e.getMessage()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateUsername() {
        if (StringUtilities.isEmpty((String)this.username)) {
            return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("connectionUsernameIsEmpty", (Object)this.getType()));
        }
        return Status.OK_STATUS;
    }
}

