/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui;

import org.eclipse.birt.report.designer.ui.IReportPerspectiveExtra;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class ReportPerspective
implements IPerspectiveFactory {
    public static final String BIRT_REPORT_PERSPECTIVE = "org.eclipse.birt.report.designer.ui.ReportPerspective";
    public static final String NEW_REPORT_ID = "org.eclipse.birt.report.designer.ui.ide.wizards.NewReportWizard";
    public static final String NEW_TEMPLATE_ID = "org.eclipse.birt.report.designer.ui.ide.wizards.NewTemplateWizard";
    private IReportPerspectiveExtra extra;

    public ReportPerspective() {
        Object adapter = ElementAdapterManager.getAdapter((Object)this, IReportPerspectiveExtra.class);
        if (adapter instanceof IReportPerspectiveExtra) {
            this.extra = (IReportPerspectiveExtra)adapter;
        }
    }

    public void createInitialLayout(IPageLayout layout) {
        this.defineLayout(layout);
        this.defineActions(layout);
    }

    private void addNewWizardShortcut(IPageLayout layout, String id) {
        if (this.extra == null || !this.extra.obsoleteNewWizardShortcut(id)) {
            layout.addNewWizardShortcut(id);
        }
    }

    private void addShowViewShortcut(IPageLayout layout, String id) {
        if (this.extra == null || !this.extra.obsoleteShowViewShortcut(id)) {
            layout.addShowViewShortcut(id);
        }
    }

    private void defineActions(IPageLayout layout) {
        this.addNewWizardShortcut(layout, "org.eclipse.ui.wizards.new.folder");
        this.addNewWizardShortcut(layout, NEW_REPORT_ID);
        this.addNewWizardShortcut(layout, NEW_TEMPLATE_ID);
        this.addShowViewShortcut(layout, "org.eclipse.ui.views.ResourceNavigator");
        this.addShowViewShortcut(layout, "org.eclipse.ui.views.ContentOutline");
        this.addShowViewShortcut(layout, "org.eclipse.gef.ui.palette_view");
        this.addShowViewShortcut(layout, "org.eclipse.birt.report.designer.ui.attributes.AttributeView");
        this.addShowViewShortcut(layout, "org.eclipse.birt.report.designer.ui.views.data.DataView");
        this.addShowViewShortcut(layout, "org.eclipse.birt.report.designer.ui.lib.explorer.view");
        this.addShowViewShortcut(layout, "org.eclipse.ui.views.PropertySheet");
        this.addShowViewShortcut(layout, "org.eclipse.ui.views.ProblemView");
        this.addShowViewShortcut(layout, "org.eclipse.pde.runtime.LogView");
        layout.addPerspectiveShortcut(BIRT_REPORT_PERSPECTIVE);
        if (this.extra != null) {
            String id;
            int n;
            int n2;
            String[] stringArray;
            String[] ids = this.extra.getExtraNewWizardShortcut();
            if (ids != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    layout.addNewWizardShortcut(id);
                    ++n;
                }
            }
            if ((ids = this.extra.getExtraShowViewShortcut()) != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    layout.addShowViewShortcut(id);
                    ++n;
                }
            }
        }
    }

    private void addLayoutView(IFolderLayout folder, int layoutPos, String id) {
        if (this.extra == null || !this.extra.obsoleteLayoutView(layoutPos, id)) {
            folder.addView(id);
        }
    }

    private void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.26f, editorArea);
        this.addLayoutView(topLeft, 1, "org.eclipse.gef.ui.palette_view");
        this.addLayoutView(topLeft, 1, "org.eclipse.birt.report.designer.ui.views.data.DataView");
        this.addLayoutView(topLeft, 1, "org.eclipse.birt.report.designer.ui.lib.explorer.view");
        IFolderLayout bottomLeft = layout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        this.addLayoutView(bottomLeft, 2, "org.eclipse.ui.views.ResourceNavigator");
        this.addLayoutView(bottomLeft, 2, "org.eclipse.ui.views.ContentOutline");
        IFolderLayout bottomRight = layout.createFolder("bottomRight", 4, 0.66f, editorArea);
        this.addLayoutView(bottomRight, 3, "org.eclipse.birt.report.designer.ui.attributes.AttributeView");
        this.addLayoutView(bottomRight, 3, "org.eclipse.ui.views.ProblemView");
        this.addLayoutView(bottomRight, 3, "org.eclipse.pde.runtime.LogView");
        if (this.extra != null) {
            String id;
            int n;
            int n2;
            String[] stringArray;
            String[] ids = this.extra.getExtraLayoutView(1);
            if (ids != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    topLeft.addView(id);
                    ++n;
                }
            }
            if ((ids = this.extra.getExtraLayoutView(2)) != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    bottomLeft.addView(id);
                    ++n;
                }
            }
            if ((ids = this.extra.getExtraLayoutView(3)) != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    bottomRight.addView(id);
                    ++n;
                }
            }
            if ((ids = this.extra.getExtraLayoutPlaceholder(1)) != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    topLeft.addPlaceholder(id);
                    ++n;
                }
            }
            if ((ids = this.extra.getExtraLayoutPlaceholder(2)) != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    bottomLeft.addPlaceholder(id);
                    ++n;
                }
            }
            if ((ids = this.extra.getExtraLayoutPlaceholder(3)) != null) {
                stringArray = ids;
                n2 = ids.length;
                n = 0;
                while (n < n2) {
                    id = stringArray[n];
                    bottomRight.addPlaceholder(id);
                    ++n;
                }
            }
        }
    }
}

