/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.util.WebServiceBuildOptions;
import org.teiid.designer.webservice.util.WebServiceUtil;

public class WebServiceEditObject {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(WebServiceEditObject.class);
    private static final String EMPTY_STRING = "";
    private static final String INVALID_MODELNAME_MESSAGE = WebServiceEditObject.getString("invalidModelName.message");
    private static final String INVALID_INTERFACENAME_MESSAGE = WebServiceEditObject.getString("invalidInterfaceName.message");
    private static final String INVALID_OPERATIONNAME_MESSAGE = WebServiceEditObject.getString("invalidOperationName.message");
    private static final String OPERATIONNAME_ALREADY_EXISTS_MESSAGE = WebServiceEditObject.getString("operationNameAlreadyExists.message");
    private static final String INVALID_OPERATION_OUTPUTNAME_MESSAGE = WebServiceEditObject.getString("invalidOperationOutputMesgName.message");
    private static final String INVALID_OPERATION_INPUTNAME_MESSAGE = WebServiceEditObject.getString("invalidOperationInputMesgName.message");
    private static final String OPERATION_INPUT_AND_OUTPUT_SAMENAME_MESSAGE = WebServiceEditObject.getString("operationInputOutputSameName.message");
    private static final String SELECT_MODEL_MESSAGE = WebServiceEditObject.getString("selectModel.message");
    private static final String SELECT_INTERFACE_MESSAGE = WebServiceEditObject.getString("selectInterface.message");
    private static final String ENTER_OPERATION_MESSAGE = WebServiceEditObject.getString("enterOperation.message");
    private static final String ENTER_OPERATION_INPUTNAME_MESSAGE = WebServiceEditObject.getString("enterOperationInputName.message");
    private static final String ENTER_OPERATION_INPUTELEMENT_MESSAGE = WebServiceEditObject.getString("enterOperationInputElement.message");
    private static final String ENTER_OPERATION_OUTPUTNAME_MESSAGE = WebServiceEditObject.getString("enterOperationOutputName.message");
    private static final String CLICK_FINISH_MESSAGE = WebServiceEditObject.getString("clickFinish.message");
    private ModelResource currentModel;
    private ModelProject currentProject;
    private Interface currentInterface;
    private String currentOperationName;
    private String currentOperationInputMessageName = "";
    private XSDElementDeclaration currentOperationInputMessageElem;
    private String currentOperationOutputMessageName = "";
    private XSDElementDeclaration currentOperationOutputMessageElem;
    private XmlDocument currentXmlDoc;
    private String editedModelName;
    private String editedInterfaceName;
    private String defaultModelName;
    private String defaultInterfaceName;
    private String defaultOperationName;
    private String defaultOperationInputMessageName = "";
    private String defaultOperationOutputMessageName = "";
    private XSDElementDeclaration defaultOperationOutputMessageElem;
    private HashMap currentProjectModelsMap = new HashMap();
    private List currentModelInterfacesList = new ArrayList();
    private List currentInterfaceOperationsList = new ArrayList();
    private StringNameValidator nameValidator = new StringNameValidator();
    private IContainer locationContainer;
    private boolean useLocationContainer = false;

    public WebServiceEditObject() {
    }

    public WebServiceEditObject(ModelResource model) {
        this.currentModel = model;
        this.setCurrentProject(this.currentModel);
    }

    public WebServiceEditObject(ModelProject modelProject) {
        this.currentProject = modelProject;
        if (this.currentProject != null) {
            this.currentProjectModelsMap.clear();
            List wsModels = this.getWebServiceModelsForProject(this.currentProject);
            for (ModelResource mr : wsModels) {
                String modelName = ModelerCore.getModelEditor().getModelName(mr);
                this.currentProjectModelsMap.put(modelName, mr);
            }
        } else {
            this.currentProjectModelsMap.clear();
        }
        this.setCurrentWebServiceModel(null);
    }

    public void setCurrentWebServiceModel(Object model) {
        if (model instanceof ModelResource) {
            this.currentModel = (ModelResource)model;
            this.editedModelName = null;
            this.setCurrentProject(this.currentModel);
            this.updateCurrentInterfaceList();
            this.setCurrentInterfaceName(this.editedInterfaceName);
        } else if (model instanceof String) {
            if (this.modelExistsInCurrentProject((String)model)) {
                ModelResource mr;
                this.currentModel = mr = (ModelResource)this.currentProjectModelsMap.get(model);
                this.editedModelName = null;
                this.setCurrentProject(this.currentModel);
                this.updateCurrentInterfaceList();
                this.setCurrentInterfaceName(this.editedInterfaceName);
            } else {
                this.currentModel = null;
                this.editedModelName = (String)model;
                this.currentInterface = null;
                this.currentModelInterfacesList.clear();
                this.currentInterfaceOperationsList.clear();
            }
        } else if (model == null) {
            this.currentInterface = null;
            this.currentModel = null;
            this.editedModelName = null;
            this.editedInterfaceName = null;
            this.currentModelInterfacesList.clear();
            this.currentInterfaceOperationsList.clear();
        }
    }

    private void setCurrentInterface(Object theInterface) {
        if (theInterface instanceof Interface) {
            ModelResource newModel = null;
            try {
                newModel = ModelUtil.getModel((Object)theInterface);
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
            this.currentModel = newModel;
            this.editedModelName = null;
            this.setCurrentProject(this.currentModel);
            this.updateCurrentInterfaceList();
            this.currentInterface = (Interface)theInterface;
            this.editedInterfaceName = null;
            this.updateCurrentOperationList();
        } else if (theInterface instanceof String) {
            this.currentInterface = null;
            this.editedInterfaceName = (String)theInterface;
            this.currentInterfaceOperationsList.clear();
        } else if (theInterface == null) {
            this.currentInterface = null;
            this.editedInterfaceName = null;
            this.currentInterfaceOperationsList.clear();
        }
    }

    public void setCurrentInterfaceName(String interfaceName) {
        if (interfaceName != null && interfaceName.trim().length() > 0) {
            if (this.currentModel != null || this.editedModelName != null && this.editedModelName.length() > 0) {
                boolean matchFound = false;
                for (Interface interf : this.currentModelInterfacesList) {
                    if (!interf.getName().equalsIgnoreCase(interfaceName)) continue;
                    matchFound = true;
                    this.setCurrentInterface(interf);
                    break;
                }
                if (!matchFound) {
                    this.setCurrentInterface(interfaceName);
                }
            }
        } else {
            this.setCurrentInterface(null);
        }
    }

    public void setCurrent(Object object) {
        if (object instanceof ModelResource) {
            this.setCurrentWebServiceModel(object);
        } else if (object instanceof Interface) {
            this.setCurrentInterface(object);
        }
    }

    public void setCurrentOperationName(String operationName) {
        this.currentOperationName = operationName;
    }

    public void setOperationInputMessageName(String name) {
        this.currentOperationInputMessageName = name;
    }

    public void setOperationOutputMessageName(String name) {
        this.currentOperationOutputMessageName = name;
    }

    public void setOperationInputMessageElem(XSDElementDeclaration elem) {
        this.currentOperationInputMessageElem = elem;
    }

    private void setCurrentProject(ModelResource model) {
        if (model != null) {
            ModelProject modelProject;
            this.currentProject = modelProject = model.getModelProject();
            if (this.currentProject != null) {
                this.currentProjectModelsMap.clear();
                List wsModels = this.getWebServiceModelsForProject(this.currentProject);
                for (ModelResource mr : wsModels) {
                    String modelName = ModelerCore.getModelEditor().getModelName(mr);
                    this.currentProjectModelsMap.put(modelName, mr);
                }
            } else {
                this.currentProjectModelsMap.clear();
            }
        } else {
            this.currentProject = null;
            this.currentProjectModelsMap.clear();
        }
    }

    private void updateCurrentInterfaceList() {
        if (this.currentModel != null) {
            try {
                this.currentModelInterfacesList = org.teiid.designer.metamodels.webservice.util.WebServiceUtil.findInterfaces((Object)this.currentModel.getEmfResource(), (int)2);
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                this.currentModelInterfacesList = Collections.EMPTY_LIST;
            }
        } else {
            this.currentModelInterfacesList = Collections.EMPTY_LIST;
        }
    }

    private void updateCurrentOperationList() {
        this.currentInterfaceOperationsList = this.currentInterface != null ? org.teiid.designer.metamodels.webservice.util.WebServiceUtil.findOperations((Object)this.currentInterface, (int)2) : Collections.EMPTY_LIST;
    }

    public ModelProject getCurrentProject() {
        return this.currentProject;
    }

    public String getCurrentWebServiceModelName() {
        if (this.currentModel != null) {
            String modelName = ModelerCore.getModelEditor().getModelName(this.currentModel);
            return modelName;
        }
        if (this.editedModelName != null && this.editedModelName.length() > 0) {
            return this.editedModelName;
        }
        return EMPTY_STRING;
    }

    public String getCurrentInterfaceName() {
        if (this.currentInterface != null) {
            return this.currentInterface.getName();
        }
        if (this.editedInterfaceName != null && this.editedInterfaceName.length() > 0) {
            return this.editedInterfaceName;
        }
        return EMPTY_STRING;
    }

    public String getDefaultInterfaceName() {
        if (this.defaultInterfaceName != null) {
            return this.defaultInterfaceName;
        }
        return EMPTY_STRING;
    }

    public String getCurrentOperationName() {
        return this.currentOperationName;
    }

    public boolean hasModelNameEdits() {
        return this.editedModelName != null && this.editedModelName.length() > 0;
    }

    public boolean hasInterfaceNameEdits() {
        return this.editedInterfaceName != null && this.editedInterfaceName.length() > 0;
    }

    private List getWebServiceModelsForProject(ModelProject project) {
        ArrayList<ModelResource> allWebServiceModels = new ArrayList<ModelResource>();
        ModelWorkspaceItem[] workspaceItems = null;
        try {
            workspaceItems = project.getChildren();
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        if (workspaceItems != null) {
            int i = 0;
            while (i < workspaceItems.length) {
                IResource resource = null;
                try {
                    resource = workspaceItems[i].getCorrespondingResource();
                }
                catch (ModelWorkspaceException modelWorkspaceException) {}
                ModelResource mr = null;
                if (resource instanceof IFile) {
                    try {
                        mr = ModelerCore.getModelEditor().findModelResource((IResource)((IFile)resource));
                    }
                    catch (ModelWorkspaceException e) {
                        e.printStackTrace();
                    }
                    if (mr != null && WebServiceUtil.isWebServiceModelResource(mr)) {
                        allWebServiceModels.add(mr);
                    }
                }
                ++i;
            }
        }
        return allWebServiceModels;
    }

    public Collection getModelNamesForCurrentProject() {
        return this.currentProjectModelsMap.keySet();
    }

    public String[] getInterfaceNamesForCurrentModel() {
        if (this.currentModelInterfacesList != null && !this.currentModelInterfacesList.isEmpty()) {
            String[] interfaceNames = new String[this.currentModelInterfacesList.size()];
            int index = 0;
            Iterator iter = this.currentModelInterfacesList.iterator();
            while (iter.hasNext()) {
                String interfaceName;
                interfaceNames[index] = interfaceName = ((Interface)iter.next()).getName();
                ++index;
            }
            return interfaceNames;
        }
        return new String[0];
    }

    public String[] getInterfaceNamesForCurrentModelIncludeDefault() {
        if (this.currentModelInterfacesList != null && !this.currentModelInterfacesList.isEmpty()) {
            int arrayLength = this.currentModelInterfacesList.size();
            if (this.defaultInterfaceName != null && this.defaultInterfaceName.length() > 0) {
                ++arrayLength;
            }
            String[] interfaceNames = new String[arrayLength];
            int index = 0;
            Iterator iter = this.currentModelInterfacesList.iterator();
            while (iter.hasNext()) {
                String interfaceName;
                interfaceNames[index] = interfaceName = ((Interface)iter.next()).getName();
                ++index;
            }
            if (this.defaultInterfaceName != null && this.defaultInterfaceName.length() > 0) {
                interfaceNames[index] = this.defaultInterfaceName;
            }
            return interfaceNames;
        }
        return new String[0];
    }

    public String[] getOperationNamesForCurrentInterface() {
        if (this.currentInterfaceOperationsList != null && !this.currentInterfaceOperationsList.isEmpty()) {
            String[] operationNames = new String[this.currentInterfaceOperationsList.size()];
            int index = 0;
            Iterator iter = this.currentInterfaceOperationsList.iterator();
            while (iter.hasNext()) {
                String operationName;
                operationNames[index] = operationName = ((Operation)iter.next()).getName();
                ++index;
            }
            return operationNames;
        }
        return new String[0];
    }

    public boolean canCreateWebServiceModel(String modelName) {
        Collection modelNames;
        return modelName != null && modelName.trim().length() > 0 && this.currentProject != null && (modelNames = this.getModelNamesForCurrentProject()) != null && !this.containsName(modelName, modelNames);
    }

    public boolean canCreateInterface(String interfaceName) {
        String[] interfaceNames;
        return interfaceName != null && interfaceName.trim().length() > 0 && this.currentModel != null && (interfaceNames = this.getInterfaceNamesForCurrentModel()) != null && !this.containsName(interfaceName, Arrays.asList(interfaceNames));
    }

    public boolean canCreateOperation(String operationName) {
        String[] operationNames;
        return operationName != null && operationName.trim().length() > 0 && this.currentInterface != null && (operationNames = this.getOperationNamesForCurrentInterface()) != null && !this.containsName(operationName, Arrays.asList(operationNames));
    }

    private boolean containsName(String name, Collection nameList) {
        boolean containsName = false;
        for (String listName : nameList) {
            if (!listName.equalsIgnoreCase(name)) continue;
            containsName = true;
            break;
        }
        return containsName;
    }

    public boolean modelExistsInCurrentProject(String modelName) {
        Set currentModelNames;
        return modelName != null && modelName.trim().length() > 0 && this.containsName(modelName, currentModelNames = this.currentProjectModelsMap.keySet());
    }

    public boolean interfaceExistsInCurrentModel(String interfaceName) {
        String[] currentInterfaceNames;
        return interfaceName != null && interfaceName.trim().length() > 0 && this.currentModel != null && this.containsName(interfaceName, Arrays.asList(currentInterfaceNames = this.getInterfaceNamesForCurrentModel()));
    }

    public boolean operationExistsInCurrentInterface(String operationName) {
        String[] currentOperationNames;
        return operationName != null && operationName.trim().length() > 0 && this.currentInterface != null && this.containsName(operationName, Arrays.asList(currentOperationNames = this.getOperationNamesForCurrentInterface()));
    }

    public ModelResource getModelFromCurrentProject(String modelName) {
        return (ModelResource)this.currentProjectModelsMap.get(modelName);
    }

    public Object getInterfaceFromCurrentModel(String interfaceName) {
        Interface result = null;
        for (Interface interf : this.currentModelInterfacesList) {
            if (!interf.getName().equalsIgnoreCase(interfaceName)) continue;
            result = interf;
            break;
        }
        return result;
    }

    public Object getOperationFromCurrentInterface(String operationName) {
        Operation result = null;
        for (Operation operation : this.currentInterfaceOperationsList) {
            if (!operation.getName().equalsIgnoreCase(operationName)) continue;
            result = operation;
            break;
        }
        return result;
    }

    public void setDefaultsUsingXmlRoot(XmlRoot xmlRoot) {
        if (xmlRoot != null) {
            String modelName;
            String xmlRootName = xmlRoot.getName();
            EObject rootParent = xmlRoot.eContainer();
            if (rootParent != null && rootParent instanceof XmlDocument) {
                this.currentXmlDoc = (XmlDocument)rootParent;
            }
            XSDComponent xsdComp = xmlRoot.getXsdComponent();
            this.defaultModelName = modelName = String.valueOf(xmlRootName) + "_WS";
            this.setCurrentWebServiceModel(this.defaultModelName);
            this.defaultInterfaceName = xmlRootName;
            this.setCurrentInterfaceName(this.defaultInterfaceName);
            this.defaultOperationName = "get" + xmlRootName;
            this.setCurrentOperationName(this.defaultOperationName);
            String outputMessageName = xmlRootName;
            this.currentOperationInputMessageName = this.defaultOperationInputMessageName;
            this.currentOperationOutputMessageName = this.defaultOperationOutputMessageName = outputMessageName;
            if (xsdComp != null && xsdComp instanceof XSDElementDeclaration) {
                this.currentOperationOutputMessageElem = this.defaultOperationOutputMessageElem = (XSDElementDeclaration)xsdComp;
            }
        }
    }

    public WebServiceBuildOptions getWebServiceBuildOptions() {
        WebServiceBuildOptions buildOptions = new WebServiceBuildOptions();
        buildOptions.setCurrentProject(this.currentProject);
        if (this.currentModel != null) {
            buildOptions.setModel(this.currentModel);
        } else {
            buildOptions.setModel(this.editedModelName);
        }
        if (this.currentInterface != null) {
            buildOptions.setInterface(this.currentInterface);
        } else {
            buildOptions.setInterface(this.editedInterfaceName);
        }
        buildOptions.setOperationName(this.currentOperationName);
        buildOptions.setOperationInputMessageName(this.currentOperationInputMessageName);
        buildOptions.setOperationInputMessageElem(this.currentOperationInputMessageElem);
        buildOptions.setOperationOutputMessageName(this.currentOperationOutputMessageName);
        buildOptions.setOperationOutputMessageElem(this.currentOperationOutputMessageElem);
        buildOptions.setOperationOutputXmlDoc(this.currentXmlDoc);
        buildOptions.setUseLocationContainer(this.useLocationContainer);
        buildOptions.setLocationContainer(this.locationContainer);
        return buildOptions;
    }

    public String getCurrentOperationInputName() {
        return this.currentOperationInputMessageName;
    }

    public XSDElementDeclaration getCurrentOperationInputElem() {
        return this.currentOperationInputMessageElem;
    }

    public String getCurrentOperationOutputName() {
        return this.currentOperationOutputMessageName;
    }

    public XSDElementDeclaration getCurrentOperationOutputElem() {
        return this.currentOperationOutputMessageElem;
    }

    public IStatus validate() {
        IStatus modelStatus = this.validateModelSelection();
        if (modelStatus.getSeverity() == 4) {
            return modelStatus;
        }
        IStatus interfaceStatus = this.validateInterfaceSelection();
        if (interfaceStatus.getSeverity() == 4) {
            return interfaceStatus;
        }
        IStatus operationStatus = this.validateOperationSelection();
        if (operationStatus.getSeverity() == 4) {
            return operationStatus;
        }
        IStatus operationInputMessageElemStatus = this.validateOperationInputMessageElem();
        if (operationInputMessageElemStatus.getSeverity() == 4) {
            return operationInputMessageElemStatus;
        }
        IStatus operationInputMessageNameStatus = this.validateOperationInputMessageName();
        if (operationInputMessageNameStatus.getSeverity() == 4) {
            return operationInputMessageNameStatus;
        }
        IStatus operationOutputMessageNameStatus = this.validateOperationOutputMessageName();
        if (operationOutputMessageNameStatus.getSeverity() == 4) {
            return operationOutputMessageNameStatus;
        }
        IStatus overallStatus = this.validateOverallStatus();
        if (overallStatus.getSeverity() == 4) {
            return overallStatus;
        }
        return new Status(0, "org.teiid.designer.webservice", 0, CLICK_FINISH_MESSAGE, null);
    }

    public IStatus validateModelSelection() {
        if (this.editedModelName != null && this.editedModelName.length() > 0) {
            boolean isValidName = this.nameValidator.isValidName(this.editedModelName);
            if (!isValidName) {
                String message = INVALID_MODELNAME_MESSAGE;
                return new Status(4, "org.teiid.designer.webservice", 0, message, null);
            }
            return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
        }
        if (this.currentModel == null) {
            String message = SELECT_MODEL_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public IStatus validateInterfaceSelection() {
        if (this.editedInterfaceName != null && this.editedInterfaceName.length() > 0) {
            boolean isValidName = this.nameValidator.isValidName(this.editedInterfaceName);
            if (!isValidName) {
                String message = INVALID_INTERFACENAME_MESSAGE;
                return new Status(4, "org.teiid.designer.webservice", 0, message, null);
            }
            return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
        }
        if (this.currentInterface == null) {
            String message = SELECT_INTERFACE_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public IStatus validateOperationSelection() {
        if (this.currentOperationName == null || this.currentOperationName.length() == 0) {
            String message = ENTER_OPERATION_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        if (this.currentOperationName.length() > 0) {
            String[] operationNames;
            boolean isValidName = this.nameValidator.isValidName(this.currentOperationName);
            if (!isValidName) {
                String message = INVALID_OPERATIONNAME_MESSAGE;
                return new Status(4, "org.teiid.designer.webservice", 0, message, null);
            }
            if (this.currentInterface != null && (operationNames = this.getOperationNamesForCurrentInterface()) != null && this.containsName(this.currentOperationName, Arrays.asList(operationNames))) {
                String message = OPERATIONNAME_ALREADY_EXISTS_MESSAGE;
                return new Status(4, "org.teiid.designer.webservice", 0, message, null);
            }
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public IStatus validateOperationInputMessageElem() {
        if (this.currentOperationInputMessageElem == null) {
            String message = ENTER_OPERATION_INPUTELEMENT_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public IStatus validateOperationInputMessageName() {
        boolean isValidName;
        if (this.currentOperationInputMessageName == null || this.currentOperationInputMessageName.length() == 0) {
            String message = ENTER_OPERATION_INPUTNAME_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        if (this.currentOperationInputMessageName.length() > 0 && !(isValidName = this.nameValidator.isValidName(this.currentOperationInputMessageName))) {
            String message = INVALID_OPERATION_INPUTNAME_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public IStatus validateOperationOutputMessageName() {
        boolean isValidName;
        if (this.currentOperationOutputMessageName == null || this.currentOperationOutputMessageName.length() == 0) {
            String message = ENTER_OPERATION_OUTPUTNAME_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        if (this.currentOperationOutputMessageName.length() > 0 && !(isValidName = this.nameValidator.isValidName(this.currentOperationOutputMessageName))) {
            String message = INVALID_OPERATION_OUTPUTNAME_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public IStatus validateOverallStatus() {
        String inputMessageName = this.currentOperationInputMessageName;
        String outputMessageName = this.currentOperationOutputMessageName;
        if (inputMessageName != null && inputMessageName.equalsIgnoreCase(outputMessageName)) {
            String message = OPERATION_INPUT_AND_OUTPUT_SAMENAME_MESSAGE;
            return new Status(4, "org.teiid.designer.webservice", 0, message, null);
        }
        return new Status(0, "org.teiid.designer.webservice", 0, EMPTY_STRING, null);
    }

    public boolean isXmlDocument(Object object) {
        return object instanceof XmlDocument;
    }

    public boolean isXmlRoot(Object object) {
        return object instanceof XmlRoot;
    }

    private static String getString(String theKey) {
        return WebServicePlugin.Util.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    public IContainer getLocationContainer() {
        return this.locationContainer;
    }

    public void setLocationContainer(IContainer theLocationContainer) {
        this.locationContainer = theLocationContainer;
    }

    public boolean shouldLocationContainer() {
        return this.useLocationContainer;
    }

    public void setUseLocationContainer(boolean theUseLocationContainer) {
        this.useLocationContainer = theUseLocationContainer;
    }
}

