/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.procedure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;

public class XsdInstanceNode {
    private static XSDComplexTypeDefinition anyType;
    private XSDConcreteComponent xsdComponent;
    private XsdInstanceNode[] children;
    private XsdInstanceNode parent;
    private boolean selectable;
    private boolean selected;
    private boolean recursive;
    private boolean hasSelectableChildren;

    public XsdInstanceNode(XSDElementDeclaration element) {
        this((XSDConcreteComponent)element, null);
    }

    public XsdInstanceNode(XSDConcreteComponent component, XsdInstanceNode parent) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (!(component instanceof XSDElementDeclaration) && parent == null) {
            throw new IllegalArgumentException();
        }
        this.xsdComponent = component;
        this.parent = parent;
        if (component instanceof XSDParticle) {
            component = ((XSDParticle)component).getTerm();
        }
        if (component instanceof XSDElementDeclaration) {
            XSDTypeDefinition type;
            XSDElementDeclaration elem = (XSDElementDeclaration)component;
            if (elem.isElementDeclarationReference()) {
                elem = elem.getResolvedElementDeclaration();
            }
            if ((type = elem.getType()) != null) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    this.selectable = true;
                } else {
                    XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
                    if (complexType.isMixed() || complexType.getContentTypeCategory() == XSDContentTypeCategory.SIMPLE_LITERAL) {
                        this.selectable = true;
                    }
                }
            }
        } else if (component instanceof XSDAttributeUse) {
            this.selectable = true;
        }
        while (parent != null) {
            XSDConcreteComponent ancestorComp = parent.xsdComponent;
            if (ancestorComp instanceof XSDParticle) {
                ancestorComp = ((XSDParticle)ancestorComp).getTerm();
            }
            if (component == ancestorComp) {
                this.recursive = true;
                parent.recursive = true;
            }
            if (this.selectable) {
                parent.hasSelectableChildren = true;
            }
            parent = parent.parent;
        }
        if (anyType == null) {
            anyType = this.xsdComponent.getSchema().getSchemaForSchema().resolveComplexTypeDefinition("anyType");
        }
    }

    private void addAttributes(List contents, List children) {
        for (XSDAttributeGroupContent content : contents) {
            if (content instanceof XSDAttributeUse) {
                if (((XSDAttributeUse)content).getUse() == XSDAttributeUseCategory.PROHIBITED_LITERAL) continue;
                children.add(new XsdInstanceNode((XSDConcreteComponent)content, this));
                continue;
            }
            XSDAttributeGroupDefinition group = (XSDAttributeGroupDefinition)content;
            if (group.isAttributeGroupDefinitionReference()) {
                group = group.getResolvedAttributeGroupDefinition();
            }
            this.addAttributes((List)group.getContents(), children);
        }
    }

    private void addElementChildren(XSDElementDeclaration element, List children) {
        XSDTypeDefinition type;
        if (element.isElementDeclarationReference()) {
            element = element.getResolvedElementDeclaration();
        }
        if ((type = element.getType()) instanceof XSDComplexTypeDefinition && type != anyType) {
            this.addTypeAttributes((XSDComplexTypeDefinition)type, children);
            XSDParticle particle = type.getComplexType();
            if (particle != null) {
                this.addSequentialModelGroupChildren(particle, (XSDModelGroup)particle.getContent(), children);
            }
        }
    }

    private void addModelGroupChildren(XSDModelGroup modelGroup, List children) {
        for (XSDParticle particle : modelGroup.getParticles()) {
            XSDParticleContent content = particle.getContent();
            if (content instanceof XSDModelGroup) {
                this.addSequentialModelGroupChildren(particle, (XSDModelGroup)content, children);
                continue;
            }
            if (content instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition group = (XSDModelGroupDefinition)content;
                if (group.isModelGroupDefinitionReference()) {
                    group = group.getResolvedModelGroupDefinition();
                }
                this.addSequentialModelGroupChildren(particle, group.getModelGroup(), children);
                continue;
            }
            if (content instanceof XSDElementDeclaration) {
                if (particle.getMaxOccurs() == 0) continue;
                children.add(new XsdInstanceNode((XSDConcreteComponent)particle, this));
                continue;
            }
            throw new RuntimeException("Unexpected content: " + content.getClass());
        }
    }

    private void addSequentialModelGroupChildren(XSDParticle particle, XSDModelGroup modelGroup, List children) {
        if (modelGroup.getCompositor() == XSDCompositor.CHOICE_LITERAL) {
            children.add(new XsdInstanceNode((XSDConcreteComponent)particle, this));
        } else {
            this.addModelGroupChildren(modelGroup, children);
        }
    }

    private void addTypeAttributes(XSDComplexTypeDefinition type, List children) {
        XSDTypeDefinition baseType = type.getBaseType();
        if (baseType instanceof XSDComplexTypeDefinition && baseType != anyType) {
            this.addTypeAttributes((XSDComplexTypeDefinition)baseType, children);
        }
        this.addAttributes((List)type.getAttributeContents(), children);
    }

    public XsdInstanceNode findRecursionRoot() {
        XSDConcreteComponent comp = this.xsdComponent;
        if (comp instanceof XSDParticle) {
            comp = ((XSDParticle)comp).getTerm();
        }
        XsdInstanceNode ancestor = this.parent;
        while (ancestor != null) {
            if (ancestor.recursive) {
                XSDConcreteComponent ancestorComp = ancestor.xsdComponent;
                if (ancestorComp instanceof XSDParticle) {
                    ancestorComp = ((XSDParticle)ancestorComp).getTerm();
                }
                if (ancestorComp == comp) {
                    return ancestor;
                }
            }
            ancestor = ancestor.parent;
        }
        return null;
    }

    public XsdInstanceNode[] getChildren() {
        if (this.children == null) {
            ArrayList children = new ArrayList();
            if (!this.recursive) {
                if (this.xsdComponent instanceof XSDElementDeclaration) {
                    this.addElementChildren((XSDElementDeclaration)this.xsdComponent, children);
                } else if (!(this.xsdComponent instanceof XSDAttributeGroupContent)) {
                    if (this.xsdComponent instanceof XSDParticle) {
                        XSDParticleContent content = ((XSDParticle)this.xsdComponent).getContent();
                        if (content instanceof XSDElementDeclaration) {
                            this.addElementChildren((XSDElementDeclaration)content, children);
                        } else if (content instanceof XSDModelGroupDefinition) {
                            XSDModelGroupDefinition group = (XSDModelGroupDefinition)content;
                            if (group.isModelGroupDefinitionReference()) {
                                group = group.getResolvedModelGroupDefinition();
                            }
                            this.addModelGroupChildren(group.getModelGroup(), children);
                        } else if (content instanceof XSDModelGroup) {
                            this.addModelGroupChildren((XSDModelGroup)content, children);
                        }
                    } else {
                        throw new RuntimeException("Unexpected component: " + this.xsdComponent.getClass());
                    }
                }
            }
            this.children = new XsdInstanceNode[children.size()];
            children.toArray(this.children);
        }
        return this.children;
    }

    public String getName() {
        XSDConcreteComponent comp = this.getResolvedXsdComponent();
        if (comp instanceof XSDNamedComponent) {
            return ((XSDNamedComponent)comp).getName();
        }
        return ((XSDModelGroup)comp).getCompositor().getName();
    }

    public XsdInstanceNode getParent() {
        return this.parent;
    }

    public XSDConcreteComponent getResolvedXsdComponent() {
        if (this.xsdComponent instanceof XSDElementDeclaration) {
            return this.xsdComponent;
        }
        if (this.xsdComponent instanceof XSDAttributeUse) {
            XSDAttributeDeclaration attr = ((XSDAttributeUse)this.xsdComponent).getAttributeDeclaration();
            if (attr.isAttributeDeclarationReference()) {
                return attr.getResolvedAttributeDeclaration();
            }
            return attr;
        }
        XSDTerm term = ((XSDParticle)this.xsdComponent).getTerm();
        if (term instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)term;
            if (group.isModelGroupDefinitionReference()) {
                group = group.getResolvedModelGroupDefinition();
            }
            return group.getModelGroup();
        }
        if (term instanceof XSDModelGroup) {
            return term;
        }
        XSDElementDeclaration elem = (XSDElementDeclaration)term;
        if (elem.isElementDeclarationReference()) {
            return elem.getResolvedElementDeclaration();
        }
        return elem;
    }

    public String getTargetNamespace() {
        return this.xsdComponent.getSchema().getTargetNamespace();
    }

    public XSDConcreteComponent getXsdComponent() {
        return this.xsdComponent;
    }

    public boolean hasSelectableChildren() {
        return this.hasSelectableChildren;
    }

    public boolean isLocallyDefined() {
        if (this.xsdComponent instanceof XSDElementDeclaration) {
            return false;
        }
        if (this.xsdComponent instanceof XSDAttributeUse) {
            return !((XSDAttributeUse)this.xsdComponent).getAttributeDeclaration().isAttributeDeclarationReference();
        }
        XSDTerm term = ((XSDParticle)this.xsdComponent).getTerm();
        if (term instanceof XSDModelGroupDefinition) {
            return !((XSDModelGroupDefinition)term).isModelGroupDefinitionReference();
        }
        if (term instanceof XSDModelGroup) {
            return true;
        }
        return !((XSDElementDeclaration)term).isElementDeclarationReference();
    }

    public boolean isNamespaceQualifiedInDocument() {
        if (this.isLocallyDefined()) {
            XSDConcreteComponent comp = this.getResolvedXsdComponent();
            if (comp instanceof XSDFeature) {
                XSDFeature feature = (XSDFeature)comp;
                if (feature.isSetForm()) {
                    return feature.getForm() == XSDForm.QUALIFIED_LITERAL;
                }
                XSDSchema schema = feature.getSchema();
                if (feature instanceof XSDAttributeDeclaration) {
                    if (schema.isSetAttributeFormDefault()) {
                        return schema.getAttributeFormDefault() == XSDForm.QUALIFIED_LITERAL;
                    }
                } else if (schema.isSetElementFormDefault()) {
                    return schema.getElementFormDefault() == XSDForm.QUALIFIED_LITERAL;
                }
            }
            return false;
        }
        return true;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.xsdComponent.toString());
        text.append('#');
        text.append(this.getResolvedXsdComponent());
        return text.toString();
    }
}

