/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.gen;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.WebServiceComponent;
import org.teiid.designer.metamodels.webservice.WebServicePackage;
import org.teiid.designer.metamodels.webservice.impl.OperationImpl;
import org.teiid.designer.metamodels.wsdl.Binding;
import org.teiid.designer.metamodels.wsdl.BindingInput;
import org.teiid.designer.metamodels.wsdl.BindingOperation;
import org.teiid.designer.metamodels.wsdl.BindingOutput;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.metamodels.wsdl.Documentation;
import org.teiid.designer.metamodels.wsdl.Documented;
import org.teiid.designer.metamodels.wsdl.Import;
import org.teiid.designer.metamodels.wsdl.Input;
import org.teiid.designer.metamodels.wsdl.Message;
import org.teiid.designer.metamodels.wsdl.MessagePart;
import org.teiid.designer.metamodels.wsdl.NamespaceDeclaration;
import org.teiid.designer.metamodels.wsdl.NamespaceDeclarationOwner;
import org.teiid.designer.metamodels.wsdl.Output;
import org.teiid.designer.metamodels.wsdl.Port;
import org.teiid.designer.metamodels.wsdl.PortType;
import org.teiid.designer.metamodels.wsdl.Service;
import org.teiid.designer.metamodels.wsdl.Types;
import org.teiid.designer.metamodels.wsdl.WsdlFactory;
import org.teiid.designer.metamodels.wsdl.WsdlNameRequiredEntity;
import org.teiid.designer.metamodels.wsdl.io.WsdlResourceFactoryImpl;
import org.teiid.designer.metamodels.wsdl.soap.SoapAddress;
import org.teiid.designer.metamodels.wsdl.soap.SoapBinding;
import org.teiid.designer.metamodels.wsdl.soap.SoapBody;
import org.teiid.designer.metamodels.wsdl.soap.SoapFactory;
import org.teiid.designer.metamodels.wsdl.soap.SoapOperation;
import org.teiid.designer.metamodels.wsdl.soap.SoapStyleType;
import org.teiid.designer.metamodels.wsdl.soap.SoapUseType;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.webservice.IWsdlGenerator;
import org.teiid.designer.webservice.WebServicePlugin;

public class BasicWsdlGenerator
implements IWsdlGenerator {
    private static final String XML_LITERAL_TYPE_URI_STRING = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance").appendFragment("XMLLiteral").toString();
    public static final String XSD_SCHEMA_FOR_SCHEMA_TARGET_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_SCHEMA_FOR_SCHEMA_PREFIX = "xsd";
    private Map operationToProcedureMap;
    private final List ports;
    private final List webServiceModels;
    private final List xmlSchemas;
    private final List webServiceModelsUnmodifiable;
    private final List xmlSchemasUnmodifiable;
    private final Resource wsdlResource;
    private final Resource.Factory wsdlResourceFactory;
    private final URI wsdlResourceUri;
    private final int wsdlVersion = 1;
    private final Map xmlSchemasToLocationPath;
    private String name;
    private String targetNamespace;
    private String urlRootForReferences;
    private String urlSuffixForReferences;
    private String urlForService;
    private String defaultNamespaceUri;
    private String xmlEncoding = "UTF-8";
    public static final int WSDL_VERSION_1_1 = 1;
    public static final int WSDL_VERSION_2_0 = 2;
    public static final int WSDL_VERSION_DEFAULT = 1;
    public static final int ERROR_NO_WEB_SERVICES = 21301;
    public static final int MULTIPLE_MESSAGES = 21302;
    public static final int ERROR_NO_WEB_SERVICE_OBJECTS = 21303;
    public static final int INVALID_URL = 21304;
    public static final String DEFAULT_URI = "GeneratedWsdl.wsdl";

    public BasicWsdlGenerator() {
        this(URI.createURI((String)DEFAULT_URI));
    }

    public BasicWsdlGenerator(URI uri) {
        CoreArgCheck.isNotNull((Object)uri);
        this.operationToProcedureMap = new HashMap();
        this.webServiceModels = new ArrayList();
        this.ports = new ArrayList();
        this.xmlSchemas = new ArrayList();
        this.xmlSchemasToLocationPath = new HashMap();
        this.webServiceModelsUnmodifiable = Collections.unmodifiableList(this.webServiceModels);
        this.xmlSchemasUnmodifiable = Collections.unmodifiableList(this.xmlSchemas);
        this.wsdlResourceUri = uri;
        this.wsdlResourceFactory = new WsdlResourceFactoryImpl();
        this.wsdlResource = this.wsdlResourceFactory.createResource(this.wsdlResourceUri);
        this.defaultNamespaceUri = "http://schemas.xmlsoap.org/wsdl/";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTargetNamespace(String targetNamspace) {
        this.targetNamespace = targetNamspace;
    }

    @Override
    public String getUrlRootForReferences() {
        return this.urlRootForReferences;
    }

    @Override
    public void setUrlRootForReferences(String url) {
        this.urlRootForReferences = url;
    }

    @Override
    public String getUrlSuffixForReferences() {
        return this.urlSuffixForReferences;
    }

    @Override
    public void setUrlSuffixForReferences(String suffix) {
        this.urlSuffixForReferences = suffix;
    }

    @Override
    public String getUrlForWsdlService() {
        return this.urlForService;
    }

    @Override
    public void setUrlForWsdlService(String serviceUrl) {
        this.urlForService = serviceUrl;
    }

    @Override
    public String getDefaultNamespaceUri() {
        return this.defaultNamespaceUri;
    }

    @Override
    public void setDefaultNamespaceUri(String namespaceUri) {
        this.defaultNamespaceUri = namespaceUri;
    }

    public List getPorts() {
        return this.ports;
    }

    public Map getOperationToProcedureMap() {
        return this.operationToProcedureMap;
    }

    @Override
    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public void setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding == null || xmlEncoding.trim().length() == 0 ? "UTF-8" : xmlEncoding;
    }

    @Override
    public boolean addWebServiceModel(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        if (this.webServiceModels.contains(resource)) {
            return false;
        }
        boolean valid = this.isValidWebServiceModel(resource);
        if (valid) {
            this.webServiceModels.add(resource);
        }
        return valid;
    }

    @Override
    public boolean addXsdModel(XSDSchema xmlSchema, IPath pathForLocation) {
        CoreArgCheck.isNotNull((Object)xmlSchema);
        if (this.xmlSchemas.contains(xmlSchema)) {
            return false;
        }
        this.xmlSchemas.add(xmlSchema);
        this.xmlSchemasToLocationPath.put(xmlSchema, pathForLocation);
        return true;
    }

    public IPath getLocationPathForXsdModel(XSDSchema xmlSchema) {
        return (IPath)this.xmlSchemasToLocationPath.get(xmlSchema);
    }

    @Override
    public List getWebServiceModels() {
        return this.webServiceModelsUnmodifiable;
    }

    @Override
    public List getXSDSchemas() {
        return this.xmlSchemasUnmodifiable;
    }

    @Override
    public IStatus generate(IProgressMonitor monitor) {
        if (this.webServiceModels.isEmpty()) {
            String msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.NoWebServiceModelsSupplied", new Object[0]);
            return new Status(4, "org.teiid.designer.webservice", 21301, msg, null);
        }
        this.wsdlResource.getContents().clear();
        ArrayList problems = new ArrayList();
        this.doGenerate(monitor, this.wsdlResource, problems);
        IStatus result = null;
        if (problems.size() == 0) {
            String msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.NoErrorsOrWarningsWhileGenerating", new Object[0]);
            result = new Status(0, "org.teiid.designer.webservice", 0, msg, null);
        } else if (problems.size() == 1) {
            result = (IStatus)problems.get(0);
        } else {
            int errors = 0;
            int warnings = 0;
            for (IStatus problem : problems) {
                if (problem.getSeverity() == 4) {
                    ++errors;
                }
                if (problem.getSeverity() != 2) continue;
                ++warnings;
            }
            String msg = null;
            if (errors != 0 || warnings != 0) {
                Object[] params = new Object[]{new Integer(errors), new Integer(warnings)};
                msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.ErrorsAndWarningsWhileGenerating", params);
            } else {
                msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.NoErrorsOrWarningsWhileGenerating", new Object[0]);
            }
            IStatus[] children = problems.toArray(new IStatus[problems.size()]);
            MultiStatus multi = new MultiStatus("org.teiid.designer.webservice", 21302, children, msg, null);
            result = multi;
        }
        return result;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        if (this.wsdlResource != null && this.wsdlResource.getContents().size() != 0) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", this.xmlEncoding);
            this.wsdlResource.save(stream, options);
        }
    }

    @Override
    public void close() {
        this.webServiceModels.clear();
        this.xmlSchemas.clear();
    }

    protected IStatus doCheckValidUri(String location) {
        try {
            new java.net.URI(location);
        }
        catch (URISyntaxException err) {
            Status problem = new Status(4, "org.teiid.designer.webservice", 21304, err.getLocalizedMessage(), null);
            return problem;
        }
        return null;
    }

    protected boolean isValidWebServiceModel(Resource resource) {
        for (EObject root : resource.getContents()) {
            EPackage epackage;
            EClass eclass = root.eClass();
            if (eclass == null || !WebServicePackage.eINSTANCE.equals(epackage = eclass.getEPackage())) continue;
            return true;
        }
        return false;
    }

    protected void doGenerate(IProgressMonitor monitor, Resource wsdlResource, List problems) {
        ArrayList<EObject> rootWsObjects = new ArrayList<EObject>();
        for (Resource webServiceModel : this.webServiceModels) {
            EList roots = webServiceModel.getContents();
            for (EObject root : roots) {
                EPackage epackage;
                EClass eclass = root.eClass();
                if (eclass == null || !WebServicePackage.eINSTANCE.equals(epackage = eclass.getEPackage())) continue;
                rootWsObjects.add(root);
            }
        }
        if (rootWsObjects.isEmpty()) {
            Object[] params = new Object[]{new Integer(this.webServiceModels.size())};
            String msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.NoWebServiceObjectsFound", params);
            problems.add(new Status(4, "org.teiid.designer.webservice", 21303, msg, null));
        } else {
            Wsdl11Generator visitor = null;
            String urlRoot = this.getUrlRootForReferences();
            String urlSuffix = this.getUrlSuffixForReferences();
            String urlService = this.getUrlForWsdlService();
            String defNsUri = this.getDefaultNamespaceUri();
            switch (1) {
                case 2: {
                    visitor = new Wsdl20Generator(wsdlResource, this.getName(), this.getTargetNamespace(), defNsUri, urlRoot, urlSuffix, urlService, problems);
                    break;
                }
                default: {
                    visitor = new Wsdl11Generator(wsdlResource, this.getName(), this.getTargetNamespace(), defNsUri, urlRoot, urlSuffix, urlService, problems);
                }
            }
            visitor.doGenerateStandardNamespaceDeclarations();
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
            try {
                processor.walk(rootWsObjects, 2);
            }
            catch (ModelerCoreException modelerCoreException) {}
            visitor.doGenerateTargetNamespaceNamespaceDeclaration();
            this.operationToProcedureMap = visitor.operationToProcedureMap;
            visitor.complete();
        }
    }

    protected class Wsdl11Generator
    implements ModelVisitor {
        private final List problems;
        protected final Resource resource;
        protected final ModelContents contents;
        private final WsdlFactory factory;
        private final SoapFactory soapFactory;
        private final XSDFactory xsdFactory;
        final Map operationToProcedureMap;
        private Definitions definitions;
        private Service service;
        private PortType portType;
        private org.teiid.designer.metamodels.wsdl.Operation operation;
        private Binding binding;
        private BindingOperation bindingOp;
        private final Set referencedXsds;
        private final Map xsdPrefixByTargetNamespace;
        private int schemaIndex;
        private final String urlRoot;
        private final String urlSuffix;
        private final String urlService;
        private final Map messagePartNameByWebServiceMessage;
        private String wsdlTnsPrefix = "tns";
        private final String name;
        private final String targetNamespace;
        private final String defaultNamespace;
        private boolean xsdImportsAsWsdlImports = false;
        private final Set namespacePrefixes = new HashSet();

        protected Wsdl11Generator(Resource wsdlResource, String name, String targetNamespace, String defaultNamespace, String urlRoot, String urlSuffix, String urlService, List problems) {
            this.name = name;
            this.targetNamespace = targetNamespace;
            this.problems = problems;
            this.resource = wsdlResource;
            this.factory = WsdlFactory.eINSTANCE;
            this.soapFactory = SoapFactory.eINSTANCE;
            this.xsdFactory = XSDFactory.eINSTANCE;
            this.contents = new ModelContents(this.resource);
            this.referencedXsds = new HashSet();
            this.xsdPrefixByTargetNamespace = new HashMap();
            this.urlRoot = urlRoot;
            this.urlSuffix = urlSuffix;
            this.urlService = urlService;
            this.messagePartNameByWebServiceMessage = new HashMap();
            this.defaultNamespace = defaultNamespace;
            this.operationToProcedureMap = new HashMap();
        }

        public Definitions getDefinitions() {
            if (this.definitions == null) {
                this.definitions = this.factory.createDefinitions();
                this.definitions.setName(this.name);
                this.definitions.setTargetNamespace(this.targetNamespace);
                this.resource.getContents().add((Object)this.definitions);
                this.service = this.factory.createService();
                this.service.setName(this.name);
                this.service.setDefinitions(this.definitions);
            }
            return this.definitions;
        }

        protected void addError(int code, String msg, Throwable t) {
            this.problems.add(new Status(4, "org.teiid.designer.webservice", code, msg, t));
        }

        protected void addWarning(int code, String msg, Throwable t) {
            this.problems.add(new Status(2, "org.teiid.designer.webservice", code, msg, t));
        }

        public boolean visit(EObject object) {
            this.doSwitch(object);
            return true;
        }

        public boolean visit(Resource resource) {
            return true;
        }

        protected String getDescription(EObject eObj) {
            Annotation annotation = null;
            Resource eResource = eObj.eResource();
            if (eResource instanceof EmfResource) {
                ModelContents contents = ((EmfResource)eResource).getModelContents();
                annotation = contents.getAnnotation(eObj);
            }
            if (annotation == null) {
                return null;
            }
            String desc = annotation.getDescription();
            return desc;
        }

        protected void addDocumentation(WebServiceComponent component, Documented documented) {
            String desc = this.getDescription((EObject)component);
            this.addDocumentation(desc, documented);
        }

        protected void addDocumentation(String docText, Documented documented) {
            if (docText != null && docText.trim().length() != 0) {
                Documentation doc = this.factory.createDocumentation();
                doc.setTextContent(docText);
                doc.setDocumented(documented);
            }
        }

        protected String getXsdComponentIdentifier(XSDNamedComponent comp) {
            String name = comp.getName();
            String targetNsUri = comp.getTargetNamespace();
            if (this.isDefaultNamespace(targetNsUri)) {
                return name;
            }
            String prefix = (String)this.xsdPrefixByTargetNamespace.get(targetNsUri);
            return String.valueOf(prefix) + ':' + name;
        }

        protected boolean isDefaultNamespace(String namespaceUri) {
            return this.defaultNamespace != null && this.defaultNamespace.equals(namespaceUri);
        }

        protected void addReference(XSDComponent xsdComp) {
            boolean added;
            XSDSchema schema = xsdComp.getSchema();
            boolean bl = added = schema != null && this.referencedXsds.add(schema);
            if (added) {
                String prefix;
                String targetNamespace = schema.getTargetNamespace();
                if (this.isDefaultNamespace(targetNamespace)) {
                    this.xsdPrefixByTargetNamespace.put(targetNamespace, null);
                } else if (this.xsdPrefixByTargetNamespace.put(targetNamespace, prefix = "schema" + ++this.schemaIndex) != null) {
                    String msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.NonUniqueNamespace", (Object)targetNamespace);
                    this.addError(4, msg, null);
                }
            }
        }

        private void addToOperationToProcedureMap(EObject object) {
            IPath path = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(object);
            StringBuffer sb = new StringBuffer();
            String[] segments = path.segments();
            int i = 0;
            while (i < segments.length) {
                if (i != 0) {
                    sb.append('.');
                }
                String segment = segments[i];
                sb.append(segment);
                ++i;
            }
            this.operationToProcedureMap.put(((OperationImpl)object).getName(), sb.toString());
        }

        protected String doGetFullyQualifiedName(WsdlNameRequiredEntity object) {
            if (this.isDefaultNamespace(this.targetNamespace)) {
                return object.getName();
            }
            return String.valueOf(this.wsdlTnsPrefix) + ':' + object.getName();
        }

        protected void addNamespaceDeclaration(String prefix, String namespaceUri) {
            NamespaceDeclaration decl = this.factory.createNamespaceDeclaration();
            this.namespacePrefixes.add(prefix);
            this.xsdPrefixByTargetNamespace.put(namespaceUri, prefix);
            if (!this.isDefaultNamespace(namespaceUri)) {
                decl.setPrefix(prefix);
            }
            decl.setUri(namespaceUri);
            decl.setOwner((NamespaceDeclarationOwner)this.getDefinitions());
        }

        protected void doGenerateImports() {
            LinkedList refedXsds = new LinkedList(this.referencedXsds);
            Collections.sort(refedXsds, new XsdComparator());
            for (XSDSchema xsd : refedXsds) {
                IStatus problem;
                String namespaceUri = xsd.getTargetNamespace();
                String prefix = (String)this.xsdPrefixByTargetNamespace.get(namespaceUri);
                String location = null;
                IPath xsdPath = BasicWsdlGenerator.this.getLocationPathForXsdModel(xsd);
                if (xsdPath != null) {
                    location = xsdPath.toString();
                } else {
                    Resource xsdResource = xsd.eResource();
                    if (xsdResource != null) {
                        URI xsdUri = xsd.eResource().getURI();
                        location = xsdUri.lastSegment();
                    }
                }
                if (this.urlRoot != null) {
                    location = String.valueOf(this.urlRoot) + location;
                }
                if (this.urlSuffix != null) {
                    location = String.valueOf(location) + this.urlSuffix;
                }
                if ((problem = BasicWsdlGenerator.this.doCheckValidUri(location)) != null) {
                    this.problems.add(problem);
                }
                this.addNamespaceDeclaration(prefix, namespaceUri);
                if (this.xsdImportsAsWsdlImports) {
                    Import importObj = this.factory.createImport();
                    importObj.setNamespace(namespaceUri);
                    importObj.setLocation(location);
                    importObj.setDefinitions(this.getDefinitions());
                    continue;
                }
                XSDSchema nestedSchema = this.getSchemaInTypes(true);
                if (namespaceUri != null && namespaceUri.trim().length() != 0) {
                    XSDImport xsdImport = this.xsdFactory.createXSDImport();
                    xsdImport.setNamespace(namespaceUri);
                    xsdImport.setSchemaLocation(location);
                    nestedSchema.getContents().add((Object)xsdImport);
                    continue;
                }
                XSDInclude xsdInclude = this.xsdFactory.createXSDInclude();
                xsdInclude.setSchemaLocation(location);
                nestedSchema.getContents().add((Object)xsdInclude);
            }
        }

        protected Types getTypes(boolean createIfRequired) {
            Types types = this.getDefinitions().getTypes();
            if (types == null && createIfRequired) {
                types = this.factory.createTypes();
                types.setDefinitions(this.getDefinitions());
            }
            return types;
        }

        protected XSDSchema getSchemaInTypes(boolean createIfRequired) {
            XSDSchema schema = null;
            Types types = this.getTypes(createIfRequired);
            if (types != null) {
                EList schemas = types.getSchemas();
                if (schemas.isEmpty()) {
                    if (createIfRequired) {
                        schema = this.xsdFactory.createXSDSchema();
                        schema.setSchemaForSchemaQNamePrefix(BasicWsdlGenerator.XSD_SCHEMA_FOR_SCHEMA_PREFIX);
                        schema.setTargetNamespace(types.getDefinitions().getTargetNamespace());
                        Map qNamePrefixToNamespaceMap = schema.getQNamePrefixToNamespaceMap();
                        qNamePrefixToNamespaceMap.put(schema.getSchemaForSchemaQNamePrefix(), BasicWsdlGenerator.XSD_SCHEMA_FOR_SCHEMA_TARGET_NAMESPACE);
                        qNamePrefixToNamespaceMap.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
                        types.getSchemas().add((Object)schema);
                    }
                } else {
                    schema = (XSDSchema)types.getSchemas().get(0);
                }
            }
            return schema;
        }

        protected void doGenerateStandardNamespaceDeclarations() {
            this.addNamespaceDeclaration(BasicWsdlGenerator.XSD_SCHEMA_FOR_SCHEMA_PREFIX, BasicWsdlGenerator.XSD_SCHEMA_FOR_SCHEMA_TARGET_NAMESPACE);
            this.addNamespaceDeclaration("wsdl", "http://schemas.xmlsoap.org/wsdl/");
            this.addNamespaceDeclaration("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        }

        protected void doGenerateTargetNamespaceNamespaceDeclaration() {
            if (this.xsdPrefixByTargetNamespace.put(this.targetNamespace, this.wsdlTnsPrefix) != null) {
                String msg = WebServicePlugin.Util.getString("BasicWsdlGenerator.NonUniqueWSDLNamespace", (Object)this.targetNamespace);
                this.addError(4, msg, null);
            }
            this.addNamespaceDeclaration(this.wsdlTnsPrefix, this.targetNamespace);
        }

        public void complete() {
            this.doGenerateImports();
        }

        protected Object doSwitch(EObject theEObject) {
            return this.doSwitch(theEObject.eClass(), theEObject);
        }

        protected Object doSwitch(EClass theEClass, EObject theEObject) {
            if (theEClass.eContainer() == WebServicePackage.eINSTANCE) {
                return this.doWebServiceSwitch(theEClass.getClassifierID(), theEObject);
            }
            EList eSuperTypes = theEClass.getESuperTypes();
            return eSuperTypes.isEmpty() ? this.defaultCase(theEObject) : this.doSwitch((EClass)eSuperTypes.get(0), theEObject);
        }

        protected Object doWebServiceSwitch(int classifierID, EObject theEObject) {
            switch (classifierID) {
                case 0: {
                    Operation operation = (Operation)theEObject;
                    Object result = this.caseOperation(operation);
                    return result;
                }
                case 3: {
                    org.teiid.designer.metamodels.webservice.Input input = (org.teiid.designer.metamodels.webservice.Input)theEObject;
                    Object result = this.caseInput(input);
                    return result;
                }
                case 4: {
                    org.teiid.designer.metamodels.webservice.Output output = (org.teiid.designer.metamodels.webservice.Output)theEObject;
                    Object result = this.caseOutput(output);
                    return result;
                }
                case 5: {
                    Interface interface_ = (Interface)theEObject;
                    Object result = this.caseInterface(interface_);
                    return result;
                }
            }
            return this.defaultCase(theEObject);
        }

        public Object defaultCase(EObject object) {
            return null;
        }

        public Object caseInterface(Interface object) {
            IStatus problem;
            String interfaceName = object.getName();
            BasicWsdlGenerator.this.ports.add(interfaceName);
            this.portType = this.factory.createPortType();
            this.portType.setName(interfaceName);
            this.portType.setDefinitions(this.getDefinitions());
            this.addDocumentation((WebServiceComponent)object, (Documented)this.portType);
            String bindingType = this.doGetFullyQualifiedName((WsdlNameRequiredEntity)this.portType);
            this.binding = this.factory.createBinding();
            this.binding.setName(interfaceName);
            this.binding.setType(bindingType);
            this.binding.setDefinitions(this.getDefinitions());
            SoapBinding soapBinding = this.soapFactory.createSoapBinding();
            soapBinding.setStyle(SoapStyleType.DOCUMENT_LITERAL);
            soapBinding.setTransport("http://schemas.xmlsoap.org/soap/http");
            this.binding.setSoapBinding(soapBinding);
            String portTypeName = this.doGetFullyQualifiedName((WsdlNameRequiredEntity)this.portType);
            Port port = this.factory.createPort();
            port.setName(interfaceName);
            port.setBinding(portTypeName);
            port.setService(this.service);
            String serviceUrlWithPortName = this.service.getName();
            if (this.urlService != null && (problem = BasicWsdlGenerator.this.doCheckValidUri(serviceUrlWithPortName = String.valueOf(this.urlService) + port.getName())) != null) {
                this.problems.add(problem);
            }
            SoapAddress address = this.soapFactory.createSoapAddress();
            address.setLocation(serviceUrlWithPortName);
            address.setPort(port);
            return object;
        }

        public Object caseOperation(Operation object) {
            String opName = object.getName();
            this.operation = this.factory.createOperation();
            this.operation.setName(opName);
            this.operation.setPortType(this.portType);
            this.addDocumentation((WebServiceComponent)object, (Documented)this.operation);
            this.bindingOp = this.factory.createBindingOperation();
            this.bindingOp.setName(opName);
            this.bindingOp.setBinding(this.binding);
            SoapOperation soapOp = this.soapFactory.createSoapOperation();
            String action = opName;
            soapOp.setAction(action);
            this.addToOperationToProcedureMap((EObject)object);
            soapOp.setStyle(SoapStyleType.DOCUMENT_LITERAL);
            soapOp.setBindingOperation(this.bindingOp);
            if (object.getInput() == null) {
                this.createDummyInput();
            }
            return object;
        }

        public Object caseInput(org.teiid.designer.metamodels.webservice.Input object) {
            Object[] params2;
            String value;
            Input input = this.factory.createInput();
            String inputName = object.getName();
            if (inputName == null || inputName.trim().length() == 0) {
                inputName = WebServicePlugin.Util.getString("BasicWsdlGenerator.DefaultInputName", new Object[0]);
            }
            Object[] params = new Object[]{this.portType.getName(), this.operation.getName(), inputName};
            String msgName = WebServicePlugin.Util.getString("BasicWsdlGenerator.InputMessageName_PortTypeName_OperationName_InputName", params);
            Message message = this.factory.createMessage();
            message.setName(msgName);
            message.setDefinitions(this.getDefinitions());
            MessagePart part = this.factory.createMessagePart();
            XSDElementDeclaration xsdElement = object.getContentElement();
            XSDComplexTypeDefinition xsdComplexType = object.getContentComplexType();
            XSDSimpleTypeDefinition xsdSimpleType = object.getContentSimpleType();
            if (xsdElement != null) {
                this.addReference((XSDComponent)xsdElement);
                value = this.getXsdComponentIdentifier((XSDNamedComponent)xsdElement);
                part.setElement(value);
            } else if (xsdComplexType != null) {
                this.addReference((XSDComponent)xsdComplexType);
                value = this.getXsdComponentIdentifier((XSDNamedComponent)xsdComplexType);
                part.setType(value);
            } else if (xsdSimpleType != null) {
                this.addReference((XSDComponent)xsdSimpleType);
                value = this.getXsdComponentIdentifier((XSDNamedComponent)xsdSimpleType);
                part.setType(value);
            }
            part.setName(msgName);
            part.setMessage(message);
            this.messagePartNameByWebServiceMessage.put(object, msgName);
            input.setMessage(this.doGetFullyQualifiedName((WsdlNameRequiredEntity)message));
            input.setOperation(this.operation);
            this.addDocumentation((WebServiceComponent)object, (Documented)input);
            String inputMsg = null;
            String inputDesc = this.getDescription((EObject)object);
            if (inputDesc != null && inputDesc.trim().length() != 0) {
                params2 = new Object[]{this.portType.getName(), this.operation.getName(), inputDesc};
                inputMsg = WebServicePlugin.Util.getString("BasicWsdlGenerator.InputMsgDesc_PortTypeName_OperationName_InputDesc", params2);
            } else {
                params2 = new Object[]{this.portType.getName(), this.operation.getName()};
                inputMsg = WebServicePlugin.Util.getString("BasicWsdlGenerator.InputMsgDesc_PortTypeName_OperationName", params2);
            }
            this.addDocumentation(inputMsg, (Documented)message);
            BindingInput bindingInput = this.factory.createBindingInput();
            bindingInput.setBindingOperation(this.bindingOp);
            SoapBody soapBody = this.soapFactory.createSoapBody();
            soapBody.setUse(SoapUseType.LITERAL_LITERAL);
            bindingInput.setSoapBody(soapBody);
            return object;
        }

        public Object caseOutput(org.teiid.designer.metamodels.webservice.Output object) {
            Object[] params2;
            XSDComponent comp;
            XmlRoot root;
            XmlDocument xmlDoc;
            Output output = this.factory.createOutput();
            String outputName = object.getName();
            if (outputName == null || outputName.trim().length() == 0) {
                outputName = WebServicePlugin.Util.getString("BasicWsdlGenerator.DefaultOutputName", new Object[0]);
            }
            Object[] params = new Object[]{this.portType.getName(), this.operation.getName(), outputName};
            String msgName = WebServicePlugin.Util.getString("BasicWsdlGenerator.OutputMessageName_PortTypeName_OperationName_OutputName", params);
            Message message = this.factory.createMessage();
            message.setName(msgName);
            message.setDefinitions(this.getDefinitions());
            MessagePart part = this.factory.createMessagePart();
            XSDElementDeclaration xsdElement = object.getContentElement();
            if (xsdElement == null && (xmlDoc = object.getXmlDocument()) != null && (root = xmlDoc.getRoot()) != null && (comp = root.getXsdComponent()) instanceof XSDElementDeclaration) {
                xsdElement = (XSDElementDeclaration)comp;
            }
            if (xsdElement != null) {
                this.addReference((XSDComponent)xsdElement);
                String value = this.getXsdComponentIdentifier((XSDNamedComponent)xsdElement);
                part.setElement(value);
            } else {
                String value;
                XSDComplexTypeDefinition xsdComplexType = object.getContentComplexType();
                XSDSimpleTypeDefinition xsdSimpleType = object.getContentSimpleType();
                if (xsdComplexType != null) {
                    this.addReference((XSDComponent)xsdComplexType);
                    value = this.getXsdComponentIdentifier((XSDNamedComponent)xsdComplexType);
                    part.setType(value);
                } else if (xsdSimpleType != null) {
                    this.addReference((XSDComponent)xsdSimpleType);
                    value = this.getXsdComponentIdentifier((XSDNamedComponent)xsdSimpleType);
                    part.setType(value);
                }
            }
            part.setName(msgName);
            part.setMessage(message);
            this.messagePartNameByWebServiceMessage.put(object, msgName);
            output.setMessage(this.doGetFullyQualifiedName((WsdlNameRequiredEntity)message));
            output.setOperation(this.operation);
            this.addDocumentation((WebServiceComponent)object, (Documented)output);
            String outputMsg = null;
            String outputDesc = this.getDescription((EObject)object);
            if (outputDesc != null && outputDesc.trim().length() != 0) {
                params2 = new Object[]{this.portType.getName(), this.operation.getName(), outputDesc};
                outputMsg = WebServicePlugin.Util.getString("BasicWsdlGenerator.OutputMsgDesc_PortTypeName_OperationName_OutputDesc", params2);
            } else {
                params2 = new Object[]{this.portType.getName(), this.operation.getName()};
                outputMsg = WebServicePlugin.Util.getString("BasicWsdlGenerator.OutputMsgDesc_PortTypeName_OperationName", params2);
            }
            this.addDocumentation(outputMsg, (Documented)message);
            BindingOutput bindingOutput = this.factory.createBindingOutput();
            bindingOutput.setBindingOperation(this.bindingOp);
            SoapBody soapBody = this.soapFactory.createSoapBody();
            soapBody.setUse(SoapUseType.LITERAL_LITERAL);
            bindingOutput.setSoapBody(soapBody);
            return object;
        }

        protected void createDummyInput() {
            Input input = this.factory.createInput();
            String inputName = WebServicePlugin.Util.getString("BasicWsdlGenerator.DefaultInputName", new Object[0]);
            Object[] params = new Object[]{this.portType.getName(), this.operation.getName(), inputName};
            String msgName = WebServicePlugin.Util.getString("BasicWsdlGenerator.InputMessageName_PortTypeName_OperationName_InputName", params);
            Message message = this.factory.createMessage();
            message.setName(msgName);
            message.setDefinitions(this.getDefinitions());
            input.setMessage(this.doGetFullyQualifiedName((WsdlNameRequiredEntity)message));
            input.setOperation(this.operation);
            Object[] params2 = new Object[]{this.portType.getName(), this.operation.getName()};
            String inputMsg = WebServicePlugin.Util.getString("BasicWsdlGenerator.InputMsgDesc_PortTypeName_OperationName", params2);
            this.addDocumentation(inputMsg, (Documented)message);
            BindingInput bindingInput = this.factory.createBindingInput();
            bindingInput.setBindingOperation(this.bindingOp);
            SoapBody soapBody = this.soapFactory.createSoapBody();
            soapBody.setUse(SoapUseType.LITERAL_LITERAL);
            bindingInput.setSoapBody(soapBody);
        }

        protected class XsdComparator
        implements Comparator {
            protected XsdComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (o1 instanceof XSDSchema && o2 instanceof XSDSchema) {
                    String tn1 = ((XSDSchema)o1).getTargetNamespace();
                    String tn2 = ((XSDSchema)o2).getTargetNamespace();
                    if (tn1 == null && tn2 == null) {
                        return 0;
                    }
                    if (tn1 == null) {
                        return -1;
                    }
                    if (tn2 == null) {
                        return 1;
                    }
                    return tn1.compareTo(tn2);
                }
                return 0;
            }
        }
    }

    protected class Wsdl20Generator
    extends Wsdl11Generator {
        protected Wsdl20Generator(Resource wsdlResource, String name, String targetNamespace, String defaultNamespace, String urlRoot, String urlSuffix, String urlService, List problems) {
            super(wsdlResource, name, targetNamespace, defaultNamespace, urlRoot, urlSuffix, urlService, problems);
        }
    }
}

