/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.mapping.factory.ModelMapperFactory;
import org.teiid.designer.metamodels.transformation.SqlTransformation;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationContainer;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.webservice.SampleMessages;
import org.teiid.designer.metamodels.webservice.WebServiceComponent;
import org.teiid.designer.metamodels.webservice.WebServiceFactory;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlDocumentBuilderImpl;
import org.teiid.designer.metamodels.xml.XmlDocumentFactory;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.webservice.IWebServiceXmlDocumentGenerator;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.util.WebServiceUtil;

public class BasicWebServiceXmlDocumentGenerator
implements IWebServiceXmlDocumentGenerator {
    private Resource xmlDocResource;
    private final List webServiceComponents = new ArrayList();
    private boolean reuseExistingDocuments;
    private ModelSelector webServiceModelSelector;

    @Override
    public void addWebServiceComponent(WebServiceComponent webServiceComponent) {
        CoreArgCheck.isNotNull((Object)webServiceComponent);
        if (!this.webServiceComponents.contains(webServiceComponent)) {
            this.webServiceComponents.add(webServiceComponent);
        }
    }

    @Override
    public void addWebServiceComponents(List webServiceComponents) {
        CoreArgCheck.isNotNull((Object)webServiceComponents);
        for (WebServiceComponent webServiceComponent : webServiceComponents) {
            if (webServiceComponent == null || this.webServiceComponents.contains(webServiceComponent)) continue;
            this.webServiceComponents.add(webServiceComponent);
        }
    }

    @Override
    public ModelSelector getWebServiceModelSelector() {
        return this.webServiceModelSelector;
    }

    @Override
    public void setWebServiceModelSelector(ModelSelector wsModelSelector) {
        this.webServiceModelSelector = wsModelSelector;
    }

    @Override
    public List getWebServiceComponents() {
        return this.webServiceComponents;
    }

    @Override
    public void setXmlDocumentResource(Resource wsModel) {
        CoreArgCheck.isNotNull((Object)wsModel);
        this.xmlDocResource = wsModel;
    }

    @Override
    public Resource getXmlDocumentResource() {
        return this.xmlDocResource;
    }

    @Override
    public IStatus generate(IProgressMonitor monitor) {
        ArrayList<Status> problems = new ArrayList<Status>();
        if (this.getXmlDocumentResource() == null) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceXmlDocumentGenerator.NoXmlDocumentModelSpecified", new Object[0]);
            problems.add(new Status(4, "org.teiid.designer.webservice", 0, msg, null));
        } else {
            this.doGenerate(monitor, problems);
        }
        IStatus result = null;
        if (problems.size() == 0) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceXmlDocumentGenerator.GenerationOfXmlDocumentsSucceeded", new Object[0]);
            result = new Status(0, "org.teiid.designer.webservice", 0, msg, null);
        } else if (problems.size() == 1) {
            result = (IStatus)problems.get(0);
        } else {
            int errors = 0;
            int warnings = 0;
            for (IStatus iStatus : problems) {
                switch (iStatus.getSeverity()) {
                    case 4: {
                        ++errors;
                        break;
                    }
                    case 2: {
                        ++warnings;
                    }
                }
            }
            Object[] objectArray = new Object[]{new Integer(errors), new Integer(warnings)};
            String msg = WebServicePlugin.Util.getString("BasicWebServiceXmlDocumentGenerator.GeneratedXmlDocumentWithErrorsAndWarnings", objectArray);
            IStatus[] children = problems.toArray(new IStatus[problems.size()]);
            result = new MultiStatus("org.teiid.designer.webservice", 0, children, msg, null);
        }
        return result;
    }

    @Override
    public void generate(IProgressMonitor monitor, List problems) {
        this.doGenerate(monitor, problems);
    }

    protected void doGenerate(IProgressMonitor monitor, List problems) {
        ArrayList outputs = new ArrayList();
        WebServiceVisitor visitor = new WebServiceVisitor(outputs);
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
        try {
            processor.walk((Collection)this.webServiceComponents, 2);
        }
        catch (ModelerCoreException modelerCoreException) {}
        ModelContents wsContents = null;
        try {
            wsContents = this.getWebServiceModelSelector().getModelContents();
        }
        catch (ModelWorkspaceException err) {
            String message = WebServicePlugin.Util.getString("BasicWebServiceXmlDocumentGenerator.UnableToGetWebServiceContents", new Object[0]);
            Status status = new Status(4, "org.teiid.designer.webservice", 0, message, (Throwable)err);
            problems.add(status);
        }
        if (wsContents != null && outputs.size() != 0) {
            ArrayList docs = new ArrayList();
            ModelContents xmlContents = this.doGetModelContents();
            for (Output output : outputs) {
                XmlDocument xmlDoc = this.doGenerateXmlDocument(output, monitor, problems, docs, xmlContents);
                if (xmlDoc != null) {
                    this.doGenerateTransformation(output, xmlDoc, monitor, problems, wsContents);
                }
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    protected String computeXmlDocumentName(Output output) {
        StringBuffer sb = new StringBuffer();
        sb.append(output.getOperation().getInterface().getName());
        sb.append('_');
        sb.append(output.getOperation().getName());
        sb.append('_');
        sb.append(output.getName());
        return sb.toString();
    }

    protected String getFullName(EObject output) {
        return ModelerCore.getModelEditor().getModelRelativePathIncludingModel(output).toString();
    }

    protected XmlDocument doGenerateXmlDocument(Output output, IProgressMonitor monitor, List problems, List newDocs, ModelContents contents) {
        if (monitor.isCanceled()) {
            return null;
        }
        XSDElementDeclaration elementDecl = output.getContentElement();
        if (elementDecl == null) {
            return null;
        }
        if (elementDecl.getURI() == null) {
            return null;
        }
        XmlDocument xmlDoc = null;
        if (this.reuseExistingDocuments) {
            for (EObject root : this.xmlDocResource.getContents()) {
                XmlDocument existingDoc;
                XmlRoot rootElement;
                XSDComponent rootElementXsdComp;
                if (!(root instanceof XmlDocument) || !((rootElementXsdComp = (rootElement = (existingDoc = (XmlDocument)root).getRoot()).getXsdComponent()) instanceof XSDElementDeclaration)) continue;
                XSDElementDeclaration namedComponent = (XSDElementDeclaration)rootElementXsdComp;
                if (!elementDecl.getURI().equals(namedComponent.getURI())) continue;
                xmlDoc = existingDoc;
                break;
            }
        }
        if (monitor.isCanceled()) {
            return xmlDoc;
        }
        if (xmlDoc == null) {
            XmlDocumentBuilderImpl builder = new XmlDocumentBuilderImpl();
            XmlDocumentFactory factory = XmlDocumentFactory.eINSTANCE;
            try {
                xmlDoc = factory.createXmlDocument();
                String docName = this.computeXmlDocumentName(output);
                xmlDoc.setName(docName);
                this.xmlDocResource.getContents().add((Object)xmlDoc);
                newDocs.add(xmlDoc);
                XmlRoot docRoot = factory.createXmlRoot();
                docRoot.setName(elementDecl.getName());
                docRoot.setXsdComponent((XSDComponent)elementDecl);
                xmlDoc.setRoot(docRoot);
                builder.buildDocument((XmlElement)docRoot, monitor);
                ITreeToRelationalMapper mapper = ModelMapperFactory.createModelMapper((EObject)xmlDoc);
                if (mapper != null) {
                    MappingClassFactory mcFactory = new MappingClassFactory(mapper);
                    mcFactory.generateMappingClasses((EObject)docRoot, MappingClassBuilderStrategy.iterationStrategy, true);
                }
            }
            catch (Exception e) {
                Object[] params = new Object[]{this.getFullName((EObject)output)};
                String message = WebServicePlugin.Util.getString("BasicWebServiceXmlDocumentGenerator.ErrorWhileGeneratingXmlDocumentForWsModel", params);
                Status status = new Status(4, "org.teiid.designer.webservice", 0, message, (Throwable)e);
                problems.add(status);
            }
        }
        if (xmlDoc != null) {
            output.setXmlDocument(xmlDoc);
            return xmlDoc;
        }
        return xmlDoc;
    }

    protected void doGenerateTransformation(Output output, XmlDocument xmlDoc, IProgressMonitor monitor, List problems, ModelContents wsContents) {
        if (output == null || xmlDoc == null) {
            return;
        }
        Operation op = output.getOperation();
        if (op == null) {
            return;
        }
        WebServiceUtil util = new WebServiceUtil();
        String sql = util.generateTransformationSql(output, xmlDoc);
        if (sql != null) {
            SampleMessages resultSetColumn;
            SqlTransformation userSqlTrans;
            SqlTransformation sqlTransformation;
            SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)op, (boolean)false, (boolean)false);
            if (mappingRoot == null) {
                mappingRoot = TransformationFactory.eINSTANCE.createSqlTransformationMappingRoot();
                try {
                    TransformationContainer tc = ModelResourceContainerFactory.getTransformationContainer((Resource)op.eResource(), (boolean)true);
                    mappingRoot.setTarget((EObject)op);
                    ModelerCore.getModelEditor().addValue((Object)mappingRoot, (Object)op, mappingRoot.getOutputs());
                    ModelerCore.getModelEditor().addValue((Object)tc, (Object)mappingRoot, tc.getTransformationMappings());
                }
                catch (ModelerCoreException err) {
                    ModelerCore.Util.log(4, (Throwable)err, WebServicePlugin.Util.getString("BasicWebServiceXmlDocumentGenerator.ErrorWhileGeneratingTransformationsForWsModel", (Object)op));
                }
            }
            if ((sqlTransformation = (SqlTransformation)TransformationHelper.getMappingHelper((Object)mappingRoot)) == null) {
                sqlTransformation = TransformationFactory.eINSTANCE.createSqlTransformation();
                mappingRoot.setHelper((MappingHelper)sqlTransformation);
            }
            if ((userSqlTrans = TransformationHelper.getUserSqlTransformation((Object)mappingRoot)) == null) {
                userSqlTrans = TransformationFactory.eINSTANCE.createSqlTransformation();
                userSqlTrans.setNestedIn((MappingHelper)sqlTransformation);
            }
            userSqlTrans.setSelectSql(sql);
            mappingRoot.getInputs().add((Object)xmlDoc);
            if (!mappingRoot.getOutputs().contains((Object)op)) {
                mappingRoot.getOutputs().add((Object)op);
            }
            if ((resultSetColumn = output.getSamples()) == null) {
                resultSetColumn = WebServiceFactory.eINSTANCE.createSampleMessages();
                output.setSamples(resultSetColumn);
            }
        }
    }

    protected ModelContents doGetModelContents() {
        ModelContents contents = this.xmlDocResource instanceof EmfResource ? ((EmfResource)this.xmlDocResource).getModelContents() : new ModelContents(this.xmlDocResource);
        return contents;
    }

    protected class WebServiceVisitor
    implements ModelVisitor {
        private final List outputs;

        protected WebServiceVisitor(List outputs) {
            this.outputs = outputs;
        }

        public boolean visit(EObject object) {
            if (object instanceof Output) {
                this.outputs.add(object);
                return false;
            }
            if (object instanceof Interface) {
                return true;
            }
            return object instanceof Operation;
        }

        public boolean visit(Resource resource) {
            return true;
        }
    }
}

