/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.WebServiceComponent;
import org.teiid.designer.metamodels.webservice.WebServiceFactory;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.metamodels.wsdl.Documentation;
import org.teiid.designer.metamodels.wsdl.Documented;
import org.teiid.designer.metamodels.wsdl.Input;
import org.teiid.designer.metamodels.wsdl.Message;
import org.teiid.designer.metamodels.wsdl.MessagePart;
import org.teiid.designer.metamodels.wsdl.NamespaceDeclaration;
import org.teiid.designer.metamodels.wsdl.Output;
import org.teiid.designer.metamodels.wsdl.ParamType;
import org.teiid.designer.metamodels.wsdl.PortType;
import org.teiid.designer.metamodels.wsdl.util.WsdlSwitch;
import org.teiid.designer.webservice.IWebServiceGenerator;
import org.teiid.designer.webservice.WebServicePlugin;

public class BasicWebServiceGenerator
implements IWebServiceGenerator {
    private Resource webServiceResource;
    protected final List wsdlDefinitions = new ArrayList();
    private final List xsdSchemas = new ArrayList();
    Collection selectedWsdlOperations = new HashSet();

    @Override
    public void setWebServiceResource(Resource wsModel) {
        CoreArgCheck.isNotNull((Object)wsModel);
        this.webServiceResource = wsModel;
    }

    @Override
    public Resource getWebServiceResource() {
        return this.webServiceResource;
    }

    @Override
    public void addWsdlDefinitions(Definitions wsdlDefinitions) {
        CoreArgCheck.isNotNull((Object)wsdlDefinitions);
        if (!this.wsdlDefinitions.contains(wsdlDefinitions)) {
            this.wsdlDefinitions.add(wsdlDefinitions);
        }
    }

    @Override
    public void addWsdlDefinitions(List wsdlDefinitions) {
        CoreArgCheck.isNotNull((Object)wsdlDefinitions);
        for (Object obj : wsdlDefinitions) {
            if (!(obj instanceof Definitions)) continue;
            this.addWsdlDefinitions((Definitions)obj);
        }
    }

    @Override
    public List getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    @Override
    public void addXsdSchema(XSDSchema schema) {
        CoreArgCheck.isNotNull((Object)schema);
        if (!this.xsdSchemas.contains(schema)) {
            this.xsdSchemas.add(schema);
        }
    }

    @Override
    public void addXsdSchemas(List schemas) {
        CoreArgCheck.isNotNull((Object)schemas);
        for (Object obj : schemas) {
            if (!(obj instanceof XSDSchema)) continue;
            this.addXsdSchema((XSDSchema)obj);
        }
    }

    @Override
    public List getXsdSchemas() {
        return this.xsdSchemas;
    }

    @Override
    public void setSelectedOperations(Collection operations) {
        this.selectedWsdlOperations = operations;
    }

    @Override
    public Collection getSelectedOperations() {
        return this.selectedWsdlOperations;
    }

    @Override
    public IStatus generate(IProgressMonitor monitor) {
        ArrayList<Status> problems = new ArrayList<Status>();
        if (this.getWebServiceResource() == null) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceGenerator.NoWebServiceModelSpecified", new Object[0]);
            problems.add(new Status(4, "org.teiid.designer.webservice", 0, msg, null));
        } else {
            this.doGenerate(monitor, problems);
        }
        IStatus result = null;
        if (problems.size() == 0) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceGenerator.GenerationOfWebServiceModelSucceeded", new Object[0]);
            result = new Status(0, "org.teiid.designer.webservice", 0, msg, null);
        } else if (problems.size() == 1) {
            result = (IStatus)problems.get(0);
        } else {
            int errors = 0;
            int warnings = 0;
            for (IStatus iStatus : problems) {
                switch (iStatus.getSeverity()) {
                    case 4: {
                        ++errors;
                        break;
                    }
                    case 2: {
                        ++warnings;
                    }
                }
            }
            Object[] objectArray = new Object[]{new Integer(errors), new Integer(warnings)};
            String msg = WebServicePlugin.Util.getString("BasicWebServiceGenerator.GeneratedWebServiceModelWithErrorsAndWarnings", objectArray);
            IStatus[] children = problems.toArray(new IStatus[problems.size()]);
            result = new MultiStatus("org.teiid.designer.webservice", 0, children, msg, null);
        }
        return result;
    }

    @Override
    public void generate(IProgressMonitor monitor, List problems) {
        this.doGenerate(monitor, problems);
    }

    protected void doGenerate(IProgressMonitor monitor, List problems) {
        String desc;
        ModelContents contents = this.doGetModelContents();
        ModelAnnotation modelAnnotation = contents.getModelAnnotation();
        modelAnnotation.setModelType(ModelType.VIRTUAL_LITERAL);
        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/WebService");
        if (this.wsdlDefinitions.size() != 0 && ((desc = modelAnnotation.getDescription()) == null || desc.trim().length() == 0)) {
            String msg;
            try {
                StringBuffer sb = new StringBuffer();
                msg = WebServicePlugin.Util.getString("BasicWebServiceGenerator.DescriptionStartingSection", new Object[0]);
                sb.append(msg);
                for (Definitions defns : this.wsdlDefinitions) {
                    String name = defns.getTargetNamespace();
                    String targetNs = defns.getTargetNamespace();
                    String line = WebServicePlugin.Util.getString("BasicWebServiceGenerator.DescriptionWsdlNameAndTargetNS", new Object[]{name, targetNs});
                    sb.append(CoreStringUtil.LINE_SEPARATOR);
                    sb.append(line);
                }
                modelAnnotation.setDescription(sb.toString());
            }
            catch (RuntimeException t) {
                msg = WebServicePlugin.Util.getString("BasicWebServiceGenerator.UnexpectedProblemBuildingDescription", new Object[0]);
                WebServicePlugin.Util.log(2, (Throwable)t, msg);
            }
        }
        WsdlVisitor visitor = new WsdlVisitor(this.webServiceResource, this.wsdlDefinitions, contents, problems);
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
        try {
            processor.walk((Collection)this.wsdlDefinitions, 2);
        }
        catch (ModelerCoreException e) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceGenerator.ErrorWhileProcessingWsdlAndCreatingWebServiceModel", new Object[0]);
            Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, (Throwable)e);
            problems.add(status);
        }
        visitor.complete();
    }

    protected ModelContents doGetModelContents() {
        ModelContents contents = this.webServiceResource instanceof EmfResource ? ((EmfResource)this.webServiceResource).getModelContents() : new ModelContents(this.webServiceResource);
        return contents;
    }

    protected List doFindSchemas(String uri) {
        String uriStr = uri != null ? uri : "";
        Iterator iter = this.xsdSchemas.iterator();
        ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>(this.xsdSchemas.size());
        while (iter.hasNext()) {
            XSDSchema schema = (XSDSchema)iter.next();
            if (!uriStr.equals(schema.getTargetNamespace())) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    protected class Identifier {
        public final String prefix;
        public final String name;
        public final String uri;

        public Identifier(String prefix, String name, String uri) {
            this.prefix = prefix;
            this.name = name;
            this.uri = uri;
        }
    }

    protected class WsdlVisitor
    extends WsdlSwitch
    implements ModelVisitor {
        private final String DEFAULT_NAMESPACE_PREFIX = "DEFAULT_NS_PREFIX_9485338";
        private final List problems;
        protected final Resource resource;
        protected final ModelContents contents;
        private final WebServiceFactory factory;
        private final Map namespaceUrisByPrefix;
        private List definitions;
        private Interface iface;
        private Map operations;

        protected WsdlVisitor(Resource webServiceResource, List wsdlDefinitions, ModelContents contents, List problems) {
            this.problems = problems;
            this.resource = webServiceResource;
            this.factory = WebServiceFactory.eINSTANCE;
            this.namespaceUrisByPrefix = new HashMap();
            this.contents = contents != null ? contents : new ModelContents(this.resource);
            this.definitions = wsdlDefinitions;
            this.operations = new HashMap();
        }

        protected void addError(int code, String msg, Throwable t) {
            this.problems.add(new Status(4, "org.teiid.designer.webservice", code, msg, t));
        }

        protected void addWarning(int code, String msg, Throwable t) {
            this.problems.add(new Status(2, "org.teiid.designer.webservice", code, msg, t));
        }

        public boolean visit(EObject object) {
            this.doSwitch(object);
            return true;
        }

        public boolean visit(Resource resource) {
            return true;
        }

        protected String addDescription(WebServiceComponent component, Documented wsdlDocumented) {
            String desc;
            Documentation doc;
            if (wsdlDocumented != null && (doc = wsdlDocumented.getDocumentation()) != null && (desc = doc.getTextContent()) != null && desc.trim().length() != 0) {
                Annotation annotation = this.contents.getAnnotation((EObject)component);
                if (annotation == null) {
                    annotation = ModelResourceContainerFactory.createNewAnnotation((EObject)component, (AnnotationContainer)this.contents.getAnnotationContainer(true));
                }
                if (annotation != null) {
                    annotation.setDescription(desc);
                    return desc;
                }
            }
            return null;
        }

        protected String getNamespaceUriForPrefix(String prefix) {
            if (prefix == null || prefix.trim().length() == 0) {
                return (String)this.namespaceUrisByPrefix.get("DEFAULT_NS_PREFIX_9485338");
            }
            return (String)this.namespaceUrisByPrefix.get(prefix);
        }

        protected Identifier parseIdentifier(String identifier) {
            List idParts = CoreStringUtil.split((String)identifier, (String)":");
            if (idParts.isEmpty()) {
                return null;
            }
            String name = null;
            String prefix = null;
            if (idParts.size() == 1) {
                name = (String)idParts.get(0);
            } else {
                prefix = (String)idParts.get(0);
                name = (String)idParts.get(1);
            }
            String uri = this.getNamespaceUriForPrefix(prefix);
            return new Identifier(prefix, name, uri);
        }

        protected Message findMessage(ParamType paramType) {
            String msgId = paramType.getMessage();
            if (msgId == null || msgId.trim().length() == 0) {
                return null;
            }
            Identifier identifier = this.parseIdentifier(msgId);
            String uri = identifier.uri;
            for (Definitions def : this.definitions) {
                if (!def.getTargetNamespace().equals(uri)) continue;
                for (Message msg : def.getMessages()) {
                    if (msg.getName() == null || !msg.getName().equals(identifier.name)) continue;
                    return msg;
                }
            }
            return null;
        }

        public void complete() {
        }

        public Object caseDefinitions(Definitions object) {
            for (NamespaceDeclaration nsDecl : object.getDeclaredNamespaces()) {
                XSDSchema sos;
                String prefix = nsDecl.getPrefix();
                if (prefix == null || prefix.trim().length() == 0) {
                    prefix = "DEFAULT_NS_PREFIX_9485338";
                }
                String uri = nsDecl.getUri();
                this.namespaceUrisByPrefix.put(prefix, uri);
                if (!"http://www.w3.org/2001/XMLSchema".equals(uri) && !"http://www.w3.org/2000/10/XMLSchema".equals(uri) && !"http://www.w3.org/1999/XMLSchema".equals(uri) || (sos = XSDSchemaImpl.getSchemaForSchema((String)uri)) == null) continue;
                BasicWebServiceGenerator.this.addXsdSchema(sos);
            }
            return object;
        }

        public Object casePortType(PortType object) {
            if (BasicWebServiceGenerator.this.selectedWsdlOperations != null && !BasicWebServiceGenerator.this.selectedWsdlOperations.contains(object)) {
                boolean doCreate = false;
                for (Object nextObj : object.getOperations()) {
                    if (nextObj instanceof org.teiid.designer.metamodels.wsdl.Operation) {
                        doCreate = BasicWebServiceGenerator.this.selectedWsdlOperations.contains(nextObj);
                    }
                    if (doCreate) break;
                }
                if (!doCreate) {
                    return null;
                }
            }
            this.iface = this.factory.createInterface();
            StringNameValidator validator = new StringNameValidator();
            String name = object.getName();
            if (!validator.isValidName(name)) {
                name = validator.createValidName(name);
            }
            this.iface.setName(name);
            this.resource.getContents().add((Object)this.iface);
            return object;
        }

        public Object caseOperation(org.teiid.designer.metamodels.wsdl.Operation object) {
            if (BasicWebServiceGenerator.this.selectedWsdlOperations != null && !BasicWebServiceGenerator.this.selectedWsdlOperations.contains(object)) {
                return null;
            }
            Operation operation = this.factory.createOperation();
            String name = object.getName();
            String namespace = object.getPortType().getDefinitions().getTargetNamespace();
            QName qname = new QName(namespace, name);
            operation.setName(name);
            operation.setInterface(this.iface);
            try {
                NewModelObjectHelperManager.helpCreate((Object)operation, null);
            }
            catch (ModelerCoreException theException) {
                String message = WebServicePlugin.Util.getString("WebServiceBuilderHelper.createOperation.errMsg", new Object[0]);
                WebServicePlugin.Util.log(4, (Throwable)theException, message);
            }
            this.operations.put(qname, operation);
            return object;
        }

        public Object caseInput(Input object) {
            org.teiid.designer.metamodels.webservice.Input input = this.factory.createInput();
            this.doProcessMessage((org.teiid.designer.metamodels.webservice.Message)input, (ParamType)object);
            String operationName = object.getOperation().getName();
            String operationNamespace = object.getOperation().getPortType().getDefinitions().getTargetNamespace();
            Operation operation = (Operation)this.operations.get(new QName(operationNamespace, operationName));
            input.setOperation(operation);
            return object;
        }

        public Object caseOutput(Output object) {
            org.teiid.designer.metamodels.webservice.Output output = this.factory.createOutput();
            this.doProcessMessage((org.teiid.designer.metamodels.webservice.Message)output, (ParamType)object);
            String operationName = object.getOperation().getName();
            String operationNamespace = object.getOperation().getPortType().getDefinitions().getTargetNamespace();
            Operation operation = (Operation)this.operations.get(new QName(operationNamespace, operationName));
            output.setOperation(operation);
            return object;
        }

        public Object doProcessMessage(org.teiid.designer.metamodels.webservice.Message message, ParamType object) {
            String desc;
            List schemas;
            Identifier ident;
            Message msg = null;
            String name = object.getName();
            String xsdIdentifier = null;
            if (name == null || name.trim().length() == 0) {
                msg = this.findMessage(object);
                if (msg != null) {
                    name = msg.getName();
                    boolean needName = name == null || name.trim().length() == 0;
                    Iterator iter = msg.getParts().iterator();
                    if (iter.hasNext()) {
                        MessagePart part = (MessagePart)iter.next();
                        if (needName) {
                            name = part.getName();
                        }
                        String type = part.getType();
                        String element = part.getElement();
                        if (type != null && type.trim().length() != 0) {
                            xsdIdentifier = type;
                        } else if (element != null && element.trim().length() != 0) {
                            xsdIdentifier = element;
                        }
                    }
                }
            } else {
                Iterator mIter;
                msg = this.findMessage(object);
                if (msg != null && msg.getParts() != null && (mIter = msg.getParts().iterator()).hasNext()) {
                    MessagePart part = (MessagePart)mIter.next();
                    String type = part.getType();
                    String element = part.getElement();
                    if (type != null && type.trim().length() != 0) {
                        xsdIdentifier = type;
                    } else if (element != null && element.trim().length() != 0) {
                        xsdIdentifier = element;
                    }
                }
            }
            message.setName(name);
            if (xsdIdentifier != null && xsdIdentifier.trim().length() != 0 && (ident = this.parseIdentifier(xsdIdentifier)) != null && (schemas = BasicWebServiceGenerator.this.doFindSchemas(ident.uri)).size() > 0) {
                for (XSDSchema schema : schemas) {
                    if ("http://www.w3.org/2001/XMLSchema".equals(ident.uri) || "http://www.w3.org/2001/XMLSchema".equals(ident.uri) || "http://www.w3.org/2001/XMLSchema".equals(ident.uri)) {
                        XSDSimpleTypeDefinition st = schema.resolveSimpleTypeDefinition(ident.uri, ident.name);
                        if (st == null) continue;
                        message.setContentSimpleType(st);
                        continue;
                    }
                    XSDElementDeclaration ed = schema.resolveElementDeclaration(ident.uri, ident.name);
                    if (ed != null) {
                        message.setContentElement(ed);
                        continue;
                    }
                    XSDComplexTypeDefinition ct = schema.resolveComplexTypeDefinition(ident.uri, ident.name);
                    if (ct != null) {
                        message.setContentComplexType(ct);
                        continue;
                    }
                    XSDSimpleTypeDefinition st = schema.resolveSimpleTypeDefinition(ident.uri, ident.name);
                    if (st == null) continue;
                    message.setContentSimpleType(st);
                }
            }
            if ((desc = this.addDescription((WebServiceComponent)message, (Documented)object)) == null && msg == null) {
                msg = this.findMessage(object);
                desc = this.addDescription((WebServiceComponent)message, (Documented)msg);
            }
            return object;
        }
    }
}

