/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.panels;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.roles.ui.wizard.DataRoleWizard;
import org.teiid.designer.roles.ui.wizard.PermissionTreeProvider;
import org.teiid.designer.roles.ui.wizard.dialogs.AbstractAddOrEditTitleDialog;
import org.teiid.designer.roles.ui.wizard.panels.DataRolePanel;
import org.teiid.designer.ui.common.table.CheckBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.widget.MessageLabel;

public class RowBasedSecurityPanel
extends DataRolePanel {
    private static final char DELIM = '.';
    private static final char B_SLASH = '/';
    TableViewerBuilder tableBuilder;
    Button addButton;
    Button removeButton;
    Button editButton;
    PermissionTreeProvider permissionTreeProvider;

    public RowBasedSecurityPanel(Composite parent, DataRoleWizard wizard) {
        super(parent, wizard);
    }

    @Override
    void createControl() {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.getPrimaryPanel());
        GridDataFactory.fillDefaults().applyTo((Control)this.getPrimaryPanel());
        Composite thePanel = WidgetFactory.createPanel((Composite)this.getPrimaryPanel(), (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)thePanel);
        Text helpText = new Text(thePanel, 72);
        helpText.setBackground(thePanel.getBackground());
        helpText.setForeground(Display.getCurrent().getSystemColor(10));
        helpText.setText(Messages.rowBasedSecurityHelpText);
        this.tableBuilder = new TableViewerBuilder(this.getPrimaryPanel(), 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableBuilder.getTableViewer());
        this.tableBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List<Permission> permissions = RowBasedSecurityPanel.this.getWizard().getTreeProvider().getPermissionsWithRowBasedSecurity();
                if (permissions.isEmpty()) {
                    return new Object[0];
                }
                return permissions.toArray(new Permission[0]);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Permission perm1 = (Permission)e1;
                Permission perm2 = (Permission)e2;
                return super.compare(viewer, (Object)perm1.getTargetName(), (Object)perm2.getTargetName());
            }
        });
        TableViewerColumn column = this.tableBuilder.createColumn(16384, 40, 100, true);
        column.getColumn().setText(String.valueOf(Messages.name) + this.getSpaces(70));
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(0));
        column = this.tableBuilder.createColumn(16384, 30, 100, true);
        column.getColumn().setText(Messages.constraint);
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(1));
        column.setEditingSupport((EditingSupport)new ContraintEditingSupport((ColumnViewer)this.tableBuilder.getTableViewer()));
        column = this.tableBuilder.createColumn(16384, 30, 100, true);
        column.getColumn().setText(Messages.condition);
        column.setLabelProvider((CellLabelProvider)new PermissionLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ConditionEditingSupport((ColumnViewer)this.tableBuilder.getTableViewer()));
        this.tableBuilder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable = !RowBasedSecurityPanel.this.tableBuilder.getSelection().isEmpty();
                RowBasedSecurityPanel.this.editButton.setEnabled(enable);
                RowBasedSecurityPanel.this.removeButton.setEnabled(enable);
            }
        });
        this.tableBuilder.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RowBasedSecurityPanel.this.handleEdit();
            }
        });
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)this.getPrimaryPanel(), (int)0, (int)2, (int)1, (int)3);
        this.addButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addButton.setText(Messages.add);
        this.addButton.setToolTipText(Messages.addRowBasedSecurityTooltip);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RowBasedSecurityPanel.this.handleAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.editButton.setText(Messages.edit);
        this.editButton.setToolTipText(Messages.editRowBasedSecurityTooltip);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RowBasedSecurityPanel.this.handleEdit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removeButton.setText(Messages.remove);
        this.removeButton.setToolTipText(Messages.removeRowBasedSecurityTooltip);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RowBasedSecurityPanel.this.handleRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.setEnabled(false);
    }

    void handleAdd() {
        RowBasedSecurityDialog dialog = new RowBasedSecurityDialog(this.getPrimaryPanel().getShell(), Messages.addColumnRowBasedSecurityTitle, Messages.addColumnRowBasedSecurityMessage, null, false);
        if (dialog.open() == 0) {
            String condition = dialog.getCondition();
            boolean constraint = dialog.getConstraintValue();
            String targetName = dialog.getTargetName();
            this.getWizard().getTreeProvider().setRowsBasedSecurity(targetName, condition, constraint);
            this.getWizard().refreshAllTabs();
        }
    }

    void handleEdit() {
        Permission permission = this.getSelectedPermission();
        RowBasedSecurityDialog dialog = new RowBasedSecurityDialog(this.getPrimaryPanel().getShell(), Messages.editColumnRowBasedSecurityTitle, Messages.editColumnRowBasedSecurityTitle, permission, true);
        if (dialog.open() == 0) {
            String condition = dialog.getCondition();
            boolean constraint = dialog.getConstraintValue();
            String targetName = dialog.getTargetName();
            this.getWizard().getTreeProvider().setRowsBasedSecurity(targetName, condition, constraint);
            this.getWizard().refreshAllTabs();
        }
    }

    void handleRemove() {
        Permission selection = this.getSelectedPermission();
        assert (selection != null);
        this.getWizard().getTreeProvider().removeRowBasedSecurity(selection);
        this.getWizard().getTreeProvider().handlePermissionChanged(selection);
        this.getWizard().refreshAllTabs();
    }

    private Permission getSelectedPermission() {
        IStructuredSelection selection = (IStructuredSelection)this.tableBuilder.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (Permission)selection.getFirstElement();
    }

    @Override
    public void refresh() {
        this.tableBuilder.getTable().removeAll();
        for (Permission perm : this.getWizard().getTreeProvider().getPermissionsWithRowBasedSecurity()) {
            this.tableBuilder.add((Object)perm);
        }
        if (this.tableBuilder.getSelection().isEmpty()) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void handleInfoChanged() {
        this.refresh();
    }

    protected PermissionTreeProvider getPermissionTreeProvider() {
        if (this.permissionTreeProvider == null) {
            this.permissionTreeProvider = new PermissionTreeProvider();
        }
        return this.permissionTreeProvider;
    }

    class ConditionEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ConditionEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof Permission) {
                return ((Permission)element).getCondition();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof Permission) {
                String oldValue = ((Permission)element).getCondition();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((Permission)element).setCondition(newValue);
                    RowBasedSecurityPanel.this.tableBuilder.getTableViewer().refresh(element);
                    RowBasedSecurityPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ContraintEditingSupport
    extends CheckBoxEditingSupport {
        public ContraintEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setElementValue(Object element, Object newValue) {
            if (element instanceof Permission && newValue instanceof Boolean) {
                Permission perm = (Permission)element;
                if (perm.isConstraint()) {
                    perm.setConstraint(false);
                    RowBasedSecurityPanel.this.handleInfoChanged();
                } else {
                    perm.setConstraint(true);
                    RowBasedSecurityPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class PermissionLabelProvider
    extends ColumnLabelProvider {
        private final int columnID;

        public PermissionLabelProvider(int columnID) {
            this.columnID = columnID;
        }

        public String getText(Object element) {
            if (element instanceof Permission) {
                if (this.columnID == 0) {
                    return ((Permission)element).getTargetName();
                }
                if (this.columnID == 2) {
                    return ((Permission)element).getCondition();
                }
                if (this.columnID == 1) {
                    return Boolean.toString(((Permission)element).isConstraint());
                }
            }
            return super.getText(element);
        }
    }

    class RowBasedSecurityDialog
    extends AbstractAddOrEditTitleDialog {
        private String targetTableOrView;
        private Text targetTableOrViewText;
        private StyledTextEditor textEditor;
        private String conditionString;
        private boolean constraint;
        private Button constraintButton;
        private boolean isEdit;

        public RowBasedSecurityDialog(Shell parentShell, String title, String message, Permission permission, boolean okEnabled) {
            super(parentShell, title, message, okEnabled);
            this.constraint = true;
            if (permission != null && permission.getCondition() != null) {
                this.conditionString = permission.getCondition();
                this.isEdit = true;
                this.constraint = permission.isConstraint();
                this.targetTableOrView = permission.getTargetName();
            }
        }

        @Override
        public void createCustomArea(Composite outerPanel) {
            Composite innerPanel = new Composite(outerPanel, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(innerPanel);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)innerPanel);
            Label theLabel = WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.target);
            GridDataFactory.fillDefaults().align(1, 2).applyTo((Control)theLabel);
            this.targetTableOrViewText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (int)1, (String)"");
            if (this.isEdit) {
                this.targetTableOrViewText.setText(this.targetTableOrView);
                this.targetTableOrViewText.setEditable(false);
            }
            this.targetTableOrViewText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RowBasedSecurityDialog.this.handleInputChanged();
                }
            });
            this.targetTableOrViewText.setEditable(false);
            this.targetTableOrViewText.setBackground(innerPanel.getBackground());
            Button button = new Button(innerPanel, 8);
            button.setText(Messages.dotDotDot);
            button.setToolTipText(Messages.browseVdbForTarget);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RowBasedSecurityDialog.this.handleBrowseForTableOrView();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            button.setEnabled(!this.isEdit);
            this.constraintButton = new Button(innerPanel, 32);
            this.constraintButton.setText(Messages.constraint);
            if (this.isEdit) {
                this.constraintButton.setSelection(this.constraint);
            } else {
                this.constraintButton.setSelection(true);
            }
            this.constraintButton.setToolTipText(Messages.constraintButtonTooltip);
            this.constraintButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RowBasedSecurityDialog.this.handleInputChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Group group = WidgetFactory.createGroup((Composite)outerPanel, (String)Messages.condition, (int)768, (int)1);
            this.textEditor = new StyledTextEditor((Composite)group, 2882);
            GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.textEditor.getTextWidget());
            ((GridData)this.textEditor.getTextWidget().getLayoutData()).heightHint = 50;
            if (this.isEdit) {
                this.textEditor.setText(this.conditionString);
            } else {
                this.textEditor.setText("");
            }
            this.textEditor.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    RowBasedSecurityDialog.this.handleInputChanged();
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
        }

        public String getTargetName() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.targetTableOrView;
        }

        public String getCondition() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.conditionString;
        }

        public boolean getConstraintValue() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.constraint;
        }

        private void handleBrowseForTableOrView() {
            SelectTableOrViewDialog dialog = new SelectTableOrViewDialog(this.getShell());
            if (dialog.open() == 0) {
                this.targetTableOrView = dialog.getTargetName();
                if (this.targetTableOrView != null) {
                    this.targetTableOrViewText.setText(this.targetTableOrView);
                }
                this.handleInputChanged();
            }
        }

        @Override
        protected void handleInputChanged() {
            this.validate();
        }

        @Override
        protected void validate() {
            boolean enable = true;
            this.setErrorMessage(null);
            this.setMessage(Messages.clickOkToFinish);
            this.conditionString = this.textEditor.getText();
            this.targetTableOrView = this.targetTableOrViewText.getText();
            if (this.targetTableOrView == null || this.targetTableOrView.trim().isEmpty()) {
                enable = false;
                this.setErrorMessage(Messages.targetIsUndefined);
                this.getButton(0).setEnabled(enable);
                return;
            }
            if (this.conditionString == null || this.conditionString.trim().isEmpty()) {
                enable = false;
                this.setErrorMessage(Messages.conditionIsUndefined);
                this.getButton(0).setEnabled(enable);
                return;
            }
            this.getButton(0).setEnabled(enable);
        }
    }

    class SelectTableOrViewDialog
    extends ElementTreeSelectionDialog
    implements ISelectionChangedListener {
        private Text nameText;
        private String name;
        private MessageLabel statusMessageLabel;

        public SelectTableOrViewDialog(Shell parent) {
            super(parent, (ILabelProvider)RowBasedSecurityPanel.this.getPermissionTreeProvider(), (ITreeContentProvider)RowBasedSecurityPanel.this.getPermissionTreeProvider());
            this.setTitle(Messages.targetSelection);
            this.setMessage(Messages.selectTargetForCondition);
            this.setInput(RowBasedSecurityPanel.this.getWizard().getTempContainer());
            this.setAllowMultiple(false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            GridData panelData = new GridData(1808);
            panel.setLayoutData((Object)panelData);
            Group selectedGroup = WidgetFactory.createGroup((Composite)panel, (String)Messages.selectedTableViewOrProcedure, (int)768, (int)1, (int)2);
            this.nameText = WidgetFactory.createTextField((Composite)selectedGroup, (int)768, (String)Messages.undefined);
            GridData data = new GridData(768);
            data.heightHint = this.convertHeightInCharsToPixels(1);
            data.verticalAlignment = 2;
            this.nameText.setLayoutData((Object)data);
            this.nameText.setEditable(false);
            this.nameText.setBackground(panel.getBackground());
            this.nameText.setText(Messages.undefined);
            super.createDialogArea(panel);
            this.statusMessageLabel = new MessageLabel(panel);
            GridData statusData = new GridData(768);
            data.heightHint = this.convertHeightInCharsToPixels(1);
            this.statusMessageLabel.setLayoutData((Object)statusData);
            this.statusMessageLabel.setEnabled(false);
            this.statusMessageLabel.setText(Messages.undefined);
            this.getTreeViewer().expandToLevel(2);
            return panel;
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            TreeViewer viewer = super.createTreeViewer(parent);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            viewer.getTree().setEnabled(true);
            viewer.setSorter(new ViewerSorter());
            viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof EObject || element instanceof Resource;
                }
            }});
            viewer.setContentProvider((IContentProvider)RowBasedSecurityPanel.this.getPermissionTreeProvider());
            viewer.setLabelProvider((IBaseLabelProvider)RowBasedSecurityPanel.this.getPermissionTreeProvider());
            viewer.setInput((Object)RowBasedSecurityPanel.this.getWizard().getTempContainer());
            return viewer;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeSelection selection = (TreeSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.nameText.setText(Messages.undefined);
                this.name = null;
                this.updateOnSelection(null);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (this.isValidSelection(firstElement)) {
                EObject target = (EObject)selection.getFirstElement();
                this.name = this.getFullTargetName(target);
                this.nameText.setText(this.name);
            } else {
                this.nameText.setText(Messages.undefined);
                this.name = null;
            }
            this.updateOnSelection(firstElement);
        }

        private String getFullTargetName(EObject target) {
            String targetName = String.valueOf(this.getResourceName(target.eResource())) + '/' + ModelerCore.getModelEditor().getModelRelativePath(target);
            targetName = targetName.replace('/', '.');
            return targetName;
        }

        private String getResourceName(Resource res) {
            if (res.getURI().path().endsWith(".xmi")) {
                Path path = new Path(res.getURI().path());
                return path.removeFileExtension().lastSegment();
            }
            return res.getURI().path();
        }

        private boolean isValidSelection(Object obj) {
            return obj instanceof Table || obj instanceof View || obj instanceof Procedure || obj instanceof Column;
        }

        private void updateOnSelection(Object selectedObject) {
            Status status = new Status(1, RolesUiPlugin.PLUGIN_ID, Messages.rowBasedSecurityOkMessage);
            if (selectedObject != null) {
                if (!this.isValidSelection(selectedObject)) {
                    status = new Status(4, RolesUiPlugin.PLUGIN_ID, Messages.invalidSelectionRowBasedSecurityMessage);
                    this.getOkButton().setEnabled(false);
                } else {
                    this.getOkButton().setEnabled(true);
                }
            } else {
                status = new Status(4, RolesUiPlugin.PLUGIN_ID, Messages.noTargetSelected);
                this.getOkButton().setEnabled(false);
            }
            this.statusMessageLabel.setErrorStatus((IStatus)status);
        }

        public String getTargetName() {
            return this.name;
        }
    }
}

