/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard.dialogs;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.roles.ui.Messages;
import org.teiid.designer.roles.ui.wizard.dialogs.AbstractAddOrEditTitleDialog;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;

public class RowBasedSecurityDialog
extends AbstractAddOrEditTitleDialog {
    private String targetName;
    private Text targetNameText;
    private StyledTextEditor conditionTextEditor;
    private String conditionString;
    private boolean constraint = true;
    private Button constraintButton;
    private boolean isEdit;

    public RowBasedSecurityDialog(Shell parentShell, String title, String message, Permission permission, boolean existingSecurity) {
        super(parentShell, Messages.rowFilterDialogTitle, Messages.setConditionForTargetsMessage, existingSecurity);
        this.targetName = permission.getTargetName();
        this.isEdit = true;
        if (permission.getCondition() != null) {
            this.conditionString = permission.getCondition();
            this.constraint = permission.isConstraint();
        }
    }

    @Override
    public void createCustomArea(Composite outerPanel) {
        Composite innerPanel = new Composite(outerPanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(innerPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)innerPanel);
        WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.target);
        this.targetNameText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (int)1, (String)"");
        if (this.isEdit) {
            this.targetNameText.setText(this.targetName);
        }
        this.targetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RowBasedSecurityDialog.this.handleInputChanged();
            }
        });
        this.targetNameText.setEditable(false);
        this.targetNameText.setBackground(innerPanel.getBackground());
        Label label = WidgetFactory.createLabel((Composite)innerPanel, (String)Messages.constraint);
        label.setToolTipText(Messages.constraintButtonTooltip);
        this.constraintButton = new Button(innerPanel, 32);
        if (this.isEdit) {
            this.constraintButton.setSelection(this.constraint);
        } else {
            this.constraintButton.setSelection(true);
        }
        this.constraintButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RowBasedSecurityDialog.this.handleInputChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group group = WidgetFactory.createGroup((Composite)innerPanel, (String)Messages.condition, (int)768, (int)2);
        this.conditionTextEditor = new StyledTextEditor((Composite)group, 2882);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.conditionTextEditor.getTextWidget());
        ((GridData)this.conditionTextEditor.getTextWidget().getLayoutData()).heightHint = 50;
        if (this.isEdit) {
            this.conditionTextEditor.setText(this.conditionString);
        } else {
            this.conditionTextEditor.setText("");
        }
        this.conditionTextEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                RowBasedSecurityDialog.this.handleInputChanged();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public String getTargetName() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.targetName;
    }

    public String getCondition() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.conditionString;
    }

    public boolean getConstraintValue() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.constraint;
    }

    @Override
    protected void handleInputChanged() {
        this.validate();
    }

    public boolean hasCondition() {
        return this.getCondition() != null && !this.getCondition().isEmpty();
    }

    @Override
    protected void validate() {
        boolean conditionEmpty;
        boolean enable = true;
        this.setErrorMessage(null);
        this.setMessage(Messages.clickOkToFinish);
        this.conditionString = this.conditionTextEditor.getText();
        this.constraint = this.constraintButton.getSelection();
        boolean bl = conditionEmpty = this.conditionString == null || this.conditionString.trim().isEmpty();
        if (conditionEmpty) {
            enable = false;
            this.setErrorMessage(Messages.conditionIsUndefined);
        }
        this.getButton(0).setEnabled(enable);
    }
}

