/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.roles.ui.RolesUiPlugin;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PermissionTreeProvider
implements ILabelProvider,
ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private ITreeContentProvider modelProvider = ModelUtilities.getModelContentProvider();
    private Resource[] resources;

    public Image getImage(Object element) {
        if (element instanceof EObject) {
            return ModelUtilities.getEMFLabelProvider().getImage(element);
        }
        if (element instanceof Resource) {
            try {
                EObject firstEObj = (EObject)((Resource)element).getContents().get(0);
                ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
                ModelType mType = ma.getModelType();
                if (ModelType.PHYSICAL_LITERAL == mType) {
                    return ModelIdentifier.getImage((int)0);
                }
                if (ModelIdentifier.isFunctionModelUri((String)ma.getPrimaryMetamodelUri())) {
                    return ModelIdentifier.getImage((int)2);
                }
                if (ModelIdentifier.isXmlViewModel((String)ma.getPrimaryMetamodelUri())) {
                    return ModelIdentifier.getImage((int)5);
                }
                if (ModelIdentifier.isWebServicesViewModel((String)ma.getPrimaryMetamodelUri())) {
                    return ModelIdentifier.getImage((int)6);
                }
                return ModelIdentifier.getImage((int)4);
            }
            catch (ModelerCoreException e) {
                RolesUiPlugin.UTIL.log(4, RolesUiPlugin.UTIL.getString("errorFindingImageForObject", new Object[]{element, e}));
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof EObject) {
            ILabelProvider p = ModelUtilities.getEMFLabelProvider();
            return p.getText(element);
        }
        if (element instanceof Resource) {
            return ((Resource)element).getURI().lastSegment();
        }
        return "";
    }

    private Object[] getFilteredModelContents(List<EObject> eObjs) {
        ArrayList<EObject> relObjects = new ArrayList<EObject>();
        for (EObject eObj : eObjs) {
            if (!(eObj instanceof Table) && !(eObj instanceof View) && !(eObj instanceof Procedure) && !(eObj instanceof ProcedureResult) && !(eObj instanceof Schema) && !(eObj instanceof Catalog) && !(eObj instanceof Column) && !(eObj instanceof ProcedureParameter) && !(eObj instanceof Interface) && !(eObj instanceof Operation) && !(eObj instanceof XmlDocument) && !(eObj instanceof ScalarFunction)) continue;
            relObjects.add(eObj);
        }
        return relObjects.toArray();
    }

    private Object[] getFilteredModelContents(Object[] eObjs) {
        ArrayList<EObject> relObjects = new ArrayList<EObject>();
        Object[] objectArray = eObjs;
        int n = eObjs.length;
        int n2 = 0;
        while (n2 < n) {
            Object eObj = objectArray[n2];
            if (eObj instanceof Table || eObj instanceof View || eObj instanceof Procedure || eObj instanceof ProcedureResult || eObj instanceof Schema || eObj instanceof Catalog || eObj instanceof Column || eObj instanceof ProcedureParameter || eObj instanceof Interface || eObj instanceof Operation || eObj instanceof XmlDocument) {
                relObjects.add((EObject)eObj);
            }
            ++n2;
        }
        return relObjects.toArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.resources == null) {
            EList allVdbResources = ((ContainerImpl)inputElement).getResources();
            ArrayList<Resource> filteredResources = new ArrayList<Resource>();
            for (Resource res : allVdbResources) {
                if (res.getURI().toFileString().toUpperCase().endsWith(".XSD")) continue;
                filteredResources.add(res);
            }
            this.resources = filteredResources.toArray(new Resource[0]);
        }
        return this.resources;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        if (parentElement instanceof EObject) {
            children = this.getFilteredModelContents(this.modelProvider.getChildren(parentElement));
        } else if (parentElement instanceof Resource) {
            children = this.getFilteredModelContents((List<EObject>)((Resource)parentElement).getContents());
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ModelUtilities.getModelContentProvider().getParent(element);
        }
        if (element instanceof Resource) {
            return ((Resource)element).getResourceSet();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

