/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionValidator;
import org.teiid.designer.extension.definition.ValidationStatus;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class NewMedDetailsPage
extends AbstractWizardPage {
    private static final int COLUMN_COUNT = 2;
    private static final String DEFAULT_METAMODEL_NAME = "Relational";
    private static final String DEFAULT_VERSION = "1";
    private static final String TOKEN_ERROR = "[Error] ";
    private static final String TOKEN_WARNING = "[Warning] ";
    private static final String TOKEN_INFO = "[Info] ";
    private static final String CR = "\n";
    private Text namespacePrefixText;
    private Text namespaceUriText;
    private Text versionText;
    private Text descriptionText;
    private Text statusTextBox;
    private Combo cbxMetamodelUris;
    private TableViewer modelTypesViewer;
    private Set<String> supportedModelTypes = new HashSet<String>();
    private ModelExtensionDefinition initialMed;
    private static final String[] MODEL_TYPES = new String[]{"PHYSICAL", "VIRTUAL"};

    public NewMedDetailsPage(ModelExtensionDefinition initialMed) {
        super(NewMedDetailsPage.class.getSimpleName(), Messages.newMedDetailsPageTitle);
        this.initialMed = initialMed;
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)pnlMain);
        this.createMainPanel(pnlMain);
        this.validatePage();
    }

    private Composite createMainPanel(Composite parent) {
        String nsPrefix = null;
        String nsUri = null;
        String extendedMetaclass = null;
        int version = 1;
        String description = null;
        boolean copyMode = false;
        if (this.initialMed != null) {
            copyMode = true;
            nsPrefix = this.initialMed.getNamespacePrefix();
            nsUri = this.initialMed.getNamespaceUri();
            extendedMetaclass = this.initialMed.getMetamodelUri();
            version = this.initialMed.getVersion();
            description = this.initialMed.getDescription();
        }
        WidgetFactory.createLabel((Composite)parent, (String)Messages.namespacePrefixLabel);
        this.namespacePrefixText = WidgetFactory.createTextField((Composite)parent, (int)768, (int)1);
        this.namespacePrefixText.setToolTipText(Messages.medNamespacePrefixTooltip);
        if (nsPrefix != null) {
            this.namespacePrefixText.setText(nsPrefix);
        }
        this.namespacePrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewMedDetailsPage.this.nsPrefixModified();
            }
        });
        WidgetFactory.createLabel((Composite)parent, (String)Messages.namespaceUriLabel);
        this.namespaceUriText = WidgetFactory.createTextField((Composite)parent, (int)256, (int)1);
        this.namespaceUriText.setToolTipText(Messages.medNamespaceUriTooltip);
        if (nsUri != null) {
            this.namespaceUriText.setText(nsUri);
        }
        this.namespaceUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewMedDetailsPage.this.nsUriModified();
            }
        });
        WidgetFactory.createLabel((Composite)parent, (String)Messages.extendedMetamodelUriLabel);
        this.cbxMetamodelUris = WidgetFactory.createCombo((Composite)parent, (int)8, (int)256, (int)1);
        this.cbxMetamodelUris.setToolTipText(Messages.medMetamodelClassTooltip);
        Set<String> metamodelNames = Activator.getDefault().getExtendableMetamodelNames();
        this.cbxMetamodelUris.setItems(metamodelNames.toArray(new String[metamodelNames.size()]));
        int mmIndx = this.cbxMetamodelUris.indexOf(DEFAULT_METAMODEL_NAME);
        if (extendedMetaclass != null && extendedMetaclass.trim().length() > 0) {
            String mmName = Activator.getDefault().getMetamodelName(extendedMetaclass);
            mmIndx = this.cbxMetamodelUris.indexOf(mmName);
        }
        this.cbxMetamodelUris.select(mmIndx);
        if (copyMode) {
            this.cbxMetamodelUris.setEnabled(false);
        }
        this.cbxMetamodelUris.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewMedDetailsPage.this.handleMetamodelUriChanged();
            }
        });
        WidgetFactory.createLabel((Composite)parent, (String)Messages.modelTypesLabel);
        this.modelTypesViewer = WidgetFactory.createTableViewer((Composite)parent, (int)2818);
        this.modelTypesViewer.getTable().setToolTipText(Messages.medModelTypesToolTip);
        ((GridData)this.modelTypesViewer.getTable().getLayoutData()).heightHint = this.modelTypesViewer.getTable().getItemHeight() * 3;
        this.modelTypesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return NewMedDetailsPage.this.getAvailableModelTypes();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.modelTypesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String modelType = (String)element;
                return Activator.getDefault().getModelTypeName(modelType);
            }
        });
        this.modelTypesViewer.setInput((Object)this);
        this.setModelTypeSelections();
        if (copyMode) {
            this.modelTypesViewer.getTable().setEnabled(false);
        }
        this.modelTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewMedDetailsPage.this.handleModelTypeSelected();
            }
        });
        WidgetFactory.createLabel((Composite)parent, (String)Messages.versionLabel);
        this.versionText = WidgetFactory.createTextField((Composite)parent, (int)256, (int)1, (String)DEFAULT_VERSION, (int)8);
        this.versionText.setToolTipText(Messages.medVersionTooltip);
        if (version != -1) {
            this.versionText.setText(Integer.toString(version));
        }
        this.versionText.setText(DEFAULT_VERSION);
        this.versionText.setBackground(parent.getBackground());
        if (copyMode) {
            this.versionText.setEnabled(false);
        }
        WidgetFactory.createLabel((Composite)parent, (String)Messages.descriptionLabel);
        this.descriptionText = WidgetFactory.createTextField((Composite)parent, (int)256, (int)1);
        this.descriptionText.setToolTipText(Messages.medDescriptionToolTip);
        if (description != null) {
            this.descriptionText.setText(description);
        }
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewMedDetailsPage.this.descriptionModified();
            }
        });
        WidgetFactory.createLabel((Composite)parent, (int)256, (int)2, (String)Messages.newMedDetailsPageStatusLabel);
        this.statusTextBox = WidgetFactory.createTextField((Composite)parent, (int)1808, (int)2, null, (int)2306);
        this.namespacePrefixText.setFocus();
        return parent;
    }

    private void setModelTypeSelections() {
        if (this.initialMed != null) {
            this.supportedModelTypes = new HashSet<String>(this.initialMed.getSupportedModelTypes());
            if (this.supportedModelTypes.isEmpty()) {
                this.modelTypesViewer.getTable().selectAll();
            } else {
                this.modelTypesViewer.setSelection((ISelection)new StructuredSelection(this.supportedModelTypes.toArray()), true);
            }
        } else {
            this.modelTypesViewer.getTable().selectAll();
        }
    }

    private Object[] getAvailableModelTypes() {
        String mmUri = null;
        if (this.initialMed != null) {
            mmUri = this.initialMed.getMetamodelUri();
        } else {
            String mmName = this.cbxMetamodelUris.getText();
            mmUri = Activator.getDefault().getMetamodelUri(mmName);
        }
        if (CoreStringUtil.isEmpty((String)mmUri)) {
            return CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
        }
        return Activator.getDefault().getModelTypes(mmUri).toArray();
    }

    public static Set<String> getDefaultModelTypes() {
        HashSet<String> modelTypes = new HashSet<String>(MODEL_TYPES.length);
        String[] stringArray = MODEL_TYPES;
        int n = MODEL_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String modelType = stringArray[n2];
            modelTypes.add(modelType);
            ++n2;
        }
        return modelTypes;
    }

    void handleModelTypeSelected() {
        this.supportedModelTypes.clear();
        IStructuredSelection selection = (IStructuredSelection)this.modelTypesViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedModelType = objectArray[n2];
            this.supportedModelTypes.add((String)selectedModelType);
            ++n2;
        }
        this.validatePage();
    }

    private void nsPrefixModified() {
        this.validatePage();
    }

    private void nsUriModified() {
        this.validatePage();
    }

    private void handleMetamodelUriChanged() {
        this.modelTypesViewer.refresh();
        this.setModelTypeSelections();
        this.validatePage();
    }

    private void descriptionModified() {
        this.validatePage();
    }

    public String getNamespacePrefix() {
        return this.namespacePrefixText.getText();
    }

    public String getNamespaceUri() {
        return this.namespaceUriText.getText();
    }

    public String getMetamodelUri() {
        String metamodelName = this.cbxMetamodelUris.getText();
        return Activator.getDefault().getMetamodelUri(metamodelName);
    }

    public String getVersion() {
        return this.versionText.getText();
    }

    public int getVersionInt() {
        int versionInt = 1;
        try {
            versionInt = Integer.parseInt(this.versionText.getText());
        }
        catch (Exception exception) {}
        return versionInt;
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public Collection<String> getSupportedModelTypes() {
        return this.supportedModelTypes;
    }

    private void validatePage() {
        MedStatus nsPrefixStatus = ModelExtensionDefinitionValidator.validateNamespacePrefix((String)this.getNamespacePrefix(), (Collection)this.getRegistry().getAllNamespacePrefixes());
        MedStatus nsUriStatus = ModelExtensionDefinitionValidator.validateNamespaceUri((String)this.getNamespaceUri(), (Collection)this.getRegistry().getAllNamespaceUris());
        MedStatus metaModelUriStatus = ModelExtensionDefinitionValidator.validateMetamodelUri((String)this.getMetamodelUri(), (Collection)this.getRegistry().getExtendableMetamodelUris());
        MedStatus definitionStatus = ModelExtensionDefinitionValidator.validateDescription((String)this.getDescription());
        ValidationStatus versionStatus = ModelExtensionDefinitionValidator.validateVersion((String)this.getVersion());
        MedStatus modelTypeStatus = ModelExtensionDefinitionValidator.validateModelTypes(this.supportedModelTypes, NewMedDetailsPage.getDefaultModelTypes());
        StringBuffer sb = new StringBuffer();
        this.addStatusMessage(sb, nsPrefixStatus);
        this.addStatusMessage(sb, nsUriStatus);
        this.addStatusMessage(sb, metaModelUriStatus);
        this.addStatusMessage(sb, (MedStatus)versionStatus);
        this.addStatusMessage(sb, definitionStatus);
        this.addStatusMessage(sb, modelTypeStatus);
        this.statusTextBox.setText(sb.toString());
        this.setMessage(Messages.newMedDetailsPageMsg);
        this.setPageComplete(true);
    }

    private void addStatusMessage(StringBuffer sb, MedStatus status) {
        if (status.isError()) {
            sb.append(TOKEN_ERROR + status.getMessage() + CR);
        } else if (status.isWarning()) {
            sb.append(TOKEN_WARNING + status.getMessage() + CR);
        } else if (status.isInfo()) {
            sb.append(TOKEN_INFO + status.getMessage() + CR);
        }
    }

    protected ModelExtensionRegistry getRegistry() {
        return ExtensionPlugin.getInstance().getRegistry();
    }
}

