/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.xslt;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.xslt.CoreXsltPlugin;
import org.teiid.designer.core.xslt.Style;

public class XsltTransform {
    private final Style style;

    public XsltTransform(Style style) {
        CoreArgCheck.isNotNull((Object)style);
        this.style = style;
    }

    protected static Templates getTemplates(Style style) throws IOException, TeiidDesignerException, TransformerConfigurationException {
        CoreArgCheck.isNotNull((Object)style);
        StreamSource source = style.getStreamSource();
        Templates templates = CoreXsltPlugin.createFactory().newTemplates(source);
        if (templates == null) {
            throw new TransformerConfigurationException(CoreXsltPlugin.Util.getString("XsltTransform.TransformerFactory_created_a_null_Templates_object", new Object[0]));
        }
        return templates;
    }

    protected Transformer createTransformer() throws TeiidDesignerException, TransformerConfigurationException, IOException {
        Templates templates = XsltTransform.getTemplates(this.style);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public void transform(Document sourceDoc, OutputStream output) throws IOException, TeiidDesignerException, TransformerException, TransformerConfigurationException {
        CoreArgCheck.isNotNull((Object)sourceDoc);
        CoreArgCheck.isNotNull((Object)output);
        Source source = CoreXsltPlugin.createSource(sourceDoc);
        StreamResult result = new StreamResult(output);
        Transformer transformer = this.createTransformer();
        try {
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            String msg = CoreXsltPlugin.Util.getString("XsltTransform.Error_applying_the_XSLT_transform", new Object[0]);
            throw new TeiidDesignerException(e, msg);
        }
    }
}

