/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.ModelerXsdUiPlugin;
import org.teiid.designer.xsd.ui.wizards.XsdFileSystemImportMainPage;
import org.teiid.designer.xsd.ui.wizards.XsdImportMainPage;
import org.teiid.designer.xsd.ui.wizards.XsdUrlImportMainPage;

public class XsdFileSystemImportWizard
extends AbstractWizard
implements IImportWizard,
ModelerXsdUiConstants,
IPropertiesContext {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(XsdFileSystemImportWizard.class);
    private static final String TITLE = XsdFileSystemImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = ModelerXsdUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/import_xsd.gif");
    private static final String NOT_LICENSED_MSG = XsdFileSystemImportWizard.getString("notLicensedMessage");
    private static boolean importLicensed = true;
    private XsdFileSystemImportMainPage importFromFileMainPage;
    private XsdUrlImportMainPage importFromUrlMainPage;
    private XsdImportMainPage importMainPage;
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private boolean openProjectExists;
    private IProject newProject;
    Properties designerProperties;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public XsdFileSystemImportWizard() {
        super((AbstractUIPlugin)ModelerXsdUiPlugin.getDefault(), TITLE, IMAGE);
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            super.createPageControls(pageContainer);
            this.updateForProperties();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        if (!ModelerUiViewUtils.workspaceHasOpenModelProjects()) {
            this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (this.newProject != null) {
                this.selection = new StructuredSelection((Object)this.newProject);
                this.openProjectExists = true;
            } else {
                this.openProjectExists = false;
            }
        }
        if (importLicensed) {
            this.importMainPage = new XsdImportMainPage();
            this.importFromFileMainPage = this.createFileMainPage(this.selection);
            this.importFromUrlMainPage = this.createUrlMainPage(this.selection);
            this.addPage((IWizardPage)this.importMainPage);
            this.addPage((IWizardPage)this.importFromFileMainPage);
        } else {
            WizardPage page = new WizardPage(XsdFileSystemImportWizard.class.getSimpleName(), TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)XsdFileSystemImportWizard.this.createEmptyPageControl(parent));
                }
            };
            page.setMessage(NOT_LICENSED_MSG, 3);
            page.setPageComplete(false);
            this.addPage((IWizardPage)page);
        }
        this.setNeedsProgressMonitor(true);
    }

    protected XsdFileSystemImportMainPage createFileMainPage(IStructuredSelection selection) {
        return new XsdFileSystemImportMainPage(this.workbench, selection);
    }

    protected XsdUrlImportMainPage createUrlMainPage(IStructuredSelection selection) {
        return new XsdUrlImportMainPage(this.workbench, selection);
    }

    public boolean finish() {
        boolean result = true;
        if (this.importMainPage.isImportFromUrl()) {
            this.importFromUrlMainPage.finish();
        } else {
            this.importFromFileMainPage.finish();
        }
        return result;
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public void dispose() {
        super.dispose();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.importMainPage.isImportFromUrl()) {
            this.removePage((IWizardPage)this.importFromFileMainPage);
            if (this.indexOf((IWizardPage)this.importFromUrlMainPage) == -1) {
                this.addPage((IWizardPage)this.importFromUrlMainPage);
            }
        } else {
            this.removePage((IWizardPage)this.importFromUrlMainPage);
            if (this.indexOf((IWizardPage)this.importFromFileMainPage) == -1) {
                this.addPage((IWizardPage)this.importFromFileMainPage);
            }
        }
        return super.getNextPage(page);
    }

    public void setProperties(Properties properties) {
        this.designerProperties = properties;
    }

    private void updateForProperties() {
        if (this.newProject != null && this.designerProperties != null) {
            if (this.openProjectExists) {
                DesignerPropertiesUtil.setProjectName((Properties)this.designerProperties, (String)this.newProject.getName());
            }
        } else if (this.designerProperties != null) {
            DesignerPropertiesUtil.setProjectStatus((Properties)this.designerProperties, (String)"noOpenProject");
        }
    }
}

