/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.wizards;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.wizards.XsdFileSystemImportUtil;
import org.teiid.designer.xsd.ui.wizards.XsdFileSystemStructureProvider;

public class XsdFileSystemImportMainPage
extends WizardFileSystemResourceImportPage1 {
    protected Button addDependentXsdsCheckbox;
    private static final String I18N_PREFIX = "XsdFileSystemImportMainPage";
    private static final String SEPARATOR = ".";
    private static final String STORE_SOURCE_NAMES_ID = XsdFileSystemImportMainPage.getString("storeSourceNamesId");
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = XsdFileSystemImportMainPage.getString("storeOverwriteExistingResourcesId");
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = XsdFileSystemImportMainPage.getString("storeCreateContainerStructureId");
    private static final String ADD_DEPENDENT_XSD_FILES_ID = XsdFileSystemImportMainPage.getString("addDependentXsdFilesId");
    private static final String NO_RESOURCES_SELECTED_MESSAGE = XsdFileSystemImportMainPage.getString("noResourcesSelectedMethod");
    private static final boolean allowEditLocation = ProductCustomizerMgr.getInstance().getProductCharacteristics().workspaceLocationExposed();
    private boolean okToOverwriteTarget = false;
    private static final int TP_PRE_362 = 0;
    private static final int TP_362 = 1;
    private static int targetPlatform = -1;

    private static boolean isPre362() {
        if (targetPlatform == -1) {
            try {
                Class superClass = XsdFileSystemImportMainPage.class.getSuperclass();
                superClass.getDeclaredField("createContainerStructureButton");
                targetPlatform = 0;
            }
            catch (Throwable throwable) {
                targetPlatform = 1;
            }
        }
        return targetPlatform == 0;
    }

    private static String getString(String id) {
        return ModelerXsdUiConstants.Util.getString("XsdFileSystemImportMainPage." + id, new Object[0]);
    }

    public XsdFileSystemImportMainPage(IWorkbench theWorkbench, IStructuredSelection theSelection) {
        super(theWorkbench, theSelection);
    }

    private Field getField(String name) throws Throwable {
        Class superClass = XsdFileSystemImportMainPage.class.getSuperclass();
        return superClass.getDeclaredField(name);
    }

    private boolean isSelected(String buttonName) {
        try {
            Field buttonField = this.getField(buttonName);
            return (Boolean)buttonField.getType().getMethod("getSelection", new Class[0]).invoke(buttonField.get((Object)this), new Object[0]);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void setEnabled(String buttonName, boolean enable) {
        try {
            Field buttonField = this.getField(buttonName);
            buttonField.getType().getMethod("setEnabled", Boolean.TYPE).invoke(buttonField.get((Object)this), enable);
        }
        catch (Throwable throwable) {}
    }

    private void setSelection(String buttonName, boolean selected) {
        try {
            Field buttonField = this.getField(buttonName);
            buttonField.getType().getMethod("setSelection", Boolean.TYPE).invoke(buttonField.get((Object)this), selected);
        }
        catch (Throwable throwable) {}
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    return element.getFiles((IImportStructureProvider)XsdFileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, XsdFileSystemStructureProvider.INSTANCE);
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (resourcesEnum.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        boolean createContainer = XsdFileSystemImportMainPage.isPre362() ? this.isSelected("createContainerStructureButton") : this.isSelected("createTopLevelFolderCheckbox");
        this.resetOKToOverwriteTarget();
        return XsdFileSystemImportUtil.importXsds(fileSystemObjects, this.addDependentXsdsCheckbox.getSelection(), this.getContainerFullPath(), this.getContainer(), (IOverwriteQuery)this, createContainer, this.overwriteExistingResourcesCheckbox.getSelection());
    }

    private void resetOKToOverwriteTarget() {
        this.okToOverwriteTarget = false;
        if (this.overwriteExistingResourcesCheckbox.getSelection()) {
            this.okToOverwriteTarget = true;
        } else {
            IPath path = this.getContainerFullPath();
            IWorkspaceRoot root = ModelerCore.getWorkspace().getRoot();
            IResource theResource = root.findMember(path);
            if (theResource != null && theResource instanceof IContainer) {
                IResource[] containedResources = null;
                try {
                    containedResources = ((IContainer)theResource).members();
                }
                catch (CoreException coreException) {}
                if (containedResources != null && containedResources.length == 0) {
                    this.okToOverwriteTarget = true;
                }
            }
        }
    }

    public String queryOverwrite(String pathString) {
        if (this.okToOverwriteTarget) {
            return "YES";
        }
        return super.queryOverwrite(pathString);
    }

    public void createControl(Composite theParent) {
        super.createControl(theParent);
        if (!allowEditLocation) {
            IProject proj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject();
            String path = proj.getFullPath().toPortableString();
            this.setContainerFieldValue(path);
        }
        if (XsdFileSystemImportMainPage.isPre362()) {
            this.setEnabled("createContainerStructureButton", false);
            this.setEnabled("createOnlySelectedButton", false);
        } else {
            this.setEnabled("createTopLevelFolderCheckbox", false);
        }
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        super.createOptionsGroupButtons(optionsGroup);
        this.addDependentXsdsCheckbox = new Button((Composite)optionsGroup, 32);
        this.addDependentXsdsCheckbox.setFont(optionsGroup.getFont());
        this.addDependentXsdsCheckbox.setText(XsdFileSystemImportMainPage.getString("addDependentXsdFiles.text"));
        this.addDependentXsdsCheckbox.setSelection(true);
    }

    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(WizardFileSystemResourceImportPage1.SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        if (this.getSelectedResources().isEmpty()) {
            this.setErrorMessage(NO_RESOURCES_SELECTED_MESSAGE);
            return false;
        }
        if (this.getContainerFullPath() == null || this.getResourcePath().segmentCount() == 0) {
            this.setErrorMessage(XsdFileSystemImportMainPage.getString("missingTargetLocation"));
        }
        this.enableButtonGroup(true);
        return true;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
            boolean createStructure = settings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID);
            if (XsdFileSystemImportMainPage.isPre362()) {
                this.setSelection("createContainerStructureButton", createStructure);
                this.setSelection("createOnlySelectedButton", !createStructure);
            } else {
                this.setSelection("createTopLevelFolderCheckbox", createStructure);
                this.setEnabled("createTopLevelFolderCheckbox", true);
            }
            boolean addDependencies = settings.getBoolean(ADD_DEPENDENT_XSD_FILES_ID);
            this.addDependentXsdsCheckbox.setSelection(addDependencies);
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            WidgetUtil.saveSettings((IDialogSettings)this.getDialogSettings(), (String)STORE_SOURCE_NAMES_ID, (Combo)this.sourceNameField, (int)10);
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            if (XsdFileSystemImportMainPage.isPre362()) {
                settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.isSelected("createContainerStructureButton"));
            } else {
                settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.isSelected("createTopLevelFolderCheckbox"));
            }
            settings.put(ADD_DEPENDENT_XSD_FILES_ID, this.addDependentXsdsCheckbox.getSelection());
        }
    }

    protected String getSourceDirectoryName() {
        String sName = this.sourceNameField.getText();
        Path result = new Path(sName);
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }
}

