/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.FormTextObjectEditor;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.ui.forms.SimpleComponentSet;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.editor.FacetSet;
import org.teiid.designer.xsd.ui.editor.FacetValue;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;

public abstract class AbstractFacetSet
extends SimpleComponentSet
implements FacetSet {
    private static final String LABEL_DEFAULT = GUIFacetHelper.getString("AbstractFacetSet.facetbutton.default");
    private static final String LABEL_FIXED = GUIFacetHelper.getString("AbstractFacetSet.facetbutton.fixed");
    static final String FORM_INHERIT_FROM = GUIFacetHelper.getString("AbstractFacetSet.formInheritFromText");
    static final String FORM_FIXED_BY = GUIFacetHelper.getString("AbstractFacetSet.formFixedByText");
    protected static final String FORM_OVERRIDES = GUIFacetHelper.getString("AbstractFacetSet.formOverrides");
    private FacetValue currentFV;
    private final boolean needsFixed;
    private final boolean needsDescription;
    private int controlCount;
    Button fixed;
    Button dft;
    FormTextObjectEditor desc;
    private FormTextObjectEditor inherit;
    MyListener myList;
    private boolean enabled;

    public AbstractFacetSet(String id, String labelName, boolean needsFixed, boolean needsDescription) {
        super(id, labelName);
        this.needsFixed = needsFixed;
        this.needsDescription = needsDescription;
        this.controlCount = 4;
        if (needsFixed) {
            ++this.controlCount;
        }
        if (needsDescription) {
            ++this.controlCount;
        }
    }

    protected abstract void addMainControl(Composite var1, FormToolkit var2, ComponentSetMonitor var3);

    protected abstract void setMainValue(Object var1);

    protected final void addControls(Composite parent, FormToolkit ftk) {
        TableWrapData twd;
        this.init();
        this.addMainControl(parent, ftk, this.myList);
        if (this.needsFixed) {
            this.fixed = ftk.createButton(parent, LABEL_FIXED, 32);
            this.fixed.addSelectionListener((SelectionListener)this.myList);
        }
        this.dft = ftk.createButton(parent, LABEL_DEFAULT, 32);
        this.dft.addSelectionListener((SelectionListener)this.myList);
        this.dft.setSelection(true);
        if (this.needsDescription) {
            this.desc = new FormTextObjectEditor(GUIFacetHelper.FORM_DESCRIPTION_ADD, GUIFacetHelper.FORM_CHANGE, false){

                protected Object changeValue(Object startingValue) {
                    String description = (String)startingValue;
                    String dialogTitle = GUIFacetHelper.getString("AbstractFacetSet.descriptionTitle");
                    String dialogText = ModelerXsdUiConstants.Util.getString("AbstractFacetSet.descriptionText", (Object)AbstractFacetSet.this.getLabelText());
                    InputDialog idlg = new InputDialog(AbstractFacetSet.this.desc.getFormText().getShell(), dialogTitle, dialogText, description, null);
                    idlg.setBlockOnOpen(true);
                    idlg.open();
                    String newDesc = idlg.getValue();
                    if (newDesc != null) {
                        if (newDesc.length() == 0) {
                            newDesc = null;
                        }
                        if (!FormUtil.safeEquals((String)description, (String)newDesc, (boolean)true)) {
                            AbstractFacetSet.this.getCurrentFacetValue().description = newDesc;
                            AbstractFacetSet.this.updateDescription(AbstractFacetSet.this.getCurrentFacetValue());
                            AbstractFacetSet.this.myList.fireUpdate(false);
                            AbstractFacetSet.this.updateDefault();
                            return newDesc;
                        }
                    }
                    return description;
                }
            };
            this.desc.addControl(FormUtil.getScrolledForm((Control)parent), parent, ftk);
            this.desc.setValue((Object)this.currentFV.description);
            twd = new TableWrapData(256, 16);
            this.desc.getFormText().setLayoutData((Object)twd);
        }
        this.inherit = new FormTextObjectEditor(null, null, true){

            protected Object changeValue(Object startingValue) {
                return null;
            }

            protected String getDisplayString(Object value) {
                String rv = AbstractFacetSet.this.getCurrentFacetValue() != null ? (AbstractFacetSet.this.getCurrentFacetValue().isFixedByParent() ? "</a>" + FORM_FIXED_BY + "<a nowrap=\"true\" href=\"val\">" + ((XSDSimpleTypeDefinition)value).getName() : (AbstractFacetSet.this.getCurrentFacetValue().isDefault() ? "</a>" + FORM_INHERIT_FROM + "<a nowrap=\"true\" href=\"val\">" + ((XSDSimpleTypeDefinition)value).getName() : "</a>" + FORM_OVERRIDES + "<a nowrap=\"true\" href=\"val\">" + ((XSDSimpleTypeDefinition)value).getName())) : null;
                return rv;
            }

            protected void valueClicked(Object value) {
                GUIFacetHelper.showObject((EObject)value);
            }
        };
        this.inherit.setEditible(false);
        this.inherit.addControl(FormUtil.getScrolledForm((Control)parent), parent, ftk);
        this.inherit.setValue((Object)this.currentFV.type);
        twd = new TableWrapData(256, 16);
        this.inherit.getFormText().setLayoutData((Object)twd);
    }

    private void init() {
        if (this.myList == null) {
            this.currentFV = new FacetValue();
            this.myList = new MyListener();
        }
    }

    protected void addMonitor(ComponentSetMonitor monitor) {
        this.init();
        this.myList.mon = monitor;
    }

    protected void removeMonitor(ComponentSetMonitor monitor) {
        this.init();
        this.myList.mon = null;
    }

    protected FacetValue getCurrentFacetValue() {
        return this.currentFV;
    }

    public FacetValue getFacetValue() {
        return this.currentFV.cloneValue();
    }

    public void setValue(Object o) {
        this.init();
        if (o instanceof FacetValue) {
            FacetValue fv = (FacetValue)o;
            this.currentFV.copyValuesOf(fv);
            this.updateGUI(this.currentFV);
        } else {
            this.currentFV.defaultValue = o;
            if (o == null) {
                this.currentFV.clear();
            }
            this.updateGUI(this.currentFV);
        }
    }

    void updateGUI(FacetValue fv) {
        if (GUIFacetHelper.isReady((Control)this.dft)) {
            if (fv != null) {
                this.setEditible(true);
                if (fv.value != null) {
                    this.setMainValue(fv.value);
                } else {
                    this.setMainValue(fv.defaultValue);
                }
                if (this.fixed != null) {
                    this.fixed.setSelection(fv.isFixedLocal);
                }
                this.dft.setSelection(fv.isDefault());
                this.updateDescription(fv);
                if (fv.isInherited()) {
                    this.inherit.setValue((Object)fv.facet.getSimpleTypeDefinition());
                } else {
                    this.inherit.setValue(null);
                }
            } else {
                this.setEditible(true);
                this.setMainValue(null);
                this.dft.setSelection(true);
                if (this.fixed != null) {
                    this.fixed.setSelection(false);
                }
                if (this.desc != null) {
                    this.desc.setValue(null);
                }
            }
        }
    }

    void updateDescription(FacetValue fv) {
        if (this.desc != null && GUIFacetHelper.isReady((Control)this.desc.getFormText())) {
            if ("".equals(fv.description)) {
                this.desc.setValue(null);
            } else {
                this.desc.setValue((Object)fv.description);
            }
            this.desc.updateText();
            this.desc.setEditible(this.enabled && !fv.isFixedByParent());
        }
    }

    void updateDefault() {
        if (GUIFacetHelper.isReady((Control)this.dft)) {
            this.dft.setSelection(this.currentFV.isDefault());
        }
    }

    public boolean isUserSet() {
        return this.currentFV.isDefault();
    }

    public void reset() {
        this.currentFV.resetToDefault();
        this.currentFV.isFixedLocal = false;
        this.updateGUI(this.currentFV);
    }

    public int getControlCount() {
        return this.controlCount;
    }

    public void setEditible(boolean newEnabled) {
        this.init();
        this.enabled = newEnabled && !this.currentFV.isFixedByParent();
        super.setEditible(this.enabled);
        if (this.desc != null) {
            this.desc.getFormText().setEnabled(true);
            this.desc.setEditible(this.enabled);
        }
        if (this.inherit != null) {
            this.inherit.getFormText().setEnabled(true);
        }
    }

    class MyListener
    implements SelectionListener,
    ComponentSetMonitor {
        public ComponentSetMonitor mon;
        private Object lastVal;

        MyListener() {
        }

        public void fireUpdate(boolean delete) {
            if (this.mon != null) {
                this.mon.update(new ComponentSetEvent((LinkedComponentSet)AbstractFacetSet.this, delete, (Object)AbstractFacetSet.this.getCurrentFacetValue()));
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == AbstractFacetSet.this.dft) {
                this.fireUpdate(true);
                AbstractFacetSet.this.dft.setSelection(true);
                AbstractFacetSet.this.updateGUI(AbstractFacetSet.this.getCurrentFacetValue());
                AbstractFacetSet.this.getCurrentFacetValue().resetToDefault();
                this.lastVal = AbstractFacetSet.this.getCurrentFacetValue().defaultValue;
            } else if (e.widget == AbstractFacetSet.this.fixed) {
                AbstractFacetSet.this.getCurrentFacetValue().isFixedLocal = AbstractFacetSet.this.fixed.getSelection();
                this.fireUpdate(false);
                AbstractFacetSet.this.dft.setSelection(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void update(ComponentSetEvent event) {
            if (event.isDelete || event.value instanceof FacetValue || !FormUtil.safeEquals((Object)event.value, (Object)this.lastVal)) {
                AbstractFacetSet.this.getCurrentFacetValue().value = event.value;
                this.lastVal = event.value;
                this.fireUpdate(event.isDelete);
                AbstractFacetSet.this.updateDefault();
                if (event.isDelete) {
                    this.lastVal = null;
                }
                AbstractFacetSet.this.updateDescription(AbstractFacetSet.this.getCurrentFacetValue());
            }
        }
    }
}

