/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class LabelSection
extends Section {
    private String oldValue;
    protected Label label;
    private int style = -1;
    private boolean fillLabel = false;
    private int width = -1;
    private int height = -1;

    public LabelSection(String text, Composite parent, boolean formStyle) {
        super(text, parent, formStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public void layout() {
        GridData gd = (GridData)this.label.getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillLabel;
        }
        if (this.height > -1) {
            gd.heightHint = this.width;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        } else {
            gd.grabExcessVerticalSpace = this.fillLabel;
            if (this.fillLabel) {
                gd.verticalAlignment = 4;
                if (this.displayLabel != null) {
                    gd = (GridData)this.displayLabel.getLayoutData();
                    gd.verticalAlignment = 16;
                }
            }
        }
    }

    public String getStringValue() {
        if (this.label != null) {
            return this.label.getText();
        }
        return null;
    }

    public Label getLabelControl() {
        return this.label;
    }

    protected Label getLabelControl(Composite parent) {
        if (this.label == null) {
            this.label = this.style != -1 ? FormWidgetFactory.getInstance().createLabel(parent, this.style, this.isFormStyle) : FormWidgetFactory.getInstance().createLabel(parent, 64, this.isFormStyle);
            this.label.setText(this.getLabelText());
            this.label.setLayoutData((Object)new GridData());
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LabelSection.this.label = null;
                }
            });
        } else {
            this.checkParent((Control)this.label, parent);
        }
        return this.label;
    }

    public void setFocus() {
        if (this.label != null) {
            this.label.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.label != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.label.getText();
            if (!this.oldValue.equals(value)) {
                this.label.setText(value);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillLabel() {
        return this.fillLabel;
    }

    public void setFillLabel(boolean fillLabel) {
        this.fillLabel = fillLabel;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.label != null) {
            WidgetUtil.setExcludeGridData((Control)this.label, (boolean)isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.label != null) {
            this.label.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void load() {
    }

    public void setInput(Object input) {
    }
}

