/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FontStylePropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FontStyleSection
extends Section {
    private boolean showLabel = false;
    protected FontStylePropertyDescriptor fontStyle;
    protected IDescriptorProvider[] providers;
    private int width = -1;
    private int height = -1;
    private boolean fillFontStyle;

    public FontStyleSection(Composite parent, boolean isFormStyle) {
        super(" ", parent, isFormStyle);
    }

    public FontStyleSection(Composite parent, boolean isFormStyle, boolean showLable) {
        super(" ", parent, isFormStyle);
        this.showLabel = showLable;
    }

    public FontStyleSection(Composite parent, String title, boolean isFormStyle) {
        super(title, parent, isFormStyle);
    }

    public void createSection() {
        if (this.showLabel) {
            this.getLabelControl(this.parent);
        }
        this.getFontStyleControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public FontStylePropertyDescriptor getFontStyleControl() {
        return this.fontStyle;
    }

    protected FontStylePropertyDescriptor getFontStyleControl(Composite parent) {
        if (this.fontStyle == null) {
            this.fontStyle = DescriptorToolkit.createFontStylePropertyDescriptor(this.isFormStyle);
            if (this.getProviders() != null) {
                this.fontStyle.setProviders(this.getProviders());
            }
            this.fontStyle.createControl(parent);
            this.fontStyle.getControl().setLayoutData((Object)new GridData());
            this.fontStyle.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontStyleSection.this.fontStyle = null;
                }
            });
        } else {
            this.checkParent(this.fontStyle.getControl(), parent);
        }
        return this.fontStyle;
    }

    public void load() {
        if (this.fontStyle != null && !this.fontStyle.getControl().isDisposed()) {
            this.fontStyle.load();
        }
    }

    public void reset() {
        if (this.fontStyle != null && !this.fontStyle.getControl().isDisposed()) {
            this.fontStyle.reset();
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        this.fontStyle.setInput(input);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.displayLabel != null) {
            this.fontStyle.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.fontStyle != null) {
            this.fontStyle.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public IDescriptorProvider[] getProviders() {
        return this.providers;
    }

    public void setProviders(IDescriptorProvider[] providers) {
        this.providers = providers;
    }

    public void layout() {
        GridData gd = (GridData)this.fontStyle.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillFontStyle;
        }
        if (this.height > -1) {
            gd.heightHint = this.width;
            gd.grabExcessVerticalSpace = false;
            if (this.displayLabel != null) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 16;
            }
        } else {
            gd.grabExcessVerticalSpace = this.fillFontStyle;
            if (this.fillFontStyle) {
                gd.verticalAlignment = 4;
                if (this.displayLabel != null) {
                    gd = (GridData)this.displayLabel.getLayoutData();
                    gd.verticalAlignment = 16;
                }
            }
        }
    }

    public boolean isFillText() {
        return this.fillFontStyle;
    }

    public void setFillText(boolean fillFontStyle) {
        this.fillFontStyle = fillFontStyle;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

