/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyTitle;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AdvancePropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AdvancePropertySection
extends Section {
    boolean isTabbed = false;
    private boolean showLabel = false;
    protected AdvancePropertyDescriptor descriptor;
    protected TabbedPropertyTitle title;
    int displayLabelStyle = 512;
    IDescriptorProvider provider;
    private int height = -1;
    private int width = -1;
    boolean fillControl = false;

    public AdvancePropertySection(String labelText, Composite parent, boolean isControlStyle) {
        super(labelText, parent, isControlStyle);
    }

    public AdvancePropertySection(String labelText, Composite parent, boolean isControlStyle, boolean isTabbed) {
        super(labelText, parent, isControlStyle);
        this.isTabbed = isTabbed;
    }

    public void showDisplayLabel(boolean show) {
        this.showLabel = show;
    }

    public void createSection() {
        if (this.isTabbed) {
            this.getTitleControl(this.parent);
        } else if (this.showLabel) {
            this.getLabelControl(this.parent);
        }
        this.getControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public TabbedPropertyTitle getTitleControl() {
        return this.title;
    }

    protected TabbedPropertyTitle getTitleControl(Composite parent) {
        if (this.title == null) {
            this.title = new TabbedPropertyTitle(parent, FormWidgetFactory.getInstance());
            this.title.setLayoutData((Object)new GridData(768));
            this.title.setFont(parent.getFont());
            this.title.setLayoutData((Object)new GridData());
            String text = this.getLabelText();
            if (text != null) {
                this.title.setTitle(text, null);
            }
            this.title.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AdvancePropertySection.this.title = null;
                }
            });
        } else {
            this.checkParent((Control)this.title, parent);
        }
        return this.title;
    }

    public AdvancePropertyDescriptor getControl() {
        return this.descriptor;
    }

    protected AdvancePropertyDescriptor getControl(Composite parent) {
        if (this.descriptor == null) {
            this.descriptor = DescriptorToolkit.createAdvancePropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.descriptor.setDescriptorProvider(this.getProvider());
            }
            this.descriptor.createControl(parent);
            this.descriptor.getControl().setLayoutData((Object)new GridData());
            this.descriptor.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AdvancePropertySection.this.descriptor = null;
                }
            });
        } else {
            this.checkParent(this.descriptor.getControl(), parent);
        }
        return this.descriptor;
    }

    public void setDisplayLabelStyle(int style) {
        this.displayLabelStyle = style;
    }

    public void layout() {
        GridData gd = (GridData)this.descriptor.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.displayLabel != null && (this.displayLabelStyle & 0x100) != 0) {
            --gd.horizontalSpan;
        }
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillControl;
        }
        if (this.height > -1) {
            gd.heightHint = this.height;
            gd.grabExcessVerticalSpace = false;
        } else {
            gd.grabExcessVerticalSpace = this.fillControl;
        }
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 4;
        if (this.displayLabel != null) {
            if ((this.displayLabelStyle & 0x200) != 0) {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
            } else {
                gd = (GridData)this.displayLabel.getLayoutData();
                gd.verticalAlignment = 1;
            }
        }
        if (this.title != null) {
            gd = (GridData)this.title.getLayoutData();
            gd.horizontalSpan = ((GridLayout)this.parent.getLayout()).numColumns;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
    }

    public void load() {
        if (this.descriptor != null && !this.descriptor.getControl().isDisposed()) {
            this.descriptor.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.descriptor != null) {
            this.descriptor.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.descriptor.setInput(input);
    }

    public boolean isFillControl() {
        return this.fillControl;
    }

    public void setFillControl(boolean fillControl) {
        this.fillControl = fillControl;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.title != null) {
            WidgetUtil.setExcludeGridData((Control)this.title, (boolean)isHidden);
        }
        if (this.descriptor != null) {
            this.descriptor.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.title != null) {
            this.title.setVisible(isVisible);
        }
        if (this.descriptor != null) {
            this.descriptor.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

