/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.AddResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class JsFileFormProvider
extends AbstractFormHandleProvider {
    private static final int[] COLUMN_WIDTHS = new int[]{300};
    private static final String[] COLUMNS = new String[]{Messages.getString((String)"JsFileFormProvider.Column.Name")};
    private static final String TITLE = Messages.getString((String)"ReportPageGenerator.List.Resources.JsFile");
    private static final String EMPTY_STRING = "";
    private ModuleHandle inputElement;

    public String[] getColumnNames() {
        return COLUMNS;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public String getDisplayName() {
        return TITLE;
    }

    public CellEditor[] getEditors(Table table) {
        return null;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        this.inputElement.shifIncludeScripts(oldPos, newPos);
        return true;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        if (this.getElements(this.inputElement).length <= 0) {
            return false;
        }
        IncludeScriptHandle includeScriptHandle = (IncludeScriptHandle)this.getElements(this.inputElement)[pos];
        if (includeScriptHandle != null && includeScriptHandle.getStructure() != null && includeScriptHandle.getStructure() instanceof IncludeScript) {
            IncludeScript includeSript = (IncludeScript)includeScriptHandle.getStructure();
            this.inputElement.dropIncludeScript(includeSript);
        }
        return true;
    }

    public boolean isDeleteEnable(Object selectedObject) {
        IncludeScriptHandle includeScriptHandle;
        return !(selectedObject instanceof StructuredSelection) || ((StructuredSelection)selectedObject).isEmpty() || (includeScriptHandle = (IncludeScriptHandle)((StructuredSelection)selectedObject).getFirstElement()).getElementHandle() == this.inputElement;
    }

    public boolean isUpEnable(Object selectedObject) {
        if (selectedObject instanceof StructuredSelection && !((StructuredSelection)selectedObject).isEmpty()) {
            IncludeScriptHandle nextHandle;
            IncludeScriptHandle includeScriptHandle = (IncludeScriptHandle)((StructuredSelection)selectedObject).getFirstElement();
            if (includeScriptHandle.getElementHandle() != this.inputElement) {
                return false;
            }
            List<Object> handles = Arrays.asList(this.getElements(this.inputElement));
            int index = -1;
            int i = 0;
            while (i < handles.size()) {
                IncludeScriptHandle handle = (IncludeScriptHandle)handles.get(i);
                if (handle.getFileName().equals(includeScriptHandle.getFileName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index > 0 && (nextHandle = (IncludeScriptHandle)handles.get(index - 1)).getElementHandle() != this.inputElement) {
                return false;
            }
        }
        return true;
    }

    public boolean isDownEnable(Object selectedObject) {
        if (selectedObject instanceof StructuredSelection && !((StructuredSelection)selectedObject).isEmpty()) {
            IncludeScriptHandle nextHandle;
            IncludeScriptHandle includeScriptHandle = (IncludeScriptHandle)((StructuredSelection)selectedObject).getFirstElement();
            if (includeScriptHandle.getElementHandle() != this.inputElement) {
                return false;
            }
            List<Object> handles = Arrays.asList(this.getElements(this.inputElement));
            int index = -1;
            int i = 0;
            while (i < handles.size()) {
                IncludeScriptHandle handle = (IncludeScriptHandle)handles.get(i);
                if (handle.getFileName().equals(includeScriptHandle.getFileName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (handles.size() > index + 1 && (nextHandle = (IncludeScriptHandle)handles.get(index + 1)).getElementHandle() != this.inputElement) {
                return false;
            }
        }
        return true;
    }

    public boolean doAddItem(int pos) throws Exception {
        AddResourceFileFolderSelectionDialog dialog = new AddResourceFileFolderSelectionDialog(new String[]{"*.js"}, new String[]{".js"});
        dialog.setHelpDialogId("org.eclipse.birt.cshelp.AddJsResourceFileFolderSelectionDialog_ID");
        dialog.setExistFiles(this.getElmentNames(this.inputElement));
        if (dialog.open() != 0) {
            return false;
        }
        Object[] selection = dialog.getResult();
        int length = selection.length;
        int i = 0;
        while (i < length) {
            String fileName = dialog.getPath(i);
            IncludeScript script = StructureFactory.createIncludeScript();
            script.setFileName(fileName);
            this.inputElement.addIncludeScript(script);
            ++i;
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        return false;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IncludeScriptHandle) {
            IncludeScriptHandle srcriptHandle = (IncludeScriptHandle)element;
            if (columnIndex == 0) {
                return srcriptHandle.getFileName();
            }
        }
        return EMPTY_STRING;
    }

    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList list = new ArrayList();
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).get(0);
        }
        if (inputElement instanceof ModuleHandle) {
            this.inputElement = (ModuleHandle)inputElement;
            list = (ArrayList)((ModuleHandle)inputElement).getAllIncludeScripts();
            if (list == null || list.size() == 0) {
                return new IncludeScriptHandle[0];
            }
        }
        return list.toArray();
    }

    private String[] getElmentNames(Object inputElement) {
        Object[] obj = this.getElements(inputElement);
        String[] names = new String[obj.length];
        int i = 0;
        while (i < names.length) {
            names[i] = ((IncludeScriptHandle)obj[i]).getFileName();
            ++i;
        }
        return names;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        return null;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    public boolean needRefreshed(NotificationEvent event) {
        if (!(event instanceof PropertyEvent)) {
            return false;
        }
        PropertyEvent propertyEvent = (PropertyEvent)event;
        return propertyEvent.getPropertyName().equals("includeScripts");
    }
}

