/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.AccordionPropertyList;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IPropertyList;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.Tab;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyList;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TabbedPropertyTitle;
import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CategoryPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ResetAttributePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.ICategoryPage;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BaseAttributePage
extends TabPage {
    private IPropertyList categoryList;
    private Composite infoPane;
    private ICategoryProvider categoryProvider;
    private static int s_lastSelectedIndex = 0;
    private static String s_lastSelectedKey = null;
    private Object input;
    private HashMap pageMap;
    private ScrolledComposite sComposite;
    private TabPage currentPage = null;
    private TabbedPropertyTitle title;
    Composite container;
    private int style;
    private TabPage oldPage = null;

    public BaseAttributePage() {
        this.style = 256;
    }

    public BaseAttributePage(int style) {
        this.style = style;
    }

    public void buildUI(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        if (this.style == 256) {
            this.createHorizontalView();
        } else {
            this.createVerticalView();
        }
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BaseAttributePage.this.pageMap != null) {
                    for (Object value : BaseAttributePage.this.pageMap.values()) {
                        TabPage page = (TabPage)value;
                        if (page == null) continue;
                        page.dispose();
                    }
                }
            }
        });
    }

    protected void createVerticalView() {
        this.categoryList = new AccordionPropertyList(this.container);
        GridData gd = new GridData(1808);
        this.categoryList.getControl().setLayoutData((Object)gd);
        this.categoryList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (BaseAttributePage.this.categoryList.getSelectionIndex() > -1) {
                    s_lastSelectedIndex = BaseAttributePage.this.categoryList.getSelectionIndex();
                    s_lastSelectedKey = BaseAttributePage.this.categoryList.getSelectionKey();
                }
                BaseAttributePage.this.processListSelected();
            }
        });
        this.setCategoryProvider(this.categoryProvider);
    }

    protected void createHorizontalView() {
        this.categoryList = new TabbedPropertyList(this.container);
        GridData gd = new GridData(1040);
        gd.verticalSpan = 2;
        this.categoryList.getControl().setLayoutData((Object)gd);
        this.categoryList.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (BaseAttributePage.this.categoryList.getSelectionIndex() > -1) {
                    s_lastSelectedIndex = BaseAttributePage.this.categoryList.getSelectionIndex();
                    s_lastSelectedKey = BaseAttributePage.this.categoryList.getSelectionKey();
                }
                BaseAttributePage.this.processListSelected();
            }
        });
        this.setCategoryProvider(this.categoryProvider);
        this.title = new TabbedPropertyTitle(this.container, FormWidgetFactory.getInstance());
        this.title.setLayoutData((Object)new GridData(768));
        this.title.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (BaseAttributePage.this.currentPage != null && BaseAttributePage.this.currentPage instanceof ResetAttributePage) {
                    CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans(Messages.getString((String)"BaseAttributePage.CommandStack.ResetStyle.Message"));
                    ((ResetAttributePage)BaseAttributePage.this.currentPage).reset();
                    stack.commit();
                }
            }
        });
        this.sComposite = new ScrolledComposite(this.container, 768);
        this.sComposite.setLayoutData((Object)new GridData(1808));
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.sComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                BaseAttributePage.this.computeSize();
            }
        });
        this.infoPane = new Composite((Composite)this.sComposite, 0);
        this.sComposite.setContent((Control)this.infoPane);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.infoPane.setLayout((Layout)layout);
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BaseAttributePage.this.pageMap != null) {
                    for (Object value : BaseAttributePage.this.pageMap.values()) {
                        TabPage page = (TabPage)value;
                        if (page == null) continue;
                        page.dispose();
                    }
                }
            }
        });
    }

    private void computeSize() {
        if (this.style == 256) {
            this.sComposite.setMinSize(this.infoPane.computeSize(-1, -1));
            this.infoPane.layout();
        }
    }

    private void processListSelected() {
        TabPage page;
        if (this.categoryProvider == null) {
            return;
        }
        int index = this.categoryList.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.style == 256) {
            this.title.setTitle(this.getCategoryTitle(this.categoryList.getSelectionIndex()), null);
        }
        if ((page = this.getCategoryPane(this.categoryList.getSelectionIndex())) == null) {
            return;
        }
        if (this.oldPage != page) {
            if (this.style == 256) {
                if (page instanceof AttributePage) {
                    ((AttributePage)page).addPropertyChangeListener((IPropertyChangeListener)this.title);
                    Object adapter = ((AttributePage)page).getAdapter(IAction.class);
                    if (adapter instanceof IAction[]) {
                        this.title.setActions((IAction[])adapter);
                    } else {
                        this.title.setActions(null);
                    }
                } else {
                    this.title.setActions(null);
                }
            }
            this.showPage(page);
            this.oldPage = page;
        }
    }

    private void showPage(TabPage page) {
        if (page != this.currentPage) {
            if (this.currentPage != null) {
                ((GridData)this.currentPage.getControl().getLayoutData()).exclude = true;
                this.currentPage.getControl().setVisible(false);
            }
            ((GridData)page.getControl().getLayoutData()).exclude = false;
            page.getControl().setVisible(true);
            this.currentPage = page;
            this.computeSize();
        }
    }

    protected void selectStickyCategory() {
        if (s_lastSelectedKey != null && s_lastSelectedIndex != -1) {
            this.categoryList.setSelection(s_lastSelectedKey, s_lastSelectedIndex);
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void refresh() {
        this.selectStickyCategory();
        this.processListSelected();
    }

    public void setCategoryProvider(ICategoryProvider categoryProvider) {
        this.categoryProvider = categoryProvider;
        if (categoryProvider == null) {
            return;
        }
        if (this.categoryList == null) {
            return;
        }
        ICategoryPage[] pages = categoryProvider.getCategories();
        if (pages.length != 0) {
            SortMap categoryLabels = new SortMap();
            int i = 0;
            while (i < pages.length) {
                Tab tab = new Tab();
                tab.setText(pages[i].getDisplayLabel());
                categoryLabels.put((Object)pages[i].getCategoryKey(), (Object)tab);
                ++i;
            }
            this.categoryList.setElements((Map)categoryLabels);
            if (((Composite)this.categoryList.getControl()).getTabList().length > 0) {
                this.categoryList.setSelection(null, 0);
            }
        }
    }

    private TabPage getCategoryPane(int index) {
        String key;
        TabPage page;
        if (this.pageMap == null) {
            this.pageMap = new HashMap(this.categoryProvider.getCategories().length);
        }
        if ((page = (TabPage)this.pageMap.get(key = Integer.toString(index))) == null) {
            page = this.categoryProvider.getCategories()[index].createPage();
            page.setInput(this.input);
            if (this.style == 256) {
                page.buildUI(this.infoPane);
            } else {
                this.infoPane = (Composite)this.categoryList.getItem(index).getData();
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                this.infoPane.setLayout((Layout)layout);
                page.buildUI(this.infoPane);
                FormData fd = (FormData)this.infoPane.getLayoutData();
                int height = this.infoPane.computeSize((int)-1, (int)-1).y;
                if (height > 0) {
                    fd.height = height;
                }
                this.infoPane.layout();
            }
        } else {
            page.setInput(this.input);
        }
        page.getControl().setLayoutData((Object)new GridData(1808));
        page.refresh();
        this.pageMap.put(key, page);
        return page;
    }

    private String getCategoryTitle(int index) {
        ICategoryPage page = this.categoryProvider.getCategories()[index];
        String title = null;
        if (page instanceof CategoryPage) {
            title = ((CategoryPage)page).getDisplayTitle();
        }
        if (title == null) {
            title = page.getDisplayLabel();
        }
        return title;
    }

    public void dispose() {
        this.container.dispose();
    }

    public Control getControl() {
        return this.container;
    }

    static /* synthetic */ int access$2() {
        return s_lastSelectedIndex;
    }

    static /* synthetic */ String access$4() {
        return s_lastSelectedKey;
    }
}

