/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.bpm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LoggerType implements Enumerator
{
    CONSOLE(0, "CONSOLE", "CONSOLE"),
    FILE(1, "FILE", "FILE"),
    THREADEDFILE(2, "THREADEDFILE", "THREADED_FILE");

    public static final int CONSOLE_VALUE = 0;
    public static final int FILE_VALUE = 1;
    public static final int THREADEDFILE_VALUE = 2;
    private static final LoggerType[] VALUES_ARRAY;
    public static final List<LoggerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LoggerType[]{CONSOLE, FILE, THREADEDFILE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LoggerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoggerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoggerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LoggerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LoggerType get(int value) {
        switch (value) {
            case 0: {
                return CONSOLE;
            }
            case 1: {
                return FILE;
            }
            case 2: {
                return THREADEDFILE;
            }
        }
        return null;
    }

    private LoggerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

