/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.util;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbModelEntry;

public class RestVdbUtil {
    public static final String VDB_EXTENSION = "vdb";
    private static final ModelObjectAnnotationHelper ANNOTATION_HELPER = new ModelObjectAnnotationHelper();

    public static boolean isRestWarVdb(IFile vdbFile) throws Exception {
        if (!RestVdbUtil.isVdb(vdbFile)) {
            return false;
        }
        boolean result = false;
        try {
            Vdb vdb = new Vdb(vdbFile, (IProgressMonitor)new NullProgressMonitor());
            Set modelEntrySet = vdb.getModelEntries();
            for (VdbModelEntry vdbModelEntry : modelEntrySet) {
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(vdbModelEntry.getName());
                if (!ModelIdentifier.isVirtualModelType((ModelResource)modelResource) || !(result = RestVdbUtil.hasRestProcedures(modelResource))) {
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            new RuntimeException(ex);
        }
        return result;
    }

    private static boolean isVdb(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IFile)) {
            return false;
        }
        return VDB_EXTENSION.equals(((IFile)obj).getFileExtension());
    }

    private static boolean hasRestProcedures(ModelResource modelResource) throws Exception {
        List eObjectList = modelResource.getEObjects();
        boolean result = false;
        block0: for (EObject eObject : eObjectList) {
            if (!SqlAspectHelper.isProcedure((EObject)eObject)) continue;
            IPath path = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(eObject);
            StringBuffer sb = new StringBuffer();
            String[] segments = path.segments();
            int i = 0;
            while (i < segments.length) {
                if (i != 0) {
                    sb.append('.');
                }
                String segment = segments[i];
                sb.append(segment);
                Procedure procedure = (Procedure)eObject;
                String restMethod = RestVdbUtil.getRestMethod(procedure);
                String uri = null;
                if (restMethod != null) {
                    uri = RestVdbUtil.getUri(procedure);
                }
                if (uri != null && restMethod != null) {
                    result = true;
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    public static String getUri(Procedure procedure) {
        String uri = null;
        try {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            uri = assistant.getPropertyValue((Object)procedure, RestModelExtensionConstants.PropertyIds.URI);
            if (CoreStringUtil.isEmpty((String)uri)) {
                uri = (String)ANNOTATION_HELPER.getPropertyValueAnyCase((EObject)procedure, "ext-custom:URI");
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
        }
        return uri;
    }

    public static String getRestMethod(Procedure procedure) {
        String restMethod = null;
        try {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            restMethod = assistant.getPropertyValue((Object)procedure, RestModelExtensionConstants.PropertyIds.REST_METHOD);
            if (CoreStringUtil.isEmpty((String)restMethod.trim())) {
                restMethod = (String)ANNOTATION_HELPER.getPropertyValueAnyCase((EObject)procedure, "ext-custom:REST-METHOD");
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
        }
        return restMethod;
    }
}

