/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.ui.Messages;
import org.teiid.designer.vdb.ui.editor.VdbEditor;
import org.teiid.designer.vdb.ui.util.VdbUiRefactorHandler;

public class VdbModelPathResolution
implements IMarkerResolution {
    public String getLabel() {
        return Messages.synchronizeVdbLabel;
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (this.isVdbFile(resource)) {
            final IFile theVdbFile = (IFile)resource;
            VdbEditor editor = VdbUiRefactorHandler.getVdbEditorForFile((IResource)theVdbFile);
            if (editor != null) {
                String message = NLS.bind((String)Messages.fixVdbPath_OpenEditorMessage, (Object)theVdbFile.getName());
                boolean result = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.fixVdbPath_OpenEditorTitle, (String)message);
                if (!result) {
                    return;
                }
                VdbUiRefactorHandler.closeVdbEditor(editor);
            }
            final Exception[] theException = new Exception[1];
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        VdbModelPathResolution.this.fixVdb(theVdbFile);
                    }
                    catch (Exception ex) {
                        theException[0] = ex;
                    }
                }
            });
            if (theException[0] != null) {
                ErrorHandler.toExceptionDialog((Throwable)theException[0]);
            }
        }
    }

    void fixVdb(IFile theVdb) throws Exception {
        VdbUtil.synchronizeVdb((IFile)theVdb, (boolean)false, (boolean)true);
    }

    private boolean isVdbFile(IResource resource) {
        return resource.getType() == 1 && "vdb".equals(resource.getFileExtension()) && resource.exists();
    }
}

