/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.Utils;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.wizards.ServerWizard;
import org.modeshape.web.jcr.rest.client.Status;

public final class ServerPage
extends WizardPage {
    private Button btnTestConnection;
    private String password;
    private boolean savePassword;
    private ModeShapeServer server;
    private Status status;
    private String url;
    private String user;

    public ServerPage() {
        super(ServerPage.class.getSimpleName());
        this.setTitle(RestClientI18n.serverPageTitle);
        this.setPageComplete(false);
    }

    public ServerPage(ModeShapeServer server) {
        super(ServerPage.class.getSimpleName());
        this.setTitle(RestClientI18n.serverPageTitle);
        this.server = server;
        this.url = server.getOriginalUrl();
        this.user = server.getUser();
        this.password = server.getPassword();
        this.savePassword = server.isPasswordBeingPersisted();
    }

    private void constructAuthenticationPanel(Composite parent) {
        Group pnl = new Group(parent, 0);
        pnl.setText(RestClientI18n.serverPageAuthenticationGroupTitle);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblUser = new Label((Composite)pnl, 16384);
        lblUser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblUser.setText(RestClientI18n.serverPageUserLabel);
        Text txtUser = new Text((Composite)pnl, 2048);
        txtUser.setLayoutData((Object)new GridData(4, 128, true, false));
        txtUser.setToolTipText(RestClientI18n.serverPageUserToolTip);
        if (this.user != null) {
            txtUser.setText(this.user);
        }
        txtUser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPage.this.handleUserModified(((Text)e.widget).getText());
            }
        });
        Label lblPassword = new Label((Composite)pnl, 16384);
        lblPassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblPassword.setText(RestClientI18n.serverPagePasswordLabel);
        Text txtPassword = new Text((Composite)pnl, 2048);
        txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtPassword.setToolTipText(RestClientI18n.serverPagePasswordToolTip);
        txtPassword.setEchoChar('*');
        if (this.password != null) {
            txtPassword.setText(this.password);
        }
        txtPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPage.this.handlePasswordModified(((Text)e.widget).getText());
            }
        });
        final Button btn = new Button((Composite)pnl, 16416);
        btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ((GridData)btn.getLayoutData()).horizontalSpan = 2;
        btn.setText(RestClientI18n.serverPageSavePasswordButton);
        btn.setToolTipText(RestClientI18n.serverPageSavePasswordToolTip);
        if (this.savePassword) {
            btn.setSelection(true);
        }
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPage.this.handleSavePasswordChanged(((Button)e.widget).getSelection());
            }
        });
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPage.this.updateInitialMessage();
                btn.removeSelectionListener((SelectionListener)this);
            }
        });
        Label lblImage = new Label((Composite)pnl, 0);
        lblImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        lblImage.setImage(Display.getDefault().getSystemImage(2));
        StyledText st = new StyledText((Composite)pnl, 524362);
        st.setText(RestClientI18n.serverPageSavePasswordLabel);
        st.setBackground(Display.getDefault().getSystemColor(22));
        st.setCaret(null);
        st.setEnabled(false);
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.grabExcessVerticalSpace = false;
        gd.horizontalIndent = 4;
        gd.verticalIndent = 8;
        gd.widthHint = 100;
        st.setLayoutData((Object)gd);
    }

    private void constructTestConnectionPanel(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lbl = new Label(pnl, 16384);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lbl.setText(RestClientI18n.serverPageTestConnectionLabel);
        this.btnTestConnection = new Button(pnl, 8);
        this.btnTestConnection.setText(RestClientI18n.serverPageTestConnectionButton);
        this.btnTestConnection.setToolTipText(RestClientI18n.serverPageTestConnectionButtonToolTip);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = this.btnTestConnection.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x + 10);
        this.btnTestConnection.setLayoutData((Object)gd);
        this.btnTestConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPage.this.handleTestConnection();
            }
        });
    }

    private void constructUrlPanel(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblUrl = new Label(pnl, 16384);
        lblUrl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblUrl.setText(RestClientI18n.serverPageUrlLabel);
        Text txtUrl = new Text(pnl, 2048);
        txtUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtUrl.setToolTipText(RestClientI18n.serverPageUrlToolTip);
        if (this.url != null) {
            txtUrl.setText(this.url);
        }
        txtUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerPage.this.handleUrlModified(((Text)e.widget).getText());
            }
        });
        Label lblImage = new Label(pnl, 0);
        lblImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        lblImage.setImage(Activator.getDefault().getImage("icons/views/blank.gif"));
        StyledText st = new StyledText(pnl, 524362);
        st.setText(RestClientI18n.serverPageUrlTemplateLabel);
        st.setBackground(Display.getDefault().getSystemColor(22));
        st.setCaret(null);
        st.setEnabled(false);
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.grabExcessVerticalSpace = false;
        gd.horizontalIndent = 4;
        gd.verticalIndent = 8;
        gd.widthHint = 150;
        st.setLayoutData((Object)gd);
    }

    public void createControl(Composite parent) {
        Composite pnlMain = new Composite(parent, 0);
        pnlMain.setLayout((Layout)new GridLayout());
        pnlMain.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.constructUrlPanel(pnlMain);
        this.constructAuthenticationPanel(pnlMain);
        this.constructTestConnectionPanel(pnlMain);
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = Activator.getDefault().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.jboss.tools.modeshape.rest.serverDialogHelpContext");
    }

    public ModeShapeServer getServer() {
        if (!this.status.isError()) {
            return new ModeShapeServer(this.url, this.user, this.password, this.savePassword);
        }
        throw new RuntimeException(RestClientI18n.serverPageInvalidServerProperties);
    }

    ServerManager getServerManager() {
        return ((ServerWizard)this.getWizard()).getServerManager();
    }

    void handlePasswordModified(String newPassword) {
        this.password = newPassword;
        this.updateState();
    }

    void handleSavePasswordChanged(boolean savePassword) {
        this.savePassword = savePassword;
    }

    void handleTestConnection() {
        final ModeShapeServer server = this.getServer();
        final boolean[] success = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                success[0] = ServerPage.this.getServerManager().ping(server).isOk();
            }
        });
        if (success[0]) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RestClientI18n.serverPageTestConnectionDialogTitle, (String)RestClientI18n.serverPageTestConnectionDialogSuccessMsg);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)RestClientI18n.serverPageTestConnectionDialogTitle, (String)RestClientI18n.serverPageTestConnectionDialogFailureMsg);
        }
    }

    void handleUrlModified(String newUrl) {
        this.url = newUrl;
        this.updateState();
    }

    void handleUserModified(String newUser) {
        this.user = newUser;
        this.updateState();
    }

    void updateInitialMessage() {
        if (RestClientI18n.serverPageOkStatusMsg.equals(this.getMessage())) {
            this.updateState();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
            this.setMessage(RestClientI18n.serverPageOkStatusMsg);
        }
    }

    private void updateState() {
        this.validate();
        this.setPageComplete(!this.status.isError());
        if (this.status.isError()) {
            this.setMessage(this.status.getMessage(), 3);
        } else if (this.status.isWarning()) {
            this.setMessage(this.status.getMessage(), 2);
        } else if (this.status.isInfo()) {
            this.setMessage(this.status.getMessage(), 1);
        } else {
            this.setMessage(RestClientI18n.serverPageOkStatusMsg);
        }
    }

    private void validate() {
        this.status = Utils.isServerValid(this.url, this.user, this.password);
        if (this.status.isOk()) {
            ModeShapeServer changedServer = this.getServer();
            if ((this.server == null || !this.server.hasSameKey(changedServer)) && this.getServerManager().isRegistered(changedServer)) {
                this.status = new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.serverExistsMsg, (Object)changedServer.getShortDescription()), null);
            }
        }
        this.btnTestConnection.setEnabled(!this.status.isError());
    }
}

